/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.mixin;

import com.github.hoshinofw.buildstonetoolkit.core.BuildstoneToolkit;
import com.github.hoshinofw.buildstonetoolkit.mixin.BlockEntityAccessor;
import com.github.hoshinofw.buildstonetoolkit.util.PistonUtil;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import com.github.hoshinofw.buildstonetoolkit.util.mixin.PistonMovingBlockEntityMixinInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PistonMovingBlockEntity.class})
public abstract class PistonMovingBlockEntityMixin
implements PistonMovingBlockEntityMixinInterface {
    @Unique
    @Nullable
    public CompoundTag buildstonetoolkit$proxyTag = null;

    @Shadow
    public abstract Direction getDirection();

    @Shadow
    public abstract boolean isExtending();

    @Override
    @Unique
    public CompoundTag buildstonetoolkit$getProxyTag() {
        return this.buildstonetoolkit$proxyTag;
    }

    @Override
    @Unique
    public void buildstonetoolkit$setProxyTag(CompoundTag tag) {
        this.buildstonetoolkit$proxyTag = tag;
    }

    @Override
    @Unique
    public float buildstonetoolkit$getProgressO() {
        return ((BlockEntityAccessor)((Object)this)).getProgressO();
    }

    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/piston/PistonMovingBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", ordinal=1, shift=At.Shift.AFTER)})
    private static void postSetBlockInjectionInTick(@NotNull Level level, BlockPos finalPos, BlockState pistonMovingBlockState, PistonMovingBlockEntity mbe, CallbackInfo ci) {
        Direction moveDirection = Util.resolveDirection(mbe.getDirection(), mbe.isExtending());
        Direction fromDirection = moveDirection.getOpposite();
        BlockPos originalPos = finalPos.relative(fromDirection);
        PistonUtil.doProxyUpdatingLogic(level, mbe, moveDirection, originalPos, finalPos);
    }

    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/piston/PistonMovingBlockEntity;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/block/piston/PistonMovingBlockEntity;progressO:F", opcode=181, shift=At.Shift.AFTER)})
    private static void afterProgressUpdate(Level level, BlockPos finalPos, BlockState state, PistonMovingBlockEntity mbe, CallbackInfo ci) {
        if (level.isClientSide && ((PistonMovingBlockEntityMixinInterface)mbe).buildstonetoolkit$getProgressO() >= 1.0f) {
            Direction moveDirection = Util.resolveDirection(mbe.getDirection(), mbe.isExtending());
            Direction fromDirection = moveDirection.getOpposite();
            BlockPos originalPos = finalPos.relative(fromDirection);
            PistonUtil.doProxyUpdatingLogic(level, mbe, moveDirection, originalPos, finalPos);
        }
    }

    @Inject(method={"finalTick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", ordinal=0, shift=At.Shift.AFTER)})
    private void postSetBlockInjectionInFinalTick(CallbackInfo ci) {
        Level level = ((BlockEntity)this).getLevel();
        if (level == null) {
            return;
        }
        BlockPos finalPos = ((BlockEntity)this).getBlockPos();
        PistonMovingBlockEntity mbe = (PistonMovingBlockEntity)this;
        Direction moveDirection = Util.resolveDirection(this.getDirection(), this.isExtending());
        Direction fromDirection = moveDirection.getOpposite();
        BlockPos originalPos = finalPos.relative(fromDirection);
        PistonUtil.doProxyUpdatingLogic(level, mbe, moveDirection, originalPos, finalPos);
    }

    @Inject(method={"saveAdditional(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, at={@At(value="TAIL")})
    private void buildstonetoolkit$saveAdditional(CompoundTag tag, HolderLookup.Provider provider, CallbackInfo ci) {
        if (this.buildstonetoolkit$proxyTag != null) {
            tag.put("BuildstoneProxyTag", (Tag)this.buildstonetoolkit$proxyTag.copy());
        }
    }

    @Inject(method={"loadAdditional(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, at={@At(value="TAIL")})
    private void buildstonetoolkit$loadAdditional(CompoundTag tag, HolderLookup.Provider provider, CallbackInfo ci) {
        this.buildstonetoolkit$proxyTag = tag.contains("BuildstoneProxyTag", 10) ? tag.getCompound("BuildstoneProxyTag").copy() : null;
    }

    @Inject(method={"finalTick()V"}, at={@At(value="HEAD")})
    private void finalTick(CallbackInfo ci) {
        BuildstoneToolkit.LOGGER.info("finalTick called");
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void testCtor(BlockPos blockPos, BlockState blockState, BlockState blockState2, Direction direction, boolean bl, boolean bl2, CallbackInfo ci) {
    }
}

