/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.mixin;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PistonStructureResolver.class})
public abstract class PistonStructureResolverMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private Direction pushDirection;
    @Shadow
    @Final
    private BlockPos pistonPos;

    @Shadow
    protected abstract boolean addBlockLine(BlockPos var1, Direction var2);

    @Inject(method={"addBlockLine(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z", shift=At.Shift.BEFORE)}, cancellable=true)
    private void onAddBlockLine(BlockPos blockPos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        BlockPos targetPos;
        IProxyBlock pistonProxy;
        BlockState blockState = this.level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof IProxyBlock && (pistonProxy = (IProxyBlock)block).shouldTransferMovement(blockPos, blockState, direction) && (targetPos = pistonProxy.getLinkedBlockPos(this.level, blockPos)) != null && !targetPos.equals((Object)blockPos) && !this.addBlockLine(targetPos, direction)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

