/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.util;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyEntityBlock;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import com.github.hoshinofw.buildstonetoolkit.util.mixin.PistonMovingBlockEntityMixinInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import org.jetbrains.annotations.NotNull;

public class PistonUtil {
    public static void doProxyUpdatingLogic(@NotNull Level level, PistonMovingBlockEntity mbe, Direction moveDirection, BlockPos originalPos, BlockPos finalPos) {
        Block block = mbe.getMovedState().getBlock();
        if (block instanceof IProxyBlock) {
            IProxyBlock proxyBlock = (IProxyBlock)block;
            if (proxyBlock.shouldPreserveTargetAbsPos(level, mbe, originalPos, finalPos, moveDirection)) {
                if (proxyBlock instanceof IProxyEntityBlock) {
                    IProxyEntityBlock entityBlock = (IProxyEntityBlock)((Object)proxyBlock);
                    newState = entityBlock.computeNewStateWithPreservedTargetAbsPos(level, originalPos, Util.getProxyTag(mbe), mbe.getMovedState(), moveDirection);
                    level.setBlock(finalPos, newState, 3);
                    proxyBlock.neighborChanged(newState, level, finalPos, (Block)proxyBlock, finalPos, true);
                    BlockEntity blockEntity = level.getBlockEntity(finalPos);
                    CompoundTag savedTag = Util.getProxyTag(mbe);
                    if (blockEntity != null && savedTag != null) {
                        CompoundTag newNBT = entityBlock.computeNewNBTWithPreservedTargetAbsPos(level, finalPos, newState, savedTag, moveDirection);
                        blockEntity.loadCustomOnly(newNBT, (HolderLookup.Provider)level.registryAccess());
                        blockEntity.setChanged();
                    }
                } else {
                    newState = proxyBlock.computeNewStateWithPreservedTargetAbsPos(level, originalPos, mbe.getMovedState(), moveDirection);
                    level.setBlock(finalPos, newState, 3);
                    proxyBlock.neighborChanged(newState, level, finalPos, (Block)proxyBlock, finalPos, true);
                }
            } else {
                level.setBlock(finalPos, mbe.getMovedState(), 3);
                proxyBlock.neighborChanged(mbe.getMovedState(), level, finalPos, (Block)proxyBlock, finalPos, true);
                if (proxyBlock instanceof IProxyEntityBlock) {
                    BlockEntity blockEntity = level.getBlockEntity(finalPos);
                    CompoundTag savedTag = ((PistonMovingBlockEntityMixinInterface)mbe).buildstonetoolkit$getProxyTag();
                    if (blockEntity != null && savedTag != null) {
                        blockEntity.loadCustomOnly(savedTag, (HolderLookup.Provider)level.registryAccess());
                        blockEntity.setChanged();
                    }
                }
            }
        }
    }
}

