/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.common.level.blocks;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyEntityBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.entity.GuidedProxyBlockEntity;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuidedProxy
extends Block
implements IProxyBlock,
IProxyEntityBlock,
EntityBlock {
    public static final DirectionProperty LINK_DIRECTION = DirectionProperty.m_156003_((String)"link_direction");

    public GuidedProxy(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LINK_DIRECTION, (Comparable)Direction.UP)).m_61124_((Property)POWER_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"tooltip.buildstonetoolkit.guided_proxy.details"));
        } else {
            list.add((Component)Component.m_237115_((String)"tooltip.buildstonetoolkit.hold_shift"));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LINK_DIRECTION}).m_61104_(new Property[]{POWER_LEVEL});
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)LINK_DIRECTION, (Comparable)blockPlaceContext.m_7820_().m_122424_());
    }

    public static Direction getDirection(@NotNull Level level, BlockPos proxyPos) {
        return (Direction)level.m_8055_(proxyPos).m_61143_((Property)LINK_DIRECTION);
    }

    public static void setDirection(@NotNull Level level, BlockPos proxyPos, Direction direction) {
        level.m_7731_(proxyPos, (BlockState)level.m_8055_(proxyPos).m_61124_((Property)LINK_DIRECTION, (Comparable)direction), 3);
    }

    public static int getDistance(@NotNull Level level, BlockPos proxyPos) {
        return ((GuidedProxyBlockEntity)Objects.requireNonNull(level.m_7702_(proxyPos))).getDistance();
    }

    public static void setDistance(@NotNull Level level, BlockPos proxyPos, int newDistance) {
        if (newDistance == 0) {
            ((GuidedProxyBlockEntity)Objects.requireNonNull(level.m_7702_(proxyPos))).setDistance(newDistance);
            return;
        }
        if (newDistance > 0) {
            ((GuidedProxyBlockEntity)Objects.requireNonNull(level.m_7702_(proxyPos))).setDistance(newDistance);
            GuidedProxy.setDirection(level, proxyPos, Util.getPositiveDirection(((Direction)level.m_8055_(proxyPos).m_61143_((Property)LINK_DIRECTION)).m_122434_()));
            return;
        }
        ((GuidedProxyBlockEntity)Objects.requireNonNull(level.m_7702_(proxyPos))).setDistance(-1 * newDistance);
        GuidedProxy.setDirection(level, proxyPos, Util.getPositiveDirection(((Direction)level.m_8055_(proxyPos).m_61143_((Property)LINK_DIRECTION)).m_122434_()).m_122424_());
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bl) {
        IProxyBlock.super.m_6861_(state, level, pos, block, pos2, bl);
    }

    @Override
    public void m_6807_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean bl) {
        IProxyBlock.super.m_6807_(oldState, level, pos, newState, bl);
    }

    @Override
    public boolean shouldPreserveTargetAbsPos(@NotNull Level level, @NotNull PistonMovingBlockEntity mbe, BlockPos originalPos, BlockPos finalPos, Direction moveDirection) {
        if (this.isStronglyPowered(mbe.m_60400_())) {
            return true;
        }
        return this.isWeaklyPowered(level, finalPos);
    }

    @Override
    public boolean shouldTransferMovement(BlockPos pos, BlockState state, Direction blockLineRecursionDirection) {
        return this.getPowerLevel(state) == 0;
    }

    @Override
    public BlockPos getLinkedBlockPos(@NotNull Level level, BlockPos blockPos) {
        return blockPos.m_5484_((Direction)level.m_8055_(blockPos).m_61143_((Property)LINK_DIRECTION), ((GuidedProxyBlockEntity)Objects.requireNonNull(level.m_7702_(blockPos))).getDistance());
    }

    @Override
    public Util.FailableResult<BlockPos> parsePos(@NotNull Level level, BlockPos proxyPos, BlockPos inputPos) {
        Direction.Axis proxyAxis;
        BlockPos processedPos;
        BlockPos rawPos = inputPos.m_121996_((Vec3i)proxyPos);
        if (Util.deepEquals(rawPos, processedPos = Util.projectOntoAxis(rawPos, proxyAxis = GuidedProxy.getDirection(level, proxyPos).m_122434_()))) {
            return new Util.FailableResult<BlockPos>(processedPos, true);
        }
        return new Util.FailableResult<BlockPos>(processedPos, false);
    }

    @Override
    public boolean setLinkedRelPos(@NotNull Level level, BlockPos proxyPos, BlockPos newRelativeTargetPos) {
        Direction.Axis proxyAxis = GuidedProxy.getDirection(level, proxyPos).m_122434_();
        int posValueInAxis = newRelativeTargetPos.m_123304_(proxyAxis);
        GuidedProxy.setDistance(level, proxyPos, posValueInAxis);
        return Util.isNonZeroOnlyOn(newRelativeTargetPos, proxyAxis);
    }

    @Override
    public BlockState computeNewStateWithPreservedTargetAbsPos(Level level, BlockPos pos, BlockState state, Direction moveDirection) {
        return null;
    }

    @Override
    public BlockState computeNewStateWithPreservedTargetAbsPos(Level level, BlockPos pos, CompoundTag nbt, BlockState state, Direction moveDirection) {
        int newDistance = GuidedProxy.computeOffset(state, nbt, moveDirection, 1);
        BlockState newState = this.m_49966_();
        newState = newDistance >= 0 ? (BlockState)newState.m_61124_((Property)LINK_DIRECTION, (Comparable)((Direction)state.m_61143_((Property)LINK_DIRECTION))) : (BlockState)newState.m_61124_((Property)LINK_DIRECTION, (Comparable)moveDirection.m_122424_());
        return newState;
    }

    @Override
    public CompoundTag computeNewNBTWithPreservedTargetAbsPos(Level level, BlockPos pos, BlockState state, @Nullable CompoundTag nbt, Direction moveDirection) {
        assert (nbt != null);
        CompoundTag nbtOutput = nbt.m_6426_();
        int newDistance = GuidedProxy.computeOffset(state, nbt, moveDirection, 1);
        nbtOutput.m_128405_("link_distance", newDistance);
        return nbtOutput;
    }

    @Override
    public void offsetLinkedPos(Level level, BlockPos pos, BlockState state, Direction direction) {
        GuidedProxyBlockEntity blockEntity = (GuidedProxyBlockEntity)level.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        BlockState newState = state;
        int newDistance = GuidedProxy.computeOffset(state, blockEntity, direction, 1);
        if (newDistance >= 0) {
            blockEntity.setDistance(newDistance);
        } else {
            blockEntity.setDistance(1);
            newState = (BlockState)state.m_61124_((Property)LINK_DIRECTION, (Comparable)direction.m_122424_());
        }
        level.m_7731_(pos, newState, 3);
        level.m_151523_((BlockEntity)blockEntity);
    }

    @Override
    public void offsetLinkedPos(Level level, BlockPos pos, BlockState state, Direction direction, int i) {
        GuidedProxyBlockEntity blockEntity = (GuidedProxyBlockEntity)level.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        BlockState newState = state;
        int newDistance = GuidedProxy.computeOffset(state, blockEntity, direction, i);
        if (newDistance >= 0) {
            blockEntity.setDistance(newDistance);
        } else {
            blockEntity.setDistance(1);
            newState = (BlockState)state.m_61124_((Property)LINK_DIRECTION, (Comparable)direction.m_122424_());
        }
        level.m_7731_(pos, newState, 3);
        level.m_151523_((BlockEntity)blockEntity);
    }

    public static int computeOffset(BlockState state, GuidedProxyBlockEntity ppbe, Direction offsetDirection, int i) {
        return i * (ppbe.getDistance() + GuidedProxy.compareDirections(offsetDirection, (Direction)state.m_61143_((Property)LINK_DIRECTION)));
    }

    public static int computeOffset(BlockState state, CompoundTag ppbeTag, Direction offsetDirection, int i) {
        return i * (ppbeTag.m_128451_("link_distance") + GuidedProxy.compareDirections(offsetDirection, (Direction)state.m_61143_((Property)LINK_DIRECTION)));
    }

    public static int compareDirections(Direction a, Direction b) {
        if (a == b.m_122424_()) {
            return 1;
        }
        if (a == b) {
            return -1;
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GuidedProxyBlockEntity(blockPos, blockState);
    }
}

