/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.common.level.blocks;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyEntityBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.entity.PistonProxyBlockEntity;
import com.github.hoshinofw.buildstonetoolkit.registries.BuildstoneBlockEntities;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PistonProxy
extends Block
implements IProxyBlock,
EntityBlock,
IProxyEntityBlock {
    public PistonProxy(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWER_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"tooltip.buildstonetoolkit.piston_proxy.details"));
        } else {
            list.add((Component)Component.m_237115_((String)"tooltip.buildstonetoolkit.hold_shift"));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER_LEVEL});
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bl) {
        IProxyBlock.super.m_6861_(state, level, pos, block, pos2, bl);
    }

    @Override
    public void m_6807_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean bl) {
        IProxyBlock.super.m_6807_(oldState, level, pos, newState, bl);
    }

    @Override
    public boolean shouldPreserveTargetAbsPos(@NotNull Level level, @NotNull PistonMovingBlockEntity mbe, BlockPos originalPos, BlockPos finalPos, Direction moveDirection) {
        if (this.isStronglyPowered(mbe.m_60400_())) {
            return true;
        }
        return this.isWeaklyPowered(level, finalPos);
    }

    @Override
    public boolean shouldTransferMovement(BlockPos pos, BlockState state, Direction blockLineRecursionDirection) {
        return this.getPowerLevel(state) == 0;
    }

    @Override
    @Nullable
    public BlockPos getLinkedBlockPos(@NotNull Level level, BlockPos blockPos) {
        Optional optionalBe = level.m_141902_(blockPos, (BlockEntityType)BuildstoneBlockEntities.PISTON_PROXY.get());
        return optionalBe.map(pistonProxyBlockEntity -> blockPos.m_121955_((Vec3i)pistonProxyBlockEntity.getRelativeTargetPos())).orElse(null);
    }

    @Override
    public Util.FailableResult<BlockPos> parsePos(@NotNull Level level, BlockPos proxyPos, BlockPos inputPos) {
        BlockPos outputPos = inputPos.m_121996_((Vec3i)proxyPos);
        return new Util.FailableResult<BlockPos>(outputPos, true);
    }

    @Override
    public boolean setLinkedRelPos(@NotNull Level level, BlockPos pos, BlockPos newRelativeTargetPos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof PistonProxyBlockEntity) {
            PistonProxyBlockEntity pbe = (PistonProxyBlockEntity)be;
            pbe.setRelativeTargetPos(newRelativeTargetPos);
            pbe.m_6596_();
            level.m_7260_(pos, pbe.m_58900_(), pbe.m_58900_(), 3);
            return true;
        }
        return false;
    }

    @Override
    public void offsetLinkedPos(Level level, BlockPos pos, BlockState state, Direction direction) {
        Optional optionalBE = level.m_141902_(pos, (BlockEntityType)BuildstoneBlockEntities.PISTON_PROXY.get());
        if (optionalBE.isPresent()) {
            PistonProxyBlockEntity blockEntity = (PistonProxyBlockEntity)((Object)optionalBE.get());
            blockEntity.setRelativeTargetPos(blockEntity.getRelativeTargetPos().m_121945_(direction.m_122424_()));
        }
    }

    @Override
    public void offsetLinkedPos(Level level, BlockPos pos, BlockState state, Direction direction, int i) {
        Optional optionalBE = level.m_141902_(pos, (BlockEntityType)BuildstoneBlockEntities.PISTON_PROXY.get());
        if (optionalBE.isPresent()) {
            PistonProxyBlockEntity blockEntity = (PistonProxyBlockEntity)((Object)optionalBE.get());
            blockEntity.setRelativeTargetPos(blockEntity.getRelativeTargetPos().m_5484_(direction.m_122424_(), i));
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PistonProxyBlockEntity(blockPos, blockState);
    }

    @Override
    public CompoundTag computeNewNBTWithPreservedTargetAbsPos(Level level, BlockPos pos, BlockState state, CompoundTag nbt, Direction moveDirection) {
        assert (nbt != null);
        CompoundTag nbtOutput = nbt.m_6426_();
        BlockPos newOffset = Util.getTargetPosFromNBT(nbt).m_121945_(moveDirection.m_122424_());
        nbtOutput.m_128385_("relativeTargetPos", Util.blockPosToArray(newOffset));
        return nbtOutput;
    }

    @Override
    public BlockState computeNewStateWithPreservedTargetAbsPos(Level level, BlockPos pos, BlockState state, Direction moveDirection) {
        return state;
    }

    @Override
    public BlockState computeNewStateWithPreservedTargetAbsPos(Level level, BlockPos pos, CompoundTag nbt, BlockState state, Direction moveDirection) {
        return state;
    }
}

