/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.common.particles.TargetBlockParticle;

import com.github.hoshinofw.buildstonetoolkit.client.Sprites;
import com.github.hoshinofw.buildstonetoolkit.common.level.items.ModWand;
import com.github.hoshinofw.buildstonetoolkit.common.particles.TargetBlockParticle.BlockParticleOptions;
import com.github.hoshinofw.buildstonetoolkit.core.BuildstoneToolkit;
import com.github.hoshinofw.buildstonetoolkit.util.client.BlockParticleTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.platform.Platform;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockParticle
extends TextureSheetParticle {
    private SpriteSet sprites;
    private static final BlockParticleRenderProvider renderer = Platform.isFabric() ? new FabricRenderer() : new NFRenderer();
    float minU;
    float maxU;
    float minV;
    float maxV;
    private float r;
    private float g;
    private float b;
    private float a = 1.0f;
    private float alpha;
    private float size = 1.0f;
    private BooleanSupplier shouldPersist = () -> false;
    private boolean fading = false;
    private int fadeTicks = 0;
    private static final int fadeDuration = 5;
    public static final Vec3[] CUBE = new Vec3[]{new Vec3(1.0, 1.0, -1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(-1.0, 1.0, -1.0), new Vec3(-1.0, -1.0, -1.0), new Vec3(-1.0, -1.0, 1.0), new Vec3(1.0, -1.0, 1.0), new Vec3(1.0, -1.0, -1.0), new Vec3(-1.0, -1.0, 1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, -1.0, 1.0), new Vec3(1.0, -1.0, -1.0), new Vec3(1.0, 1.0, -1.0), new Vec3(-1.0, 1.0, -1.0), new Vec3(-1.0, -1.0, -1.0), new Vec3(-1.0, -1.0, -1.0), new Vec3(-1.0, 1.0, -1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(-1.0, -1.0, 1.0), new Vec3(1.0, -1.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, -1.0), new Vec3(1.0, -1.0, -1.0)};
    public static final ParticleRenderType NO_DEPTH = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "buildstonetoolkit:no_depth_particle";
        }
    };
    public static final ParticleRenderType RENDER_TYPE = Platform.isFabric() ? ParticleRenderType.f_107431_ : NO_DEPTH;

    protected BlockParticle(ClientLevel clientLevel, BlockPos pos, SpriteSet spriteSet) {
        super(clientLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        this.sprites = spriteSet;
        this.setTextureSprite(spriteSet);
        this.updateUVValues();
    }

    public static BlockParticle create(ClientLevel clientLevel, BlockPos pos, SpriteSet spriteSet) {
        ModWand.setClientMode(ModWand.Mode.ON);
        return new BlockParticle(clientLevel, pos, spriteSet);
    }

    public static BlockParticle create(ClientLevel clientLevel, BlockPos pos) {
        ModWand.setClientMode(ModWand.Mode.ON);
        return new BlockParticle(clientLevel, pos, Sprites.BLOCK_PARTICLE_SPRITES);
    }

    public BlockParticle setRGBATint(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.alpha = a;
        return this;
    }

    public BlockParticle setSize(float size) {
        this.size = size;
        return this;
    }

    public BlockParticle setPersistSupplier(BooleanSupplier supplier) {
        this.shouldPersist = supplier;
        return this;
    }

    public BlockParticle setTextureSprite(SpriteSet spriteSet) {
        this.sprites = spriteSet;
        this.m_108335_(spriteSet);
        this.updateUVValues();
        return this;
    }

    public BlockParticle setTextureIndex(BlockParticleTexture texture) {
        this.m_108337_(this.sprites.m_5819_(texture.index(), 2));
        BuildstoneToolkit.LOGGER.info("Sprite indexed: {}", (Object)this.sprites.m_5819_(texture.index(), 2));
        this.updateUVValues();
        return this;
    }

    private void updateUVValues() {
        this.minU = this.f_108321_.m_118409_();
        this.maxU = this.f_108321_.m_118410_();
        this.minV = this.f_108321_.m_118411_();
        this.maxV = this.f_108321_.m_118412_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5744_(VertexConsumer consumer, @NotNull Camera camera, float partialTicks) {
        renderer.render(consumer, camera, partialTicks, this);
    }

    public void m_5989_() {
        if (!this.fading) {
            ModWand.setClientMode(ModWand.Mode.ON);
            if (!this.shouldPersist.getAsBoolean()) {
                this.fading = true;
                this.fadeTicks = 0;
            }
        } else {
            ++this.fadeTicks;
            float fadeProgress = (float)this.fadeTicks / 5.0f;
            this.alpha = Mth.m_14036_((float)(1.0f - fadeProgress), (float)0.0f, (float)1.0f) * this.a;
            if (this.fadeTicks >= 5) {
                this.m_107274_();
                ModWand.setClientMode(ModWand.Mode.OFF);
            }
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface BlockParticleRenderProvider {
        default public void render(VertexConsumer consumer, @NotNull Camera camera, float partialTicks, BlockParticle particle) {
            Vec3 projectedView = camera.m_90583_();
            float x = (float)(particle.f_107212_ - projectedView.m_7096_());
            float y = (float)(particle.f_107213_ - projectedView.m_7098_());
            float z = (float)(particle.f_107214_ - projectedView.m_7094_());
            int light = 0xF000F0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 4; ++j) {
                    float u;
                    Vec3 vec = CUBE[i * 4 + j].m_82490_(-1.0).m_82490_((double)(particle.size / 2.0f + 0.001f)).m_82520_((double)x, (double)y, (double)z);
                    consumer.m_5483_((double)((float)vec.f_82479_), (double)((float)vec.f_82480_), (double)((float)vec.f_82481_)).m_7421_(u, switch (j) {
                        case 0 -> {
                            u = particle.maxU;
                            yield particle.maxV;
                        }
                        case 1 -> {
                            u = particle.maxU;
                            yield particle.minV;
                        }
                        case 2 -> {
                            u = particle.minU;
                            yield particle.minV;
                        }
                        default -> {
                            u = particle.minU;
                            yield particle.maxV;
                        }
                    }).m_85950_(particle.r, particle.g, particle.b, particle.alpha).m_85969_(light).m_5752_();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FabricRenderer
    implements BlockParticleRenderProvider {
        @Override
        public void render(VertexConsumer consumer, @NotNull Camera camera, float partialTicks, BlockParticle particle) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            BlockParticleRenderProvider.super.render(consumer, camera, partialTicks, particle);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NFRenderer
    implements BlockParticleRenderProvider {
        @Override
        public void render(VertexConsumer consumer, @NotNull Camera camera, float partialTicks, BlockParticle particle) {
            BlockParticleRenderProvider.super.render(consumer, camera, partialTicks, particle);
        }
    }

    public static class Provider
    implements ParticleProvider<BlockParticleOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOptions particleOptions, ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz) {
            return BlockParticle.create(clientLevel, new BlockPos((int)x, (int)y, (int)z), this.sprite).setRGBATint(1.0f, 1.0f, 1.0f, 0.8f).setSize(1.0f).setTextureSprite(this.sprite).setTextureIndex(BlockParticleTexture.SELECTION_BLOCK);
        }
    }
}

