/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.util;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.util.mixin.PistonMovingBlockEntityMixinInterface;
import com.github.hoshinofw.buildstonetoolkit.util.mixin.PlayerMixinInterface;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static CompoundTag getProxyTag(PistonMovingBlockEntity mbe) {
        return ((PistonMovingBlockEntityMixinInterface)mbe).buildstonetoolkit$getProxyTag();
    }

    public static BlockPos getSelectedPos(@NotNull Player player) {
        return ((PlayerMixinInterface)player).buildstonetoolkit$getSelectedBlockPos();
    }

    public static void setSelectedPos(@NotNull Player player, @Nullable BlockPos newPos) {
        ((PlayerMixinInterface)player).buildstonetoolkit$setSelectedBlockPos(newPos);
    }

    public static Component blueComponent(String string) {
        return Component.m_237113_((String)string).m_130940_(ChatFormatting.BLUE);
    }

    public static Component yellowComponent(String string) {
        return Component.m_237113_((String)string).m_130940_(ChatFormatting.YELLOW);
    }

    public static boolean deepEquals(@Nullable BlockPos a, @Nullable BlockPos b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        return a.m_123341_() == b.m_123341_() && a.m_123342_() == b.m_123342_() && a.m_123343_() == b.m_123343_();
    }

    public static boolean isPushableBlockEntity(BlockState state) {
        return state.m_155947_() && state.m_60734_() instanceof IProxyBlock;
    }

    public static Direction resolveDirection(Direction direction, boolean isExtending) {
        return isExtending ? direction : direction.m_122424_();
    }

    public static int[] blockPosToArray(BlockPos pos) {
        return new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
    }

    public static BlockPos getTargetPosFromNBT(CompoundTag nbt) {
        int[] array = nbt.m_128465_("relativeTargetPos");
        if (!nbt.m_128425_("relativeTargetPos", 11) || array.length < 3) {
            return BlockPos.f_121853_;
        }
        return new BlockPos(array[0], array[1], array[2]);
    }

    @Nullable
    public static Vec3 getSearchOriginFromNBT(CompoundTag nbt) {
        if (nbt.m_128425_("searchOrigin", 11)) {
            int[] array = nbt.m_128465_("searchOrigin");
            return new BlockPos(array[0], array[1], array[2]).m_252807_();
        }
        return null;
    }

    public static boolean isNonZeroOnlyOn(BlockPos pos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (pos.m_123341_() != 0 && pos.m_123342_() == 0 && pos.m_123343_() == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (pos.m_123342_() != 0 && pos.m_123341_() == 0 && pos.m_123343_() == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> pos.m_123343_() != 0 && pos.m_123341_() == 0 && pos.m_123342_() == 0;
        };
    }

    public static BlockPos projectOntoAxis(BlockPos rawPos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new BlockPos(rawPos.m_123341_(), 0, 0);
            case Direction.Axis.Y -> new BlockPos(0, rawPos.m_123342_(), 0);
            case Direction.Axis.Z -> new BlockPos(0, 0, rawPos.m_123343_());
        };
    }

    public static Direction getPositiveDirection(Direction.Axis axis) {
        return switch (axis) {
            case Direction.Axis.X -> Direction.EAST;
            case Direction.Axis.Z -> Direction.SOUTH;
            default -> Direction.UP;
        };
    }

    public static class ValueCycler<T> {
        private final List<T> values;
        private final Consumer<T> setter;
        private final Supplier<T> getter;

        public ValueCycler(List<T> values, Supplier<T> getter, Consumer<T> setter) {
            this.values = values;
            this.getter = getter;
            this.setter = setter;
        }

        public void next() {
            T current = this.getter.get();
            int index = this.values.indexOf(current);
            if (index == -1) {
                index = 0;
            }
            int nextIndex = (index + 1) % this.values.size();
            this.setter.accept(this.values.get(nextIndex));
        }
    }

    public record FailableResult<T>(T value, boolean succeeded) {
        public static <T> FailableResult<T> success(T value) {
            return new FailableResult<T>(value, true);
        }

        public static <T> FailableResult<T> failure(T value) {
            return new FailableResult<T>(value, false);
        }
    }
}

