/*
 * Decompiled with CFR 0.152.
 */
package cn.xiaym.fcitx5.dbus;

import cn.xiaym.fcitx5.Fcitx5;
import cn.xiaym.fcitx5.async.AsyncDispatcher;
import cn.xiaym.fcitx5.dbus.Fcitx5Controller1;
import cn.xiaym.fcitx5.deps.dbus.connections.IDisconnectCallback;
import cn.xiaym.fcitx5.deps.dbus.connections.impl.DBusConnection;
import cn.xiaym.fcitx5.deps.dbus.connections.impl.DBusConnectionBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class Fcitx5DBus {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_INACTIVE = 1;
    public static final int STATE_ACTIVE = 2;
    private static final AsyncDispatcher STATE_DISPATCHER = new AsyncDispatcher();
    private static DBusConnection connection;
    private static Fcitx5Controller1 controller;

    private static void tryInit() {
        try {
            connection = ((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withDisconnectCallback(new IDisconnectCallback(){

                @Override
                public void disconnectOnError(IOException ex) {
                    Fcitx5.LOGGER.warn("D-Bus connection is closed unexpectedly due to an exception.", (Throwable)ex);
                }
            })).build();
            connection.connect();
        }
        catch (Exception ex) {
            connection = null;
            Fcitx5.LOGGER.warn("Unable to connect to local D-Bus (session), please check your environment. Relevant functionalities will be disabled.", (Throwable)ex);
        }
        if (connection != null) {
            try {
                controller = connection.getRemoteObject("org.fcitx.Fcitx5", "/controller", Fcitx5Controller1.class);
            }
            catch (Exception ex) {
                connection = null;
                controller = null;
                Fcitx5.LOGGER.warn("Can't get Fcitx5 Controller. Relevant functionalities will be disabled.", (Throwable)ex);
            }
        } else {
            controller = null;
        }
    }

    private static boolean checkDBus() {
        if (connection == null) {
            return false;
        }
        if (!connection.isConnected()) {
            Fcitx5DBus.tryInit();
            return Fcitx5DBus.checkDBus();
        }
        return true;
    }

    public static CompletableFuture<Integer> getStateAsync() {
        if (!Fcitx5DBus.checkDBus()) {
            return CompletableFuture.completedFuture(0);
        }
        return CompletableFuture.supplyAsync(() -> controller.state());
    }

    public static void activate() {
        if (!Fcitx5DBus.checkDBus()) {
            return;
        }
        STATE_DISPATCHER.dispatch(controller::activate);
    }

    public static void deactivate() {
        if (!Fcitx5DBus.checkDBus()) {
            return;
        }
        STATE_DISPATCHER.dispatch(controller::deactivate);
    }

    static {
        Fcitx5DBus.tryInit();
    }
}

