/*
 * Decompiled with CFR 0.152.
 */
package cn.xiaym.fcitx5.deps.dbus.connections.base;

import cn.xiaym.fcitx5.deps.dbus.connections.BusAddress;
import cn.xiaym.fcitx5.deps.dbus.connections.base.ConnectionMessageHandler;
import cn.xiaym.fcitx5.deps.dbus.exceptions.DBusException;
import cn.xiaym.fcitx5.deps.dbus.exceptions.IllegalThreadPoolStateException;
import cn.xiaym.fcitx5.deps.dbus.interfaces.FatalException;
import cn.xiaym.fcitx5.deps.dbus.messages.Message;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingMessageThread
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean terminate;
    private final ConnectionMessageHandler connection;

    public IncomingMessageThread(ConnectionMessageHandler _connection, BusAddress _busAddress) {
        this.connection = Objects.requireNonNull(_connection);
        this.setName("DBusConnection [listener=" + _busAddress.isListeningSocket() + "]");
        this.setDaemon(true);
    }

    public void terminate() {
        this.terminate = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.terminate) {
            Message msg = null;
            try {
                msg = this.connection.readIncoming();
                if (msg == null) continue;
                this.logger.trace("Read message from {}: {}", (Object)this.connection.getTransport(), (Object)msg);
                this.connection.handleMessage(msg);
            }
            catch (DBusException | IllegalThreadPoolStateException | RejectedExecutionException _ex) {
                if (_ex instanceof FatalException) {
                    if (this.terminate) {
                        return;
                    }
                    this.logger.error("FatalException in connection thread", (Throwable)_ex);
                    if (this.connection.isConnected()) {
                        this.terminate = true;
                        Throwable throwable = _ex.getCause();
                        if (throwable instanceof IOException) {
                            IOException ioe = (IOException)throwable;
                            this.connection.internalDisconnect(ioe);
                        } else {
                            this.connection.internalDisconnect(null);
                        }
                    }
                    return;
                }
                if (this.terminate) continue;
                this.logger.error("Exception in connection thread", (Throwable)_ex);
            }
        }
    }
}

