/*
 * Decompiled with CFR 0.152.
 */
package cn.xiaym.fcitx5.deps.dbus.connections.impl;

import cn.xiaym.fcitx5.deps.dbus.connections.AbstractConnection;
import cn.xiaym.fcitx5.deps.dbus.connections.BusAddress;
import cn.xiaym.fcitx5.deps.dbus.connections.IDisconnectCallback;
import cn.xiaym.fcitx5.deps.dbus.connections.config.ReceivingServiceConfig;
import cn.xiaym.fcitx5.deps.dbus.connections.config.ReceivingServiceConfigBuilder;
import cn.xiaym.fcitx5.deps.dbus.connections.config.TransportConfig;
import cn.xiaym.fcitx5.deps.dbus.connections.config.TransportConfigBuilder;
import cn.xiaym.fcitx5.deps.dbus.connections.impl.ConnectionConfig;
import cn.xiaym.fcitx5.deps.dbus.exceptions.DBusException;
import cn.xiaym.fcitx5.deps.dbus.messages.DBusSignal;
import java.nio.ByteOrder;
import java.util.function.Consumer;

public abstract class BaseConnectionBuilder<R extends BaseConnectionBuilder<R, C>, C extends AbstractConnection> {
    private final Class<R> returnType;
    private final ReceivingServiceConfigBuilder<R> rsConfigBuilder;
    private final TransportConfigBuilder<?, R> transportConfigBuilder;
    private final ConnectionConfig connectionConfig;

    protected BaseConnectionBuilder(Class<R> _returnType, BusAddress _address) {
        this.returnType = _returnType;
        this.connectionConfig = new ConnectionConfig();
        this.rsConfigBuilder = new ReceivingServiceConfigBuilder<BaseConnectionBuilder>(this::self);
        this.transportConfigBuilder = new TransportConfigBuilder(this::self);
        this.transportConfigBuilder.withBusAddress(_address);
    }

    R self() {
        return (R)((BaseConnectionBuilder)this.returnType.cast(this));
    }

    protected ReceivingServiceConfig buildThreadConfig() {
        return this.rsConfigBuilder.build();
    }

    protected TransportConfig buildTransportConfig() {
        return this.transportConfigBuilder.build();
    }

    protected ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public ReceivingServiceConfigBuilder<R> receivingThreadConfig() {
        return this.rsConfigBuilder;
    }

    public TransportConfigBuilder<?, R> transportConfig() {
        return this.transportConfigBuilder;
    }

    @Deprecated(forRemoval=true, since="5.1.0 - 2024-07-12")
    public R withWeakReferences(boolean _weakRef) {
        return this.withExportWeakReferences(_weakRef);
    }

    public R withExportWeakReferences(boolean _weakRef) {
        this.connectionConfig.setExportWeakReferences(_weakRef);
        return this.self();
    }

    public R withImportWeakReferences(boolean _weakRef) {
        this.connectionConfig.setImportWeakReferences(_weakRef);
        return this.self();
    }

    public R withDisconnectCallback(IDisconnectCallback _disconnectCallback) {
        this.connectionConfig.setDisconnectCallback(_disconnectCallback);
        return this.self();
    }

    public R withUnknownSignalHandler(Consumer<DBusSignal> _handler) {
        this.connectionConfig.setUnknownSignalHandler(_handler);
        return this.self();
    }

    public abstract C build() throws DBusException;

    public static byte getSystemEndianness() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (byte)66 : 108;
    }
}

