/*
 * Decompiled with CFR 0.152.
 */
package cn.xiaym.fcitx5.deps.dbus.transport.jre;

import cn.xiaym.fcitx5.deps.dbus.connections.config.TransportConfig;
import cn.xiaym.fcitx5.deps.dbus.connections.transports.AbstractUnixTransport;
import cn.xiaym.fcitx5.deps.dbus.exceptions.TransportConfigurationException;
import cn.xiaym.fcitx5.deps.dbus.transport.jre.NativeUnixSocketHelper;
import cn.xiaym.fcitx5.deps.dbus.transport.jre.UnixBusAddress;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;

public class NativeUnixSocketTransport
extends AbstractUnixTransport {
    private final UnixDomainSocketAddress unixSocketAddress;
    private SocketChannel socket;
    private ServerSocketChannel serverSocket;

    NativeUnixSocketTransport(UnixBusAddress _address, TransportConfig _config) throws TransportConfigurationException {
        super(_address, _config);
        if (!_address.hasPath()) {
            throw new TransportConfigurationException("Native unix socket url has to specify 'path'");
        }
        this.unixSocketAddress = UnixDomainSocketAddress.of(_address.getPath());
        this.getSaslConfig().setAuthMode(1);
    }

    @Override
    protected boolean hasFileDescriptorSupport() {
        return false;
    }

    @Override
    public SocketChannel connectImpl() throws IOException {
        if (this.getAddress().isListeningSocket()) {
            throw new IOException("Connect connect to a listening socket (use listenImpl() instead)");
        }
        this.socket = SocketChannel.open(this.unixSocketAddress);
        this.socket.configureBlocking(true);
        return this.socket;
    }

    @Override
    protected void bindImpl() throws IOException {
        if (!this.getAddress().isListeningSocket()) {
            throw new IOException("Cannot listen on a client connection (use connectImpl() instead)");
        }
        if (!this.isBound()) {
            this.serverSocket = ServerSocketChannel.open(StandardProtocolFamily.UNIX).bind(this.unixSocketAddress);
            this.serverSocket.configureBlocking(true);
        }
    }

    @Override
    public SocketChannel acceptImpl() throws IOException {
        this.socket = this.serverSocket.accept();
        this.socket.configureBlocking(true);
        return this.socket;
    }

    @Override
    protected boolean isBound() {
        return this.serverSocket != null && this.serverSocket.isOpen();
    }

    @Override
    protected void closeTransport() throws IOException {
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.close();
        }
        if (this.serverSocket != null && this.serverSocket.isOpen()) {
            this.serverSocket.close();
            Files.deleteIfExists(this.unixSocketAddress.getPath());
        }
    }

    @Override
    public int getUid(SocketChannel _sock) throws IOException {
        return NativeUnixSocketHelper.getUid(_sock);
    }
}

