/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.util.LegendaryEffects;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class FootprintTracker {
    public static final int PROGRESS_MAX = 50;
    private static final Map<String, Map<UUID, Map<FootprintType, Integer>>> worldPlayerProgress = new HashMap<String, Map<UUID, Map<FootprintType, Integer>>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type PROGRESS_TYPE = new TypeToken<Map<String, Map<UUID, Map<FootprintType, Integer>>>>(){}.getType();
    private static File progressDataFile;

    private static String getWorldId(class_3218 world) {
        if (world == null) {
            LegendaryMonuments.LOGGER.error("World is null in getWorldId()");
            return "unknown";
        }
        try {
            MinecraftServer server = world.method_8503();
            String levelName = server.method_27728().method_150();
            if (levelName == null || levelName.isEmpty()) {
                LegendaryMonuments.LOGGER.error("Level name is null/empty, using fallback");
                return "unknown_world_" + System.currentTimeMillis();
            }
            long worldSeed = world.method_8412();
            int spawnX = world.method_43126().method_10263();
            int spawnZ = world.method_43126().method_10260();
            String worldSpecificData = worldSeed + "_" + spawnX + "_" + spawnZ;
            int worldDataHash = worldSpecificData.hashCode();
            String uniqueWorldId = levelName + "_" + Math.abs(worldDataHash);
            return uniqueWorldId;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Exception while generating world ID, using fallback", (Throwable)e);
            return "error_world_" + System.currentTimeMillis();
        }
    }

    private static File getServerDataDirectory(MinecraftServer server) {
        File serverDir = null;
        try {
            serverDir = server.method_3831().toFile();
            if (serverDir != null && serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to get server run directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("user.dir"));
            if (serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to use current working directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("user.home"), "minecraft-footprint-data");
            if (!serverDir.exists()) {
                serverDir.mkdirs();
            }
            if (serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to use user home directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("java.io.tmpdir"), "minecraft-footprint-data");
            if (!serverDir.exists()) {
                serverDir.mkdirs();
            }
            if (serverDir.exists() && serverDir.canWrite()) {
                LegendaryMonuments.LOGGER.warn("Using temp directory for footprint data - data will be lost on reboot!");
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to use temp directory", (Throwable)e);
        }
        LegendaryMonuments.LOGGER.error("CRITICAL: Could not find any writable directory for footprint data!");
        return null;
    }

    private static void ensureStorageInitialized(MinecraftServer server) {
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.warn("progressDataFile is null, attempting lazy initialization...");
            LegendaryMonuments.LOGGER.info("Server instance available: {}", (Object)(server != null ? 1 : 0));
            if (server != null) {
                FootprintTracker.initializeStorage(server);
            } else {
                LegendaryMonuments.LOGGER.error("Cannot initialize storage: server is null");
            }
        }
    }

    public static void initializeStorage(MinecraftServer server) {
        try {
            boolean created;
            LegendaryMonuments.LOGGER.info("=== STARTING FOOTPRINT TRACKER INITIALIZATION ===");
            File serverDir = FootprintTracker.getServerDataDirectory(server);
            if (serverDir == null) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Could not find any writable directory for footprint tracking");
                return;
            }
            File dataDir = new File(serverDir, "legendary-monuments-data");
            if (!dataDir.exists() && !(created = dataDir.mkdirs())) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Failed to create data directory for footprint tracking");
                LegendaryMonuments.LOGGER.error("Data directory path: {}", (Object)dataDir.getAbsolutePath());
                if (dataDir.getParentFile() != null) {
                    LegendaryMonuments.LOGGER.error("Parent directory exists: {}", (Object)dataDir.getParentFile().exists());
                    LegendaryMonuments.LOGGER.error("Parent directory writable: {}", (Object)dataDir.getParentFile().canWrite());
                    LegendaryMonuments.LOGGER.error("Parent directory path: {}", (Object)dataDir.getParentFile().getAbsolutePath());
                }
                return;
            }
            if (!dataDir.canWrite()) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Data directory exists but is not writable: {}", (Object)dataDir.getAbsolutePath());
                return;
            }
            progressDataFile = new File(dataDir, "footprint_progress.json");
            if (progressDataFile.exists()) {
                try (FileReader reader = new FileReader(progressDataFile);){
                    Map loadedData = (Map)GSON.fromJson((Reader)reader, PROGRESS_TYPE);
                    if (loadedData != null) {
                        worldPlayerProgress.putAll(loadedData);
                        int totalPlayers = 0;
                        for (Map<UUID, Map<FootprintType, Integer>> worldMap : worldPlayerProgress.values()) {
                            if (worldMap == null) continue;
                            totalPlayers += worldMap.size();
                        }
                        LegendaryMonuments.LOGGER.info("Successfully loaded footprint progress data for {} worlds and {} total players", (Object)loadedData.size(), (Object)totalPlayers);
                    } else {
                        LegendaryMonuments.LOGGER.warn("Progress file exists but contains no data (null)");
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("IOException while loading footprint progress data", (Throwable)e);
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Exception processing progress data file, starting with empty data", (Throwable)e);
                    worldPlayerProgress.clear();
                }
            } else {
                LegendaryMonuments.LOGGER.info("No existing progress file found, creating new one...");
                try {
                    created = progressDataFile.createNewFile();
                    LegendaryMonuments.LOGGER.info("Created new footprint progress data file: {}", (Object)created);
                    if (!created) {
                        LegendaryMonuments.LOGGER.error("Failed to create new progress file!");
                        return;
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("IOException creating footprint progress data file", (Throwable)e);
                    return;
                }
            }
            if (progressDataFile != null && progressDataFile.exists() && progressDataFile.getParentFile().canWrite()) {
                LegendaryMonuments.LOGGER.info("=== FOOTPRINT TRACKER INITIALIZATION SUCCESSFUL ===");
            } else {
                LegendaryMonuments.LOGGER.error("=== FOOTPRINT TRACKER INITIALIZATION FAILED ===");
                LegendaryMonuments.LOGGER.error("progressDataFile is null: {}", (Object)(progressDataFile == null ? 1 : 0));
                if (progressDataFile != null) {
                    LegendaryMonuments.LOGGER.error("progressDataFile exists: {}", (Object)progressDataFile.exists());
                    LegendaryMonuments.LOGGER.error("progressDataFile parent writable: {}", (Object)(progressDataFile.getParentFile() != null && progressDataFile.getParentFile().canWrite() ? 1 : 0));
                }
                progressDataFile = null;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("=== CRITICAL ERROR DURING FOOTPRINT TRACKER INITIALIZATION ===", (Throwable)e);
            progressDataFile = null;
        }
    }

    public static void loadPlayerProgress(class_3222 player) {
        try {
            if (player == null) {
                LegendaryMonuments.LOGGER.error("Cannot load player progress: player is null");
                return;
            }
            FootprintTracker.ensureStorageInitialized(player.method_5682());
            UUID playerUUID = player.method_5667();
            String worldId = FootprintTracker.getWorldId((class_3218)player.method_37908());
            worldPlayerProgress.putIfAbsent(worldId, new HashMap());
            Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            if (worldProgress.containsKey(playerUUID)) {
                return;
            }
            worldProgress.putIfAbsent(playerUUID, new HashMap());
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Unexpected error loading player progress", (Throwable)e);
        }
    }

    public static void saveAllPlayerData() {
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save player footprint data: progressDataFile is null");
            return;
        }
        try (FileWriter writer = new FileWriter(progressDataFile);){
            GSON.toJson(worldPlayerProgress, (Appendable)writer);
            int n = worldPlayerProgress.values().stream().mapToInt(Map::size).sum();
        }
        catch (IOException e) {
            LegendaryMonuments.LOGGER.error("Failed to save player footprint data", (Throwable)e);
        }
    }

    public static void savePlayerData(class_3222 player) {
        if (player == null) {
            LegendaryMonuments.LOGGER.warn("Cannot save player footprint data: player is null");
            return;
        }
        FootprintTracker.ensureStorageInitialized(player.method_5682());
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save player footprint data: file not initialized (even after lazy init attempt)");
            return;
        }
        String worldId = FootprintTracker.getWorldId((class_3218)player.method_37908());
        UUID playerUUID = player.method_5667();
        Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
        if (worldProgress == null || !worldProgress.containsKey(playerUUID)) {
            LegendaryMonuments.LOGGER.info("No data to save for player {} in world {}", (Object)player.method_5477().getString(), (Object)worldId);
            return;
        }
        FootprintTracker.saveAllPlayerData();
        LegendaryMonuments.LOGGER.info("Saved footprint progress for player {} in world {}", (Object)player.method_5477().getString(), (Object)worldId);
    }

    public static Map<FootprintType, Integer> getPlayerProgress(UUID playerUUID, class_1937 world) {
        try {
            if (!(world instanceof class_3218)) {
                LegendaryMonuments.LOGGER.warn("getPlayerProgress called with non-ServerWorld: {}", (Object)world.getClass().getSimpleName());
                return new HashMap<FootprintType, Integer>();
            }
            String worldId = FootprintTracker.getWorldId((class_3218)world);
            worldPlayerProgress.putIfAbsent(worldId, new HashMap());
            Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            worldProgress.putIfAbsent(playerUUID, new HashMap());
            Map<FootprintType, Integer> playerData = worldProgress.get(playerUUID);
            return playerData;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error retrieving player progress", (Throwable)e);
            return new HashMap<FootprintType, Integer>();
        }
    }

    public static boolean recordFootprintFound(class_1657 player, FootprintType type) {
        try {
            if (player == null) {
                LegendaryMonuments.LOGGER.error("Cannot record footprint: player is null");
                return false;
            }
            if (player.method_37908().field_9236) {
                LegendaryMonuments.LOGGER.info("Ignoring client-side footprint recording attempt");
                return false;
            }
            String worldId = FootprintTracker.getWorldId((class_3218)player.method_37908());
            UUID playerUUID = player.method_5667();
            worldPlayerProgress.putIfAbsent(worldId, new HashMap());
            Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            worldProgress.putIfAbsent(playerUUID, new HashMap());
            Map<FootprintType, Integer> progress = worldProgress.get(playerUUID);
            int currentProgress = progress.getOrDefault((Object)type, 0);
            int newProgress = currentProgress + 1;
            progress.put(type, newProgress);
            if (player instanceof class_3222) {
                try {
                    FootprintTracker.savePlayerData((class_3222)player);
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Failed to save player data after footprint update", (Throwable)e);
                }
            }
            if (type == FootprintType.COSMIC_DUST) {
                player.method_7353((class_2561)class_2561.method_43470((String)(newProgress + "/50 " + type.getDisplayName() + " particles collected")).method_27692(class_124.field_1076), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)(newProgress + "/50 " + type.getDisplayName() + " footprints found")).method_27692(class_124.field_1065), true);
            }
            if (newProgress >= 50) {
                LegendaryMonuments.LOGGER.info("Player {} has completed {} collection in world {}!", new Object[]{player.method_5477().getString(), type.getDisplayName(), worldId});
                progress.put(type, 0);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Unexpected error recording footprint", (Throwable)e);
            return false;
        }
    }

    public static void executeCompletionCommand(class_3222 player, FootprintType type) {
        boolean isShiny;
        String worldId = FootprintTracker.getWorldId((class_3218)player.method_37908());
        LegendaryMonuments.LOGGER.info("Executing completion command for {} in world {}", (Object)type.getDisplayName(), (Object)worldId);
        boolean bl = isShiny = Math.random() < 0.02;
        if (type == FootprintType.COSMIC_DUST) {
            int x = (int)Math.floor(player.method_23317());
            int y = (int)Math.floor(player.method_23318());
            int z = (int)Math.floor(player.method_23321());
            class_2338 spawnPos = new class_2338(x, y, z);
            LegendaryEffects.spawnCosmogEffect((class_3218)player.method_37908(), spawnPos);
            String pokemonName = "cosmog";
            String command = "pokespawnat " + x + " " + y + " " + z + " " + pokemonName + " lvl=5";
            if (isShiny) {
                command = command + " shiny";
            }
            class_2168 commandSource = player.method_5682().method_3739().method_9227((class_3218)player.method_37908()).method_9208(player.method_19538()).method_9216(player.method_5802());
            LegendaryMonuments.LOGGER.info("Executing command: {}", (Object)command);
            player.method_5682().method_3734().method_44252(commandSource, command);
            class_5250 message = class_2561.method_43470((String)("You have collected all " + type.getDisplayName() + " particles! ")).method_27695(new class_124[]{class_124.field_1076, class_124.field_1067});
            message = isShiny ? message.method_27661().method_10852((class_2561)class_2561.method_43470((String)("A SHINY " + pokemonName + " has emerged from the void!")).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})) : message.method_27661().method_10852((class_2561)class_2561.method_43470((String)("A " + pokemonName + " has emerged from the void!")).method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}));
            player.method_7353((class_2561)message, false);
            return;
        }
        String pokemonName = "";
        String berryId = "";
        switch (type.ordinal()) {
            case 0: {
                pokemonName = "Terrakion";
                berryId = "legendarymonuments:special_spices";
                break;
            }
            case 1: {
                pokemonName = "Cobalion";
                berryId = "legendarymonuments:special_meat_chunks";
                break;
            }
            case 2: {
                pokemonName = "Virizion";
                berryId = "legendarymonuments:special_leafy_greens";
                break;
            }
            default: {
                pokemonName = "";
            }
        }
        int x = (int)Math.floor(player.method_23317());
        int y = (int)Math.floor(player.method_23318());
        int z = (int)Math.floor(player.method_23321());
        class_2338 spawnPos = new class_2338(x, y, z);
        switch (type.ordinal()) {
            case 0: {
                LegendaryEffects.spawnTerrakionEffect((class_3218)player.method_37908(), spawnPos);
                break;
            }
            case 1: {
                LegendaryEffects.spawnCobalionEffect((class_3218)player.method_37908(), spawnPos);
                break;
            }
            case 2: {
                LegendaryEffects.spawnVirizionEffect((class_3218)player.method_37908(), spawnPos);
                break;
            }
        }
        String spawnCommand = "pokespawnat " + x + " " + y + " " + z + " " + pokemonName + " lvl=40";
        if (isShiny) {
            spawnCommand = spawnCommand + " shiny";
        }
        LegendaryMonuments.LOGGER.info("Executing command: {}", (Object)spawnCommand);
        player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), spawnCommand);
        if (!berryId.isEmpty()) {
            class_2960 id = class_2960.method_60654((String)berryId);
            class_1792 berry = (class_1792)class_7923.field_41178.method_10223(id);
            if (berry != class_1802.field_8162) {
                LegendaryMonuments.LOGGER.info("Giving special ingredient to player: {}", (Object)berryId);
                class_1799 stack = new class_1799((class_1935)berry, 1);
                if (!player.method_31548().method_7394(stack)) {
                    player.method_7328(stack, false);
                }
            } else {
                LegendaryMonuments.LOGGER.error("Could not find ingredient item: {}", (Object)berryId);
            }
        }
        class_5250 message = class_2561.method_43470((String)("You have collected all " + type.getDisplayName() + " footprints! ")).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067});
        message = isShiny ? message.method_27661().method_10852((class_2561)class_2561.method_43470((String)("A SHINY " + pokemonName + " has appeared!")).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})) : message.method_27661().method_10852((class_2561)class_2561.method_43470((String)("A " + pokemonName + " has appeared!")).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        message = message.method_27661().method_10852((class_2561)class_2561.method_43470((String)("\nYou received a special ingredient from " + pokemonName + "!")).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        player.method_7353((class_2561)message, false);
    }

    public static enum FootprintType {
        TERRAKION("Terrakion"),
        COBALION("Cobalion"),
        VIRIZION("Virizion"),
        COSMIC_DUST("Cosmic Dust");

        private final String displayName;

        private FootprintType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

