/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.world.dimension.HallOfOriginTeleporter;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ArceusEventHandler {
    public static void register() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon pokemon = event.getPokemon();
                if (pokemon == null) {
                    return Unit.INSTANCE;
                }
                if (ArceusEventHandler.isArceus(pokemon)) {
                    ArceusEventHandler.handleArceusResolvedNearbyPlayers(pokemon);
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error handling Arceus fainted event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon pokemon = event.getPokemon();
                if (pokemon == null) {
                    return Unit.INSTANCE;
                }
                if (ArceusEventHandler.isArceus(pokemon)) {
                    class_3222 player = event.getPlayer();
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = player;
                        ArceusEventHandler.maybeTeleportFromHallOfOrigin(serverPlayer);
                    } else {
                        ArceusEventHandler.handleArceusResolvedNearbyPlayers(pokemon);
                    }
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error handling Arceus captured event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        LegendaryMonuments.LOGGER.info("Registered Arceus event handler (faint/capture -> teleport from Hall of Origin)");
    }

    private static boolean isArceus(Pokemon pokemon) {
        try {
            return pokemon.getSpecies() != null && "arceus".equalsIgnoreCase(pokemon.getSpecies().getName());
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void handleArceusResolvedNearbyPlayers(Pokemon arceus) {
        try {
            if (arceus.getEntity() == null || arceus.getEntity().method_37908() == null) {
                return;
            }
            class_1937 world = arceus.getEntity().method_37908();
            world.method_18456().forEach(player -> {
                if (player instanceof class_3222) {
                    class_3218 sw;
                    class_3222 serverPlayer = (class_3222)player;
                    if (world instanceof class_3218 && (sw = (class_3218)world).method_27983() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY && arceus.getEntity() != null && (double)player.method_5739((class_1297)arceus.getEntity()) <= 64.0) {
                        ArceusEventHandler.maybeTeleportFromHallOfOrigin(serverPlayer);
                    }
                }
            });
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed handling nearby players for Arceus resolution", (Throwable)e);
        }
    }

    private static void maybeTeleportFromHallOfOrigin(class_3222 player) {
        try {
            class_3218 sw;
            class_1937 class_19372 = player.method_37908();
            if (class_19372 instanceof class_3218 && (sw = (class_3218)class_19372).method_27983() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY) {
                LegendaryMonuments.LOGGER.info("Teleporting {} from Hall of Origin after Arceus event", (Object)player.method_5477().getString());
                HallOfOriginTeleporter.teleportFromHallOfOrigin(player);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error teleporting player from Hall of Origin", (Throwable)e);
        }
    }
}

