/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModDataComponentTypes;
import github.jorgaomc.component.UrnProgressComponent;
import github.jorgaomc.item.UrnItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class UrnEventHandler {
    private static final Map<UUID, class_1799> activeUrnTracking = new HashMap<UUID, class_1799>();

    public static void register() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon faintedPokemon = event.getPokemon();
                if (faintedPokemon == null) {
                    return Unit.INSTANCE;
                }
                if (faintedPokemon.getOwnerUUID() == null) {
                    UrnEventHandler.processWildPokemonDefeat(faintedPokemon);
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error processing Pok\u00e9mon fainted event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
    }

    private static void processWildPokemonDefeat(Pokemon defeatedPokemon) {
        try {
            if (defeatedPokemon.getEntity() != null && defeatedPokemon.getEntity().method_37908() != null) {
                defeatedPokemon.getEntity().method_37908().method_18456().forEach(player -> {
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        double distance = player.method_5739((class_1297)defeatedPokemon.getEntity());
                        if (distance <= 32.0) {
                            UrnEventHandler.processDefeat(serverPlayer, defeatedPokemon);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Could not process wild pokemon defeat location-based", (Throwable)e);
        }
    }

    private static void processDefeat(class_3222 player, Pokemon defeatedPokemon) {
        UUID playerId = player.method_5667();
        boolean hasProcessedUrn = false;
        if (activeUrnTracking.containsKey(playerId)) {
            class_1799 trackedStack = activeUrnTracking.get(playerId);
            if (UrnEventHandler.isValidUrnForTracking(trackedStack, (class_1657)player, defeatedPokemon)) {
                UrnEventHandler.updateUrnProgress(player, trackedStack, defeatedPokemon);
                hasProcessedUrn = true;
            } else {
                activeUrnTracking.remove(playerId);
            }
        }
        if (!hasProcessedUrn) {
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                UrnItem urnItem;
                class_1799 stack = player.method_31548().method_5438(i);
                if (!(stack.method_7909() instanceof UrnItem) || UrnEventHandler.isUrnComplete(stack) || !UrnEventHandler.isMatchingType(defeatedPokemon, (urnItem = (UrnItem)stack.method_7909()).getPokemonType())) continue;
                activeUrnTracking.put(playerId, stack);
                UrnEventHandler.updateUrnProgress(player, stack, defeatedPokemon);
                break;
            }
        }
    }

    private static boolean isValidUrnForTracking(class_1799 stack, class_1657 player, Pokemon defeatedPokemon) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof UrnItem) {
            UrnItem urnItem = (UrnItem)class_17922;
            if (UrnEventHandler.isUrnComplete(stack)) {
                return false;
            }
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 inventoryStack = player.method_31548().method_5438(i);
                if (inventoryStack != stack) continue;
                return UrnEventHandler.isMatchingType(defeatedPokemon, urnItem.getPokemonType());
            }
        }
        return false;
    }

    private static boolean isMatchingType(Pokemon pokemon, String requiredType) {
        for (ElementalType type : pokemon.getTypes()) {
            if (!type.getName().equalsIgnoreCase(requiredType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUrnComplete(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof UrnItem) {
            UrnItem urnItem = (UrnItem)class_17922;
            if (stack.method_57826(ModDataComponentTypes.URN_PROGRESS_COMPONENT)) {
                UrnProgressComponent progress = (UrnProgressComponent)stack.method_57824(ModDataComponentTypes.URN_PROGRESS_COMPONENT);
                return progress.isComplete(urnItem.getRequiredProgress());
            }
        }
        return false;
    }

    private static void updateUrnProgress(class_3222 player, class_1799 stack, Pokemon defeatedPokemon) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof UrnItem) {
            UrnItem urnItem = (UrnItem)class_17922;
            if (stack.method_57826(ModDataComponentTypes.URN_PROGRESS_COMPONENT)) {
                UrnProgressComponent currentProgress = (UrnProgressComponent)stack.method_57824(ModDataComponentTypes.URN_PROGRESS_COMPONENT);
                UrnProgressComponent newProgress = currentProgress.withIncrementedProgress();
                stack.method_57379(ModDataComponentTypes.URN_PROGRESS_COMPONENT, (Object)newProgress);
                int progress = newProgress.progress();
                int requiredProgress = urnItem.getRequiredProgress();
                class_124 typeColor = UrnItem.getTypeFormatting(urnItem.getPokemonType());
                player.method_7353((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.update", (Object[])new Object[]{defeatedPokemon.getSpecies().getName(), progress, requiredProgress}).method_27692(typeColor), true);
                if (newProgress.isComplete(requiredProgress)) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"item.legendarymonuments.urn.complete").method_27692(class_124.field_1060), false);
                }
            }
        }
    }
}

