/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SacredAshItem
extends class_1792
implements BagItem {
    public SacredAshItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public String getItemName() {
        return "Sacred Ash";
    }

    public class_1792 getReturnItem() {
        return class_1802.field_8162;
    }

    public boolean canUse(PokemonBattle battle, BattlePokemon target) {
        return target.getHealth() < target.getMaxHealth() || target.getHealth() <= 0 || this.needsPPRestore(target);
    }

    public boolean canStillUse(class_3222 player, PokemonBattle battle, BattleActor actor, BattlePokemon target, class_1799 stack) {
        return this.canUse(battle, target) && stack.method_7947() > 0;
    }

    public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
        return "sacredash";
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (world.field_9236) {
            return class_1271.method_22427((Object)stack);
        }
        if (!(player instanceof class_3222)) {
            return class_1271.method_22431((Object)stack);
        }
        class_3222 serverPlayer = (class_3222)player;
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
        boolean anyHealed = false;
        for (int i = 0; i < party.size(); ++i) {
            boolean wasHealed;
            Pokemon pokemon = party.get(i);
            if (pokemon == null || !(wasHealed = this.healPokemon(pokemon))) continue;
            anyHealed = true;
        }
        if (anyHealed) {
            player.method_7353((class_2561)class_2561.method_43471((String)"item.legendarymonuments.sacred_ash.heal_success"), true);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            return class_1271.method_22428((Object)stack);
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"item.legendarymonuments.sacred_ash.no_effect"), true);
        return class_1271.method_22431((Object)stack);
    }

    private boolean healPokemon(Pokemon pokemon) {
        boolean wasHealed = false;
        boolean isFainted = pokemon.isFainted();
        boolean hasLowHealth = pokemon.getCurrentHealth() < pokemon.getMaxHealth();
        boolean hasLowPP = pokemon.getMoveSet().getMoves().stream().anyMatch(move -> move != null && move.getCurrentPp() < move.getMaxPp());
        if (isFainted || hasLowHealth || hasLowPP) {
            if (isFainted || hasLowHealth) {
                pokemon.setCurrentHealth(pokemon.getMaxHealth());
                wasHealed = true;
            }
            if (hasLowPP) {
                pokemon.getMoveSet().getMoves().forEach(move -> {
                    if (move != null && move.getCurrentPp() < move.getMaxPp()) {
                        move.setCurrentPp(move.getMaxPp());
                    }
                });
                wasHealed = true;
            }
        }
        return wasHealed;
    }

    private boolean needsPPRestore(BattlePokemon battlePokemon) {
        return true;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.legendarymonuments.sacred_ash.tooltip").method_27692(class_124.field_1080));
        super.method_7851(stack, context, tooltip, type);
    }
}

