/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import com.cobblemon.yajatkaul.mega_showdown.item.CompiItems;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import github.jorgaomc.FootprintTracker;
import github.jorgaomc.LMStructures;
import github.jorgaomc.ModBlockEntitiesSign;
import github.jorgaomc.ModBlocks;
import github.jorgaomc.ModFeatures;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.client.screen.KeyItemsScreenHandler;
import github.jorgaomc.component.ModDataComponentTypes;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.data.KeyItemsDataManager;
import github.jorgaomc.data.PlayerAppData;
import github.jorgaomc.effect.ModEffects;
import github.jorgaomc.entities.ModEntities;
import github.jorgaomc.event.ArceusEventHandler;
import github.jorgaomc.event.DreamStringEventHandler;
import github.jorgaomc.event.KeyItemsEventHandler;
import github.jorgaomc.event.SacredAshEventHandler;
import github.jorgaomc.event.UrnEventHandler;
import github.jorgaomc.item.AzureFluteTeleporter;
import github.jorgaomc.network.EnderChestOpenPacket;
import github.jorgaomc.network.HealPacket;
import github.jorgaomc.network.KeyItemsOpenPacket;
import github.jorgaomc.network.LegendaryTrackingPayloads;
import github.jorgaomc.network.PCOpenPacket;
import github.jorgaomc.network.RegiStatueUpdatePacket;
import github.jorgaomc.network.SanctuaryOpenScreenS2CPacket;
import github.jorgaomc.network.SanctuaryUpdateC2SPacket;
import github.jorgaomc.particles.ModParticles;
import github.jorgaomc.screen.ModScreenHandlers;
import github.jorgaomc.screen.SanctuaryScreenHandler;
import github.jorgaomc.util.ModLootTableModifiers;
import github.jorgaomc.villager.ModVillagers;
import github.jorgaomc.world.CosmicDustFeature;
import github.jorgaomc.world.CosmicDustPlacement;
import github.jorgaomc.world.FootprintFeature;
import github.jorgaomc.world.FootprintPlacement;
import github.jorgaomc.world.IlexShrineFeature;
import github.jorgaomc.world.IlexShrinePlacement;
import github.jorgaomc.world.ModDimensions;
import github.jorgaomc.world.ModPlacedFeatures;
import github.jorgaomc.world.StakeFeature;
import github.jorgaomc.world.StakePlacement;
import github.jorgaomc.world.dimension.DistortionWorld;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import github.jorgaomc.world.feature.DistortionTreeFeature;
import github.jorgaomc.world.feature.MiniMountainFeature;
import github.jorgaomc.world.gen.ModOreGeneration;
import github.jorgaomc.world.processor.NetherOpenAreaProcessor;
import github.jorgaomc.world.worldgen.NetherOpenAreaPlacementModifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendaryMonuments
implements ModInitializer {
    private static final Map<UUID, Map<String, class_2338>> LAST_LOCATED = new HashMap<UUID, Map<String, class_2338>>();
    private static final Map<UUID, Map<String, Set<class_2338>>> COMPLETED_LOCATIONS = new HashMap<UUID, Map<String, Set<class_2338>>>();
    public static final String MOD_ID = "legendarymonuments";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"legendarymonuments");
    public static final class_3917<KeyItemsScreenHandler> KEY_ITEMS_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)"legendarymonuments", (String)"key_items"), (Object)new class_3917(KeyItemsScreenHandler::new, class_7701.field_40182));

    public void onInitialize() {
        LOGGER.info("Initializing Legendary Monuments mod!");
        ModEntities.register();
        ModDimensions.initialize();
        DistortionWorld.register();
        HallOfOriginWorld.register();
        AzureFluteTeleporter.register();
        SanctuaryScreenHandler.SANCTUARY_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)"jorgaomc", (String)"sanctuary"), (Object)new class_3917(SanctuaryScreenHandler::new, null));
        PCOpenPacket.registerPayload();
        PCOpenPacket.registerServerReceiver();
        HealPacket.registerPayload();
        HealPacket.registerServerReceiver();
        EnderChestOpenPacket.registerPayload();
        EnderChestOpenPacket.registerServerReceiver();
        KeyItemsOpenPacket.registerPayload();
        KeyItemsOpenPacket.registerServer();
        RegiStatueUpdatePacket.registerPayloadType();
        RegiStatueUpdatePacket.registerServerReceiver();
        SanctuaryUpdateC2SPacket.register();
        SanctuaryOpenScreenS2CPacket.registerPayloadType();
        PayloadTypeRegistry.playC2S().register(LegendaryTrackingPayloads.LocateRequestPayload.ID, LegendaryTrackingPayloads.LocateRequestPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(LegendaryTrackingPayloads.LocateResponsePayload.ID, LegendaryTrackingPayloads.LocateResponsePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(LegendaryTrackingPayloads.KeyItemCheckRequestPayload.ID, LegendaryTrackingPayloads.KeyItemCheckRequestPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(LegendaryTrackingPayloads.KeyItemCheckResponsePayload.ID, LegendaryTrackingPayloads.KeyItemCheckResponsePayload.CODEC);
        this.registerServerPacketHandlers();
        ModScreenHandlers.registerScreenHandlers();
        LMStructures.registerStructureTypes();
        ModVillagers.registerVillagers();
        ModVillagers.registerTrades();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            LOGGER.info("Server started event triggered, initializing FootprintTracker...");
            FootprintTracker.initializeStorage(server);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            LOGGER.info("Player {} disconnected, saving their progress data", (Object)handler.field_14140.method_5477().getString());
            FootprintTracker.savePlayerData(handler.field_14140);
        });
        ModDataComponentTypes.registerComponentTypes();
        ModBlocks.registerBlocks();
        ModBlockEntitiesSign.registerBlockEntities();
        ModBlockEntities.registerBlockEntities();
        ModItems.registerItems();
        ModEffects.registerEffects();
        PedestalConfig.loadConfig();
        ModParticles.registerParticles();
        KeyItemsEventHandler.register();
        UrnEventHandler.register();
        DreamStringEventHandler.register();
        SacredAshEventHandler.register();
        ArceusEventHandler.register();
        FuelRegistry.INSTANCE.add((class_1935)ModItems.GALAR_PARTICLE, (Object)1600);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.GALAR_PARTICLE_BLOCK.method_8389(), (Object)16000);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_LOG, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_LOG, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_PLANKS, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_SLAB, (Object)150);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_STAIRS, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_FENCE, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_FENCE_GATE, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_SIGN, (Object)200);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_PRESSURE_PLATE, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.DISTORTION_BUTTON, (Object)100);
        LOGGER.info("Registering world generation features...");
        ModFeatures.registerFeatures();
        NetherOpenAreaPlacementModifier.register();
        NetherOpenAreaProcessor.register();
        ModBlockEntities.registerBlockEntities();
        FootprintFeature.register();
        FootprintPlacement.registerPlacements();
        IlexShrineFeature.register();
        IlexShrinePlacement.registerPlacements();
        StakeFeature.register();
        StakePlacement.registerPlacements();
        CosmicDustFeature.register();
        CosmicDustPlacement.registerPlacements();
        DistortionTreeFeature.register();
        MiniMountainFeature.register();
        LOGGER.info("Registering ore generation...");
        ModPlacedFeatures.registerPlacedFeatures();
        LOGGER.info("Applying ore generation to biomes...");
        ModOreGeneration.generateOres();
        ModLootTableModifiers.modifyLootTables();
        this.registerPlayerEvents();
        LOGGER.info("Footprint tracking system initialized. Players will need to find {} of each footprint type.", (Object)50);
        LOGGER.info("Legendary Monuments mod initialization complete!");
    }

    private void registerServerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.LocateRequestPayload.ID, (payload, context) -> context.server().execute(() -> {
            try {
                this.handleLocateRequest((LegendaryTrackingPayloads.LocateRequestPayload)payload, context);
            }
            catch (Exception e) {
                LOGGER.error("Error handling locate request for {}: {}", (Object)payload.structureId(), (Object)e.getMessage());
                this.sendNotFoundResponse(payload.structureId(), context);
            }
        }));
        LOGGER.info("Registered server locate request handler");
        ServerPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.KeyItemCheckRequestPayload.ID, (payload, context) -> context.server().execute(() -> {
            try {
                class_3222 player = context.player();
                String itemId = payload.itemId();
                class_2960 iid = class_2960.method_12829((String)itemId);
                class_1792 item = iid == null ? null : (class_1792)class_7923.field_41178.method_10223(iid);
                boolean has = false;
                if (item != null) {
                    try {
                        has = KeyItemsDataManager.hasKeyItem((class_1657)player, item);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                LegendaryTrackingPayloads.KeyItemCheckResponsePayload resp = new LegendaryTrackingPayloads.KeyItemCheckResponsePayload(itemId, has);
                ServerPlayNetworking.send((class_3222)player, (class_8710)resp);
            }
            catch (Exception e) {
                LOGGER.error("Error handling key item check: {}", (Object)e.getMessage(), (Object)e);
            }
        }));
    }

    private void handleLocateRequest(LegendaryTrackingPayloads.LocateRequestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        class_3218 world = player.method_51469();
        LOGGER.info("Processing locate request for: {} from player: {} at: {}", new Object[]{payload.structureId(), player.method_5477().getString(), payload.playerPos()});
        try {
            Map lastMap;
            class_2338 last;
            class_2338 playerPos = payload.playerPos();
            class_2338 structurePos = null;
            String structureId = payload.structureId();
            UUID uuid = context.player().method_5667();
            if (payload.isCompleted() && (last = (class_2338)(lastMap = LAST_LOCATED.computeIfAbsent(uuid, u -> new HashMap())).get(structureId)) != null) {
                Map compMap = COMPLETED_LOCATIONS.computeIfAbsent(uuid, u -> new HashMap());
                Set set = compMap.computeIfAbsent(structureId, s -> new HashSet());
                set.add(last);
            }
            class_1792 required = LegendaryMonuments.getRequiredItemFor(structureId);
            boolean hasInInventory = false;
            if (required != null) {
                for (class_1799 stack : player.method_31548().field_7547) {
                    if (stack.method_7960() || stack.method_7909() != required) continue;
                    hasInInventory = true;
                    break;
                }
            }
            boolean hasInKeyItems = false;
            try {
                hasInKeyItems = KeyItemsDataManager.hasKeyItem((class_1657)player, required);
            }
            catch (Throwable stack) {
                // empty catch block
            }
            if (required != null && !hasInInventory && !hasInKeyItems) {
                LOGGER.info("Player {} missing required item {} for {}", new Object[]{player.method_5477().getString(), required == null ? "<none>" : class_7923.field_41178.method_10221((Object)required), structureId});
                this.sendNotFoundResponse(structureId, context);
                return;
            }
            class_5321 directKey = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)class_2960.method_12829((String)structureId));
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_12829((String)structureId));
            class_2960 setId = LegendaryMonuments.getStructureSetIdFor(structureId);
            if (setId != null) {
                tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)setId);
            }
            int searchRadius = 20000;
            try {
                structurePos = world.method_8487(tag, playerPos, searchRadius, false);
                LOGGER.info("Locate result (skipReferenced=false) for {}: {}", (Object)structureId, (Object)structurePos);
            }
            catch (Exception e) {
                LOGGER.warn("Primary locate failed for {}: {}", (Object)structureId, (Object)e.getMessage());
            }
            if (structurePos == null) {
                try {
                    structurePos = world.method_8487(tag, playerPos, searchRadius, true);
                    LOGGER.info("Locate result (skipReferenced=true) for {}: {}", (Object)structureId, (Object)structurePos);
                }
                catch (Exception e) {
                    LOGGER.warn("Secondary locate failed for {}: {}", (Object)structureId, (Object)e.getMessage());
                }
            }
            Set completedSet = COMPLETED_LOCATIONS.computeIfAbsent(uuid, u -> new HashMap()).getOrDefault(structureId, Collections.emptySet());
            boolean isCompletedPos = false;
            if (structurePos != null) {
                for (class_2338 p : completedSet) {
                    if (!p.method_19771((class_2382)structurePos, 8.0)) continue;
                    isCompletedPos = true;
                    break;
                }
            }
            if (isCompletedPos) {
                class_2338 candidate = structurePos;
                int[] distances = new int[]{4000, 8000, 12000, 16000};
                boolean foundDifferent = false;
                for (int dist : distances) {
                    for (int i = 0; i < 8; ++i) {
                        double ang = Math.PI * 2 * (double)i / 8.0;
                        class_2338 altCenter = playerPos.method_10069((int)(Math.cos(ang) * (double)dist), 0, (int)(Math.sin(ang) * (double)dist));
                        try {
                            candidate = world.method_8487(tag, altCenter, searchRadius, false);
                            if (candidate == null) {
                                candidate = world.method_8487(tag, altCenter, searchRadius, true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean candidateCompleted = false;
                        if (candidate != null) {
                            for (class_2338 p : completedSet) {
                                if (!p.method_19771((class_2382)candidate, 8.0)) continue;
                                candidateCompleted = true;
                                break;
                            }
                        }
                        if (candidate == null || candidateCompleted) continue;
                        structurePos = candidate;
                        foundDifferent = true;
                        break;
                    }
                    if (foundDifferent) break;
                }
            }
            if (structurePos != null) {
                LAST_LOCATED.computeIfAbsent(uuid, u -> new HashMap()).put(structureId, structurePos);
                LegendaryTrackingPayloads.LocateResponsePayload response = new LegendaryTrackingPayloads.LocateResponsePayload(payload.structureId(), true, structurePos);
                ServerPlayNetworking.send((class_3222)player, (class_8710)response);
                LOGGER.info("Sent locate response for {}: {}", (Object)payload.structureId(), (Object)structurePos);
            } else {
                LOGGER.info("Structure {} not found", (Object)payload.structureId());
                this.sendNotFoundResponse(payload.structureId(), context);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error locating structure {}: {}", new Object[]{payload.structureId(), e.getMessage(), e});
            this.sendNotFoundResponse(payload.structureId(), context);
        }
    }

    private static class_1792 getRequiredItemFor(String structureId) {
        String path;
        if (structureId == null) {
            return null;
        }
        return switch (path = structureId.contains(":") ? structureId.substring(structureId.indexOf(58) + 1) : structureId) {
            case "dragonspiraltower" -> ModItems.LIGHTSTONE_SHARD;
            case "turnback_cave" -> class_1802.field_47315;
            case "bell_tower" -> ModItems.RAINBOW_FEATHER;
            case "burned_tower" -> class_1802.field_8814;
            case "heatran_cave" -> ModItems.MAGMA_STONE;
            case "firescourge_shrine" -> ModItems.FIRESCOURGE_SEAL;
            case "grasswither_shrine" -> ModItems.GRASSWITHER_SEAL;
            case "groundblight_shrine" -> ModItems.GROUNDBLIGHT_SEAL;
            case "icerend_shrine" -> ModItems.ICEREND_SEAL;
            case "outskirt_stand" -> class_1802.field_8687;
            case "southern_island" -> class_1802.field_28354;
            case "svpokecenter" -> class_1802.field_8463;
            case "lugia_temple" -> ModItems.VORTEX_STONE;
            case "eternatus_cocoon" -> ModItems.GALAR_PARTICLE;
            case "sword" -> FormeChangeItems.RUSTED_SWORD;
            case "shield" -> FormeChangeItems.RUSTED_SHIELD;
            case "kyuremcave" -> ModItems.IDEALS_BOTTLE;
            case "dyna_tree" -> class_1802.field_42688;
            case "giratina_island" -> CompiItems.GRISEOUS_ORB;
            case "final_island" -> ModItems.OLD_SEA_MAP;
            case "snowpoint_temple" -> ModItems.GOLEM_SCRAP;
            case "spear_pillar" -> ModItems.RED_CHAIN;
            case "lake_valor" -> class_1802.field_8711;
            case "lake_acuity" -> class_1802.field_16998;
            case "lake_verity" -> class_1802.field_28659;
            default -> null;
        };
    }

    private static class_2960 getStructureSetIdFor(String structureId) {
        String path;
        if (structureId == null) {
            return null;
        }
        switch (path = structureId.contains(":") ? structureId.substring(structureId.indexOf(58) + 1) : structureId) {
            case "bell_tower": {
                return ModItems.BELL_TOWER_STRUCTURE_SET.method_29177();
            }
            case "hoopa_pyramid": {
                return ModItems.HOOPA_PYRAMID_STRUCTURE_SET.method_29177();
            }
            case "eternatus_cocoon": {
                return ModItems.ETERNATUS_COCOON_STRUCTURE_SET.method_29177();
            }
            case "lugia_temple": {
                return ModItems.LUGIA_TEMPLE_STRUCTURE_SET.method_29177();
            }
            case "kyuremcave": {
                return ModItems.KYUREM_CAVE_STRUCTURE_SET.method_29177();
            }
            case "regice_temple": {
                return ModItems.REGICE_TEMPLE_STRUCTURE_SET.method_29177();
            }
            case "regirock_temple": {
                return ModItems.REGIROCK_TEMPLE_STRUCTURE_SET.method_29177();
            }
            case "registeel_temple": {
                return ModItems.REGISTEEL_TEMPLE_STRUCTURE_SET.method_29177();
            }
            case "regigigas_temple": {
                return ModItems.REGIGIGAS_TEMPLE_STRUCTURE_SET.method_29177();
            }
            case "dragonspiraltower": {
                return ModItems.DRAGONSPIRAL_TOWER_STRUCTURE_SET.method_29177();
            }
            case "sword": {
                return ModItems.SWORD_STRUCTURE_SET.method_29177();
            }
            case "shield": {
                return ModItems.SHIELD_STRUCTURE_SET.method_29177();
            }
            case "dragoeleki_temple": {
                return ModItems.DRAGOELEKI_TEMPLE_STRUCTURE_SET.method_29177();
            }
            case "dyna_tree": {
                return ModItems.DYNA_TREE_STRUCTURE_SET.method_29177();
            }
            case "southern_island": {
                return ModItems.SOUTHERN_ISLAND_STRUCTURE_SET.method_29177();
            }
            case "heatran_cave": {
                return ModItems.HEATRAN_CAVE_STRUCTURE_SET.method_29177();
            }
            case "burned_tower": {
                return ModItems.BURNED_TOWER_STRUCTURE_SET.method_29177();
            }
            case "giratina_island": {
                return ModItems.GIRATINA_ISLAND_STRUCTURE_SET.method_29177();
            }
            case "final_island": {
                return ModItems.FINAL_ISLAND_STRUCTURE_SET.method_29177();
            }
            case "snowpoint_temple": {
                return ModItems.SNOWPOINT_TEMPLE_STRUCTURE_SET.method_29177();
            }
            case "spear_pillar": {
                return ModItems.SPEAR_PILLAR_STRUCTURE_SET.method_29177();
            }
            case "turnback_cave": {
                return ModItems.TURNBACK_CAVE_STRUCTURE_SET.method_29177();
            }
            case "lake_valor": {
                return ModItems.LAKE_VALOR_STRUCTURE_SET.method_29177();
            }
            case "lake_acuity": {
                return ModItems.LAKE_ACUITY_STRUCTURE_SET.method_29177();
            }
            case "lake_verity": {
                return ModItems.LAKE_VERITY_STRUCTURE_SET.method_29177();
            }
        }
        return null;
    }

    private void sendNotFoundResponse(String structureId, ServerPlayNetworking.Context context) {
        LegendaryTrackingPayloads.LocateResponsePayload response = new LegendaryTrackingPayloads.LocateResponsePayload(structureId, false, class_2338.field_10980);
        ServerPlayNetworking.send((class_3222)context.player(), (class_8710)response);
        LOGGER.info("Sent 'not found' response for: {}", (Object)structureId);
    }

    private void registerPlayerEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            try {
                LOGGER.info("Initializing progress storage systems");
                FootprintTracker.initializeStorage(server);
                PlayerAppData.initializeStorage(server);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize storage systems", (Throwable)e);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                class_3222 player = handler.method_32311();
                if (player != null) {
                    LOGGER.info("Player {} joined, loading progress data", (Object)player.method_5477().getString());
                    FootprintTracker.loadPlayerProgress(player);
                    PlayerAppData.loadPlayerData(player);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error loading player progress data on join", (Throwable)e);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            try {
                class_3222 player = handler.method_32311();
                if (player != null) {
                    LOGGER.info("Player {} disconnected, saving their progress data", (Object)player.method_5477().getString());
                    FootprintTracker.savePlayerData(player);
                    PlayerAppData.savePlayerData(player);
                    if (!player.method_37908().method_8608()) {
                        class_3218 serverWorld = (class_3218)player.method_37908();
                        KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(serverWorld);
                        dataManager.method_80();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error saving player progress data on disconnect", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            try {
                LOGGER.info("Server stopping, saving all player progress data");
                FootprintTracker.saveAllPlayerData();
                PlayerAppData.saveAllPlayerData();
                for (class_3218 world : server.method_3738()) {
                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                    dataManager.method_80();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error saving all player progress data on server stop", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Thread autosaveThread = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(300000L);
                            server.execute(() -> {
                                try {
                                    FootprintTracker.saveAllPlayerData();
                                    for (class_3218 world : server.method_3738()) {
                                        KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                                        dataManager.method_80();
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error during periodic auto-save", (Throwable)e);
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Autosave thread interrupted", (Throwable)e);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error in autosave thread", (Throwable)e);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                }
            });
            autosaveThread.setDaemon(true);
            autosaveThread.setName("LegendaryMonuments-Autosave");
            autosaveThread.start();
        });
    }

    public static void spawnLegendaryPokemon(class_3222 player, String pokemonName, boolean isShiny) {
        int x = (int)Math.floor(player.method_23317());
        int y = (int)Math.floor(player.method_23318());
        int z = (int)Math.floor(player.method_23321());
        String command = "pokespawnat " + x + " " + y + " " + z + " " + pokemonName + " lvl=70";
        if (isShiny) {
            command = command + " shiny";
        }
        LOGGER.info("Executing command to spawn {}: {}", (Object)pokemonName, (Object)command);
        player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), command);
    }
}

