/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.jorgaomc.LMStructures;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5434;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;

public class SouthernIslandStructure
extends class_3195 {
    public static final class_2960 STRUCTURE_ID = class_2960.method_60655((String)"legendarymonuments", (String)"southern_island");
    public static final MapCodec<SouthernIslandStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SouthernIslandStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)class_9778.field_51952.optionalFieldOf("dimension_padding", (Object)class_5434.field_51911).forGetter(structure -> structure.dimensionPadding), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, SouthernIslandStructure::new));
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final class_9778 dimensionPadding;
    private final class_9822 liquidSettings;

    public SouthernIslandStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, class_9778 dimensionPadding, class_9822 liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
        LegendaryMonuments.LOGGER.info("Created Southern Island structure with maxDistanceFromCenter: {}", (Object)maxDistanceFromCenter);
    }

    private static boolean extraSpawningChecks(class_3195.class_7149 context) {
        boolean validHeight;
        class_1923 chunkpos = context.comp_568();
        int height = context.comp_562().method_18028(chunkpos.method_8326(), chunkpos.method_8328(), class_2902.class_2903.field_13195, context.comp_569(), context.comp_564());
        boolean bl = validHeight = height > 40 && height < 70;
        if (!validHeight) {
            LegendaryMonuments.LOGGER.debug("Southern Island rejected at ({}, {}) - height: {}", new Object[]{chunkpos.method_8326(), chunkpos.method_8328(), height});
        }
        return validHeight;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!SouthernIslandStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_1923 chunkPos = context.comp_568();
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), startY, chunkPos.method_8328());
        LegendaryMonuments.LOGGER.info("Attempting to generate Southern Island at ({}, {}, {})", new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
        Optional<class_3195.class_7150> structurePiecesGenerator = this.generateEnhanced(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, class_8891.field_46826, this.dimensionPadding, this.liquidSettings);
        if (structurePiecesGenerator.isPresent()) {
            LegendaryMonuments.LOGGER.info("Successfully generated Southern Island at ({}, {}, {})", new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
        } else {
            LegendaryMonuments.LOGGER.warn("Failed to generate Southern Island at ({}, {}, {})", new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
        }
        return structurePiecesGenerator;
    }

    private Optional<class_3195.class_7150> generateEnhanced(class_3195.class_7149 context, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_2338 pos, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, class_8891 structurePoolAliasLookup, class_9778 dimensionPadding, class_9822 liquidSettings) {
        LegendaryMonuments.LOGGER.info("Enhanced Southern Island generation with size: {}, maxDistance: {}", (Object)size, (Object)maxDistanceFromCenter);
        try {
            Optional result = class_3778.method_30419((class_3195.class_7149)context, startPool, startJigsawName, (int)size, (class_2338)pos, (boolean)useExpansionHack, projectStartToHeightmap, (int)maxDistanceFromCenter, (class_8891)structurePoolAliasLookup, (class_9778)dimensionPadding, (class_9822)liquidSettings);
            if (result.isEmpty()) {
                LegendaryMonuments.LOGGER.warn("StructurePoolBasedGenerator returned empty result");
            }
            return result;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error during Southern Island generation: {}", (Object)e.getMessage());
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public class_7151<?> method_41618() {
        return LMStructures.SOUTHERN_ISLAND;
    }

    public static void registerForMaps() {
        LegendaryMonuments.LOGGER.info("Registering Southern Island structure for map discovery");
        try {
            class_6862 structureTag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)ModItems.SOUTHERN_ISLAND_STRUCTURE_SET.method_29177());
            LegendaryMonuments.LOGGER.info("Created structure tag: {}", (Object)structureTag);
            LegendaryMonuments.LOGGER.info("Southern Island structure ID: {}", (Object)STRUCTURE_ID);
            class_5321 structureKey = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)STRUCTURE_ID);
            LegendaryMonuments.LOGGER.info("Structure registry key: {}", (Object)structureKey);
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error registering Southern Island for maps: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

