/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class NewmoonWhistleItem
extends class_1792 {
    private static final double SHINY_CHANCE = 0.02;

    public NewmoonWhistleItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (world.field_9236) {
            return class_1271.method_22427((Object)stack);
        }
        boolean successful = this.spawnDarkrai(world, player);
        if (successful) {
            world.method_8396(null, player.method_24515(), class_3417.field_14703, class_3419.field_15248, 1.0f, 1.0f);
            stack.method_7934(1);
        }
        return class_1271.method_22427((Object)stack);
    }

    private boolean spawnDarkrai(class_1937 world, class_1657 player) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)world;
        try {
            Pokemon pokemon;
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("darkrai");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            LegendaryMonuments.LOGGER.info("Created Darkrai pokemon object: {}", (Object)((pokemon = properties.create()) != null ? 1 : 0));
            PokemonEntity entity = new PokemonEntity((class_1937)serverWorld, pokemon, CobblemonEntities.POKEMON);
            LegendaryMonuments.LOGGER.info("Created Darkrai entity object: {}", (Object)(entity != null ? 1 : 0));
            double spawnX = player.method_23317() + player.method_5720().field_1352 * 3.0;
            double spawnY = player.method_23318() + 1.0;
            double spawnZ = player.method_23321() + player.method_5720().field_1350 * 3.0;
            entity.method_5814(spawnX, spawnY, spawnZ);
            try {
                this.spawnDarkraiEffect(serverWorld, new class_2338((int)spawnX, (int)spawnY, (int)spawnZ));
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error in particle effect but continuing with spawn", (Throwable)e);
            }
            boolean spawned = serverWorld.method_8649((class_1297)entity);
            LegendaryMonuments.LOGGER.info("Darkrai entity spawn result: {}", (Object)spawned);
            if (isShiny) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Newmoon Whistle creates an eerie void! ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)"A SHINY Darkrai appears!").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Newmoon Whistle summons shadows! ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)"A Darkrai appears!").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})), false);
            }
            LegendaryMonuments.LOGGER.info("Spawned {} Darkrai for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.method_5477().getString());
            return spawned;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Darkrai", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)"The Newmoon Whistle's darkness dissipates unsuccessfully.").method_27692(class_124.field_1061), true);
            return false;
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.legendarymonuments.newmoon_whistle.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.legendarymonuments.newmoon_whistle.tooltip.2").method_27692(class_124.field_1064));
        super.method_7851(stack, context, tooltip, type);
    }

    private void spawnDarkraiEffect(class_3218 world, class_2338 pos) {
        class_5819 random = world.method_8409();
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15163, class_3419.field_15251, 0.7f, 0.4f);
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14879, class_3419.field_15251, 0.6f, 0.5f);
        class_2168 source = world.method_8503().method_3739().method_9208(pos.method_46558()).method_9227(world).method_9217();
        for (int radius = 1; radius < 12; ++radius) {
            int r = radius;
            world.method_8503().execute(() -> world.method_8503().method_3734().method_44252(source, "particle minecraft:large_smoke ~ ~1 ~ " + (double)r * 0.3 + " 0.5 " + (double)r * 0.3 + " 0.01 " + r * 2 + " force"));
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (int i = 0; i < 5; ++i) {
            double offsetX = (random.method_43058() - 0.5) * 8.0;
            double offsetZ = (random.method_43058() - 0.5) * 8.0;
            world.method_8503().method_3734().method_44252(source, String.format("particle minecraft:portal %s %s %s 0.7 1.0 0.7 0.5 100 force", (double)pos.method_10263() + offsetX, pos.method_10264(), (double)pos.method_10260() + offsetZ));
        }
        world.method_8503().method_3734().method_44252(source, "particle minecraft:dust 0.1 0.0 0.1 1.5 ~ ~1 ~ 4 2 4 0.05 150 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:sculk_soul ~ ~1 ~ 5 2 5 0.1 100 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:soul_fire_flame ~ ~1 ~ 3 2 3 0.05 80 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:reverse_portal ~ ~1 ~ 1 1 1 0.1 100 force");
        world.method_8503().execute(() -> {
            try {
                Thread.sleep(500L);
                for (int radius = 1; radius < 10; radius += 2) {
                    int r = radius;
                    world.method_8503().execute(() -> {
                        for (int i = 0; i < 36; ++i) {
                            double angle = (double)i * Math.PI / 18.0;
                            double x = (double)pos.method_10263() + Math.cos(angle) * (double)r;
                            double z = (double)pos.method_10260() + Math.sin(angle) * (double)r;
                            world.method_8503().method_3734().method_44252(source, String.format("particle minecraft:dust 0.0 0.0 0.0 1.0 %s %s %s 0.0 0.0 0.0 0 1 force", x, (double)pos.method_10264() + 0.5, z));
                        }
                    });
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14812, class_3419.field_15251, 0.7f, 0.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

