/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import github.jorgaomc.FootprintTracker;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModBlocks;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class FootprintBlock
extends class_2248 {
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public FootprintBlock() {
        super((class_4970.class_2251)FabricBlockSettings.create().mapColor(class_1767.field_7944).strength(-1.0f, 3600000.0f).noCollision().nonOpaque());
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public boolean method_9506(class_2680 state) {
        return false;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608()) {
            this.handleFootprintInteraction(world, pos, state, player);
        }
        return class_1269.field_5812;
    }

    private void handleFootprintInteraction(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        LegendaryMonuments.LOGGER.info("Player {} is interacting with footprint at {}", (Object)player.method_5477().getString(), (Object)pos);
        FootprintTracker.FootprintType footprintType = null;
        class_2248 block = state.method_26204();
        if (block == ModBlocks.TERRAKION_FOOTPRINTS) {
            footprintType = FootprintTracker.FootprintType.TERRAKION;
            LegendaryMonuments.LOGGER.info("Found Terrakion footprint");
        } else if (block == ModBlocks.COBALION_FOOTPRINTS) {
            footprintType = FootprintTracker.FootprintType.COBALION;
            LegendaryMonuments.LOGGER.info("Found Cobalion footprint");
        } else if (block == ModBlocks.VIRIZION_FOOTPRINTS) {
            footprintType = FootprintTracker.FootprintType.VIRIZION;
            LegendaryMonuments.LOGGER.info("Found Virizion footprint");
        }
        if (footprintType == null) {
            LegendaryMonuments.LOGGER.warn("Could not determine footprint type for block: {}", (Object)block);
            return;
        }
        LegendaryMonuments.LOGGER.info("Recording footprint found for player");
        boolean isComplete = FootprintTracker.recordFootprintFound(player, footprintType);
        if (isComplete && player instanceof class_3222) {
            LegendaryMonuments.LOGGER.info("Player completed collection! Executing command");
            FootprintTracker.executeCompletionCommand((class_3222)player, footprintType);
        }
        world.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 0.5f, 1.5f);
        LegendaryMonuments.LOGGER.info("Removing footprint block");
        world.method_8650(pos, false);
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }
}

