/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3620;
import net.minecraft.class_757;

public class ChunkImage {
    private final class_1937 world;
    private final class_1923 chunkPos;
    private final int yLevel;
    public class_2960 textureId;
    private boolean textureRegistered = false;

    public ChunkImage(class_1937 world, class_1923 chunkPos, int yLevel) {
        this.world = world;
        this.chunkPos = chunkPos;
        this.yLevel = yLevel;
    }

    public void bindTexture() {
        if (!this.textureRegistered) {
            this.createAndRegisterTexture();
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.textureId);
    }

    public void dispose() {
        if (this.textureRegistered && this.textureId != null) {
            class_310.method_1551().method_1531().method_4615(this.textureId);
            this.textureRegistered = false;
            this.textureId = null;
        }
    }

    private void createAndRegisterTexture() {
        class_1011 image = this.createImage();
        this.textureId = class_2960.method_60655((String)"legendarymonuments", (String)("chunk_" + this.chunkPos.field_9181 + "_" + this.chunkPos.field_9180 + "_" + this.yLevel));
        class_310.method_1551().method_1531().method_4616(this.textureId, (class_1044)new class_1043(image));
        this.textureRegistered = true;
    }

    private class_1011 createImage() {
        int width = 16;
        int height = 16;
        class_1011 image = new class_1011(class_1011.class_1012.field_4997, 16, 16, false);
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                int westY;
                int northY;
                class_2338 pos;
                if (this.shouldDrawAtSameLayer()) {
                    pos = this.getFirstBlockGoingDown(this.chunkPos.method_8326() + x, this.yLevel + 1, this.chunkPos.method_8328() + z, 5);
                    northY = this.getFirstBlockGoingDown(this.chunkPos.method_8326() + x, this.yLevel + 1, this.chunkPos.method_8328() + z - 1, 6).method_10264();
                    westY = this.getFirstBlockGoingDown(this.chunkPos.method_8326() + x - 1, this.yLevel + 1, this.chunkPos.method_8328() + z, 6).method_10264();
                } else {
                    pos = this.world.method_8598(class_2902.class_2903.field_13202, new class_2338(this.chunkPos.method_8326() + x, 0, this.chunkPos.method_8328() + z)).method_10074();
                    northY = this.world.method_8624(class_2902.class_2903.field_13202, pos.method_10263(), pos.method_10260() - 1) - 1;
                    westY = this.world.method_8624(class_2902.class_2903.field_13202, pos.method_10263() - 1, pos.method_10260()) - 1;
                }
                class_2680 state = this.world.method_8320(pos);
                class_3620 color = state.method_26205((class_1922)this.world, pos);
                int rgb = color == null || color == class_3620.field_16008 ? 9139029 : color.field_16011;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (pos.method_10264() > northY && northY >= 0 || pos.method_10264() > westY && westY >= 0) {
                    if (red == 0 && green == 0 && blue == 0) {
                        red = 3;
                        green = 3;
                        blue = 3;
                    } else {
                        if (red > 0 && red < 3) {
                            red = 3;
                        }
                        if (green > 0 && green < 3) {
                            green = 3;
                        }
                        if (blue > 0 && blue < 3) {
                            blue = 3;
                        }
                        red = Math.min((int)((double)red / 0.7), 255);
                        green = Math.min((int)((double)green / 0.7), 255);
                        blue = Math.min((int)((double)blue / 0.7), 255);
                    }
                }
                if (pos.method_10264() < northY && northY >= 0 || pos.method_10264() < westY && westY >= 0) {
                    red = Math.max((int)((double)red * 0.7), 0);
                    green = Math.max((int)((double)green * 0.7), 0);
                    blue = Math.max((int)((double)blue * 0.7), 0);
                }
                if (red == 0 && green == 0 && blue == 0) {
                    blue = 32;
                    green = 32;
                    red = 32;
                }
                image.method_4305(x, z, 0xFF000000 | blue << 16 | green << 8 | red);
            }
        }
        return image;
    }

    private class_2338 getFirstBlockGoingDown(int x, int y, int z, int maxTries) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        int tries = 0;
        while (this.world.method_22347((class_2338)pos) && ++tries < maxTries) {
            pos.method_33098(pos.method_10264() - 1);
        }
        return pos;
    }

    private boolean shouldDrawAtSameLayer() {
        return this.world.method_8597().comp_643();
    }
}

