/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import github.jorgaomc.data.KeyItemsDataManager;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class KeyItemsScreenHandler
extends class_1703 {
    public static final int STORAGE_ROWS = 7;
    public static final int STORAGE_COLS = 9;
    public static final int STORAGE_SIZE = 63;
    private final class_1263 storageInventory;
    private final class_1657 player;
    private static final Set<class_1792> ALLOWED_KEY_ITEMS = Set.of(ModItems.GRASSWITHER_SEAL, ModItems.ICEREND_SEAL, ModItems.GROUNDBLIGHT_SEAL, ModItems.FIRESCOURGE_SEAL, ModItems.MAGMA_STONE, ModItems.YELLOW_FEATHER, ModItems.BLUE_FEATHER, ModItems.RED_FEATHER, ModItems.ZAP_STONE, ModItems.ARCTIC_STONE, ModItems.MOLTEN_STONE, ModItems.VORTEX_STONE, ModItems.GS_BALL, ModItems.RAINBOW_FEATHER, ModItems.IDEALS_BOTTLE, ModItems.TRUTH_BOTTLE, ModItems.DARKSTONE, ModItems.DARKSTONE_SHARD, ModItems.LIGHTSTONE, ModItems.LIGHTSTONE_SHARD, ModItems.DYNA_APPLE, ModItems.SPECIAL_MEAT_CHUNKS, ModItems.SPECIAL_SPICES, ModItems.SPECIAL_LEAFY_GREENS, ModItems.GALAR_PARTICLE, ModItems.UXIE_CLAW, ModItems.AZELF_FANG, ModItems.MESPRIT_PLUME, ModItems.RED_CHAIN, ModItems.POKETREAT_BOX, ModItems.LATIAS_TREAT, ModItems.LATIOS_TREAT, ModItems.SUICUNE_TREAT, ModItems.RAIKOU_TREAT, ModItems.ENTEI_TREAT, ModItems.TIME_GLOBE, ModItems.SPACE_GLOBE, ModItems.ANTIMATTER_GLOBE, ModItems.CELESTICA_FLUTE, ModItems.TITAN_KEY, ModItems.ELECTRIC_GOLEM_KEY, ModItems.ROCK_GOLEM_KEY, ModItems.DRAGON_GOLEM_KEY, ModItems.ICE_GOLEM_KEY, ModItems.STEEL_GOLEM_KEY, ModItems.OLD_SEA_MAP);

    public KeyItemsScreenHandler(int syncId, class_1661 playerInventory) {
        super(LegendaryMonuments.KEY_ITEMS_SCREEN_HANDLER, syncId);
        class_1657 class_16572;
        this.player = playerInventory.field_7546;
        LegendaryMonuments.LOGGER.info("=== KeyItemsScreenHandler Constructor ===");
        LegendaryMonuments.LOGGER.info("Player: {}", (Object)this.player.method_5477().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)this.player.method_37908().method_8608());
        LegendaryMonuments.LOGGER.info("Player is ServerPlayerEntity: {}", (Object)(this.player instanceof class_3222));
        if (!this.player.method_37908().method_8608() && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            LegendaryMonuments.LOGGER.info("SERVER SIDE - Loading persistent inventory");
            class_3218 world = (class_3218)serverPlayer.method_37908();
            KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
            this.storageInventory = dataManager.getKeyItemsInventory(this.player);
            int existingItems = 0;
            for (int i = 0; i < this.storageInventory.method_5439(); ++i) {
                if (this.storageInventory.method_5438(i).method_7960()) continue;
                ++existingItems;
            }
            LegendaryMonuments.LOGGER.info("Loaded existing inventory with {} items", (Object)existingItems);
        } else {
            LegendaryMonuments.LOGGER.info("CLIENT SIDE - Creating temporary inventory");
            this.storageInventory = new class_1277(63);
        }
        this.setupSlots(playerInventory);
    }

    private void setupSlots(class_1661 playerInventory) {
        int col;
        int storageStartX = 28;
        int storageStartY = 44;
        for (int row = 0; row < 7; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int slotIndex = row * 9 + col2;
                this.method_7621(new KeyItemSlot(this.storageInventory, slotIndex, storageStartX + col2 * 18, storageStartY + row * 18));
            }
        }
        int invStartY = storageStartY + 126 + 14;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                int slotIndex = col + row * 9 + 9;
                this.method_7621(new class_1735((class_1263)playerInventory, slotIndex, storageStartX + col * 18, invStartY + row * 18));
            }
        }
        int hotbarY = invStartY + 54 + 4;
        for (col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, storageStartX + col * 18, hotbarY));
        }
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        LegendaryMonuments.LOGGER.info("=== QUICKMOVE DEBUG ===");
        LegendaryMonuments.LOGGER.info("Slot index: {}, Player: {}", (Object)slotIndex, (Object)player.method_5477().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)player.method_37908().method_8608());
        if (slotIndex < 0 || slotIndex >= this.field_7761.size()) {
            return class_1799.field_8037;
        }
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 original = slot.method_7677();
        class_1799 copy = original.method_7972();
        LegendaryMonuments.LOGGER.info("Moving item: {} x{}", (Object)original.method_7909().toString(), (Object)original.method_7947());
        if (slotIndex < 63) {
            if (!this.method_7616(original, 63, this.field_7761.size(), true)) {
                return class_1799.field_8037;
            }
        } else {
            if (!ALLOWED_KEY_ITEMS.contains(original.method_7909())) {
                return class_1799.field_8037;
            }
            if (!this.method_7616(original, 0, 63, false)) {
                return class_1799.field_8037;
            }
        }
        if (original.method_7960()) {
            slot.method_53512(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        this.saveInventoryDataDebug("quickMove");
        return copy;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        LegendaryMonuments.LOGGER.info("=== SLOT CLICK DEBUG ===");
        LegendaryMonuments.LOGGER.info("Slot: {}, Button: {}, Action: {}, Player: {}", new Object[]{slotIndex, button, actionType, player.method_5477().getString()});
        super.method_7593(slotIndex, button, actionType, player);
        this.saveInventoryDataDebug("slotClick");
    }

    public void method_7595(class_1657 player) {
        LegendaryMonuments.LOGGER.info("=== SCREEN CLOSED DEBUG ===");
        LegendaryMonuments.LOGGER.info("Player: {}", (Object)player.method_5477().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)player.method_37908().method_8608());
        super.method_7595(player);
        int itemCount = 0;
        for (int i = 0; i < this.storageInventory.method_5439(); ++i) {
            if (this.storageInventory.method_5438(i).method_7960()) continue;
            class_1799 stack = this.storageInventory.method_5438(i);
            LegendaryMonuments.LOGGER.info("Slot {}: {} x{}", new Object[]{i, stack.method_7909().toString(), stack.method_7947()});
            ++itemCount;
        }
        LegendaryMonuments.LOGGER.info("Total items to save: {}", (Object)itemCount);
        this.saveInventoryDataDebug("screenClose");
    }

    private void saveInventoryDataDebug(String trigger) {
        LegendaryMonuments.LOGGER.info("=== SAVE ATTEMPT ({}) ===", (Object)trigger);
        LegendaryMonuments.LOGGER.info("Player: {}", (Object)this.player.method_5477().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)this.player.method_37908().method_8608());
        LegendaryMonuments.LOGGER.info("Player instanceof ServerPlayerEntity: {}", (Object)(this.player instanceof class_3222));
        if (this.player.method_37908().method_8608()) {
            LegendaryMonuments.LOGGER.info("SKIPPING SAVE - Client side");
            return;
        }
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            LegendaryMonuments.LOGGER.error("SKIPPING SAVE - Player is not ServerPlayerEntity");
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        try {
            LegendaryMonuments.LOGGER.info("Attempting server-side save...");
            class_3218 world = (class_3218)serverPlayer.method_37908();
            LegendaryMonuments.LOGGER.info("Got ServerWorld: {}", (Object)world.method_27983().method_29177());
            KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
            LegendaryMonuments.LOGGER.info("Got DataManager: {}", (Object)(dataManager != null ? "SUCCESS" : "NULL"));
            if (dataManager == null) {
                LegendaryMonuments.LOGGER.error("DataManager is null! Cannot save.");
                return;
            }
            int itemCount = 0;
            for (int i = 0; i < this.storageInventory.method_5439(); ++i) {
                if (this.storageInventory.method_5438(i).method_7960()) continue;
                ++itemCount;
            }
            LegendaryMonuments.LOGGER.info("Saving {} items to data manager", (Object)itemCount);
            dataManager.savePlayerKeyItems(this.player, this.storageInventory);
            LegendaryMonuments.LOGGER.info("Save method completed successfully");
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("SAVE FAILED with exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        boolean result = super.method_7616(stack, startIndex, endIndex, fromLast);
        if (result) {
            LegendaryMonuments.LOGGER.info("insertItem successful, triggering save");
            this.saveInventoryDataDebug("insertItem");
        }
        return result;
    }

    private static class KeyItemSlot
    extends class_1735 {
        public KeyItemSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return ALLOWED_KEY_ITEMS.contains(stack.method_7909());
        }
    }
}

