/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import github.jorgaomc.LegendaryMonuments;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class PlayerAppData {
    private static final String DATA_FILE_NAME = "phone_apps_data.json";
    private static final Map<UUID, Set<String>> currentWorldData = new HashMap<UUID, Set<String>>();
    private static File dataFile;
    private static final Gson GSON;
    private static final Type DATA_TYPE;
    private static final Set<String> DEFAULT_APPS;
    private static final Set<String> UPGRADEABLE_APPS;
    private final Set<String> unlockedApps = new HashSet<String>();

    public static void initializeStorage(MinecraftServer server) {
        try {
            LegendaryMonuments.LOGGER.info("Initializing phone app data storage");
            File worldDir = server.method_27050(class_5218.field_24188).toFile();
            File dataDir = new File(worldDir, "legendary-monuments-data");
            if (!dataDir.exists() && !dataDir.mkdirs()) {
                LegendaryMonuments.LOGGER.error("Failed to create data directory");
                return;
            }
            dataFile = new File(dataDir, DATA_FILE_NAME);
            currentWorldData.clear();
            if (dataFile.exists()) {
                try (FileReader reader = new FileReader(dataFile);){
                    Map loadedData = (Map)GSON.fromJson((Reader)reader, DATA_TYPE);
                    if (loadedData != null) {
                        currentWorldData.putAll(loadedData);
                        LegendaryMonuments.LOGGER.info("Loaded app data for {} players", (Object)loadedData.size());
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("Failed to load app data", (Throwable)e);
                }
            }
            LegendaryMonuments.LOGGER.info("App data storage initialized");
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to initialize storage", (Throwable)e);
        }
    }

    public void readFromStorage(class_1657 player) {
        UUID playerUUID;
        Set<String> storedApps;
        this.unlockedApps.clear();
        this.unlockedApps.addAll(DEFAULT_APPS);
        if (player != null && (storedApps = currentWorldData.get(playerUUID = player.method_5667())) != null) {
            this.unlockedApps.addAll(storedApps);
        }
    }

    public void writeToStorage(class_1657 player) {
        if (player != null) {
            UUID playerUUID = player.method_5667();
            HashSet<String> upgradeableOnly = new HashSet<String>();
            for (String app : this.unlockedApps) {
                if (!UPGRADEABLE_APPS.contains(app)) continue;
                upgradeableOnly.add(app);
            }
            currentWorldData.put(playerUUID, upgradeableOnly);
            PlayerAppData.saveAllPlayerData();
        }
    }

    public static void saveAllPlayerData() {
        if (dataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save: dataFile is null");
            return;
        }
        try (FileWriter writer = new FileWriter(dataFile);){
            GSON.toJson(currentWorldData, (Appendable)writer);
            LegendaryMonuments.LOGGER.debug("Saved app data for {} players", (Object)currentWorldData.size());
        }
        catch (IOException e) {
            LegendaryMonuments.LOGGER.error("Failed to save app data", (Throwable)e);
        }
    }

    public boolean isAppUnlocked(String appName) {
        return this.unlockedApps.contains(appName);
    }

    public boolean unlockApp(String appName, class_1657 player) {
        if (!UPGRADEABLE_APPS.contains(appName) || this.unlockedApps.contains(appName)) {
            return false;
        }
        if (player == null) {
            return false;
        }
        HashMap<class_1792, Integer> cost = new HashMap<class_1792, Integer>();
        class_1792 upgradeItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"upgrade"));
        cost.put(upgradeItem, 1);
        switch (appName) {
            case "Pok\u00e9dex": {
                cost.put((class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"pokedex_white")), 1);
                break;
            }
            case "PC": {
                cost.put((class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"pc")), 1);
                break;
            }
            case "Ender Chest": {
                cost.put(class_1802.field_8466, 1);
                break;
            }
            case "Heal": {
                cost.put((class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"healing_machine")), 1);
                break;
            }
        }
        if (!this.hasItems(player, cost)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.legendarymonuments.system_upgrades.missing_items"), true);
            return false;
        }
        this.consumeItems(player, cost);
        this.unlockedApps.add(appName);
        this.writeToStorage(player);
        return true;
    }

    private boolean hasItems(class_1657 player, Map<class_1792, Integer> cost) {
        HashMap<class_1792, Integer> counts = new HashMap<class_1792, Integer>();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960()) continue;
            counts.merge(stack.method_7909(), stack.method_7947(), Integer::sum);
        }
        for (Map.Entry<class_1792, Integer> e : cost.entrySet()) {
            int have = counts.getOrDefault(e.getKey(), 0);
            if (have >= e.getValue()) continue;
            return false;
        }
        return true;
    }

    private void consumeItems(class_1657 player, Map<class_1792, Integer> cost) {
        for (Map.Entry<class_1792, Integer> e : cost.entrySet()) {
            class_1792 item = e.getKey();
            int toRemove = e.getValue();
            for (int i = 0; i < player.method_31548().method_5439() && toRemove > 0; ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (stack.method_7960() || stack.method_7909() != item) continue;
                int remove = Math.min(stack.method_7947(), toRemove);
                stack.method_7934(remove);
                if (stack.method_7960()) {
                    player.method_31548().method_5447(i, class_1799.field_8037);
                }
                toRemove -= remove;
            }
        }
        player.method_31548().method_5431();
    }

    public Set<String> getUnlockedApps() {
        return new HashSet<String>(this.unlockedApps);
    }

    public static void loadPlayerData(class_3222 player) {
        if (dataFile == null && player.method_5682() != null) {
            PlayerAppData.initializeStorage(player.method_5682());
        }
        UUID playerUUID = player.method_5667();
        currentWorldData.putIfAbsent(playerUUID, new HashSet());
        LegendaryMonuments.LOGGER.debug("Loaded data for player {}", (Object)player.method_5477().getString());
    }

    public static void savePlayerData(class_3222 player) {
        PlayerAppData.saveAllPlayerData();
        LegendaryMonuments.LOGGER.debug("Saved data for player {}", (Object)player.method_5477().getString());
    }

    public static boolean isUpgradeable(String appName) {
        return UPGRADEABLE_APPS.contains(appName);
    }

    public static boolean isDefaultApp(String appName) {
        return DEFAULT_APPS.contains(appName);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        DATA_TYPE = new TypeToken<Map<UUID, Set<String>>>(){}.getType();
        DEFAULT_APPS = Set.of("Map", "Legendary Tracking", "Key Items", "System Upgrades", "Settings");
        UPGRADEABLE_APPS = Set.of("PC", "Pok\u00e9dex", "Heal", "Ender Chest");
    }
}

