/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9304;

public class TitanHammer
extends class_1766 {
    private static final Map<UUID, Long> LAST_AOE_ATTACK = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> LAST_QUAKE_ATTACK = new HashMap<UUID, Long>();
    private static final long AOE_COOLDOWN = 1000L;
    private static final long QUAKE_COOLDOWN = 3000L;
    private static final int MAX_CHARGE_TICKS = 60;

    public TitanHammer(class_1832 material, class_1792.class_1793 settings) {
        super(material, class_3481.field_33715, settings);
    }

    public static class_9285 createAttributeModifiers() {
        return class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(class_2960.method_60655((String)"legendarymonuments", (String)"titan_hammer_attack_damage"), 7.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(class_2960.method_60655((String)"legendarymonuments", (String)"titan_hammer_attack_speed"), -3.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23722, new class_1322(class_2960.method_60655((String)"legendarymonuments", (String)"titan_hammer_knockback"), 2.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486();
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 15;
    }

    public static boolean isValidEnchantment(class_6880<class_1887> enchantment) {
        return enchantment.method_40225(class_1893.field_9118) || enchantment.method_40225(class_1893.field_9123) || enchantment.method_40225(class_1893.field_9112) || enchantment.method_40225(class_1893.field_9130) || enchantment.method_40225(class_1893.field_9099) || enchantment.method_40225(class_1893.field_9131) || enchantment.method_40225(class_1893.field_9119) || enchantment.method_40225(class_1893.field_9101) || enchantment.method_40225(class_1893.field_9124) || enchantment.method_40225(class_1893.field_9110);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            class_1937 class_19372 = attacker.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                this.performAoeAttack(player, target, serverWorld);
                this.attemptStagger(target);
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    private void performAoeAttack(class_1657 player, class_1309 target, class_3218 world) {
        UUID playerId;
        long currentTime = System.currentTimeMillis();
        if (currentTime - LAST_AOE_ATTACK.getOrDefault(playerId = player.method_5667(), 0L) < 1000L) {
            return;
        }
        LAST_AOE_ATTACK.put(playerId, currentTime);
        class_238 aoeBox = class_238.method_30048((class_243)target.method_19538(), (double)4.0, (double)4.0, (double)4.0);
        List nearbyMobs = world.method_8390(class_1309.class, aoeBox, entity -> entity != target && entity != player && entity.method_5805());
        for (class_1309 mob : nearbyMobs) {
            mob.method_5643(world.method_48963().method_48802(player), 4.0f);
            class_243 knockbackDirection = mob.method_19538().method_1020(target.method_19538()).method_1029();
            if (!(knockbackDirection.method_1027() > 0.0)) continue;
            mob.method_5762(knockbackDirection.field_1352 * 0.5, 0.2, knockbackDirection.field_1350 * 0.5);
            mob.field_6037 = true;
        }
        world.method_14199((class_2394)class_2398.field_11227, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 5, 1.0, 0.5, 1.0, 0.1);
        world.method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), class_3417.field_14706, class_3419.field_15248, 1.0f, 1.0f);
    }

    private void attemptStagger(class_1309 target) {
        if (target.method_37908().method_8409().method_43057() < 0.25f) {
            target.method_6092(new class_1293(class_1294.field_5909, 12, 2, false, false));
            class_1937 class_19372 = target.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_14199((class_2394)class_2398.field_11205, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 3, 0.3, 0.3, 0.3, 0.1);
            }
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 60;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                this.performQuakeAttack(player, serverWorld, 60, stack);
            }
        }
        return stack;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                int chargeTime = 60 - remainingUseTicks;
                this.performQuakeAttack(player, serverWorld, chargeTime, stack);
            }
        }
    }

    private void performQuakeAttack(class_1657 player, class_3218 world, int chargeTime, class_1799 hammerStack) {
        UUID playerId;
        long currentTime = System.currentTimeMillis();
        if (currentTime - LAST_QUAKE_ATTACK.getOrDefault(playerId = player.method_5667(), 0L) < 3000L) {
            return;
        }
        LAST_QUAKE_ATTACK.put(playerId, currentTime);
        boolean isLongCharge = chargeTime >= 40;
        double radius = isLongCharge ? 4.0 : 2.5;
        float baseDamage = isLongCharge ? 12.0f : 8.0f;
        class_238 attackBox = class_238.method_30048((class_243)player.method_19538(), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0));
        List targets = world.method_8390(class_1309.class, attackBox, entity -> entity != player && entity.method_5805());
        for (class_1309 target : targets) {
            double knockbackStrength;
            if (isLongCharge) {
                float finalDamage = this.calculateEnchantedDamage(hammerStack, target, baseDamage, (class_1937)world);
                class_1282 damageSource = this.createEnchantedDamageSource(world, player, hammerStack);
                target.method_5643(damageSource, finalDamage);
                this.applyEnchantmentEffects(hammerStack, target, world);
            }
            class_243 knockbackDirection = target.method_19538().method_1020(player.method_19538()).method_1029();
            double d = knockbackStrength = isLongCharge ? 1.5 : 1.0;
            if (!(knockbackDirection.method_1027() > 0.0)) continue;
            target.method_5762(knockbackDirection.field_1352 * knockbackStrength, 0.3, knockbackDirection.field_1350 * knockbackStrength);
            target.field_6037 = true;
        }
        if (isLongCharge) {
            world.method_14199((class_2394)class_2398.field_11236, player.method_23317(), player.method_23318(), player.method_23321(), 8, radius / 2.0, 0.5, radius / 2.0, 0.1);
            world.method_60511(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 1.0f, 0.8f);
        } else {
            world.method_14199((class_2394)class_2398.field_11203, player.method_23317(), player.method_23318(), player.method_23321(), 15, radius / 2.0, 0.2, radius / 2.0, 0.2);
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14840, class_3419.field_15248, 1.0f, 0.7f);
        }
    }

    private class_1282 createEnchantedDamageSource(class_3218 world, class_1657 player, class_1799 weapon) {
        class_1282 damageSource = world.method_48963().method_48802(player);
        return damageSource;
    }

    private float calculateEnchantedDamage(class_1799 stack, class_1309 target, float baseDamage, class_1937 world) {
        int baneLevel;
        Optional baneEntry;
        int smiteLevel;
        Optional smiteEntry;
        int sharpnessLevel;
        float damage = baseDamage;
        class_9304 enchantments = stack.method_58657();
        class_2378 enchantmentRegistry = world.method_30349().method_30530(class_7924.field_41265);
        Optional sharpnessEntry = enchantmentRegistry.method_40264(class_1893.field_9118);
        if (sharpnessEntry.isPresent() && (sharpnessLevel = enchantments.method_57536((class_6880)sharpnessEntry.get())) > 0) {
            damage += (float)sharpnessLevel * 1.5f;
        }
        if ((smiteEntry = enchantmentRegistry.method_40264(class_1893.field_9123)).isPresent() && (smiteLevel = enchantments.method_57536((class_6880)smiteEntry.get())) > 0 && target.method_5864().method_20210(class_3483.field_46232)) {
            damage += (float)smiteLevel * 2.5f;
        }
        if ((baneEntry = enchantmentRegistry.method_40264(class_1893.field_9112)).isPresent() && (baneLevel = enchantments.method_57536((class_6880)baneEntry.get())) > 0 && target.method_5864().method_20210(class_3483.field_48289)) {
            damage += (float)baneLevel * 2.5f;
            target.method_6092(new class_1293(class_1294.field_5909, 20 + baneLevel * 10, baneLevel - 1));
        }
        return damage;
    }

    private void applyEnchantmentEffects(class_1799 stack, class_1309 target, class_3218 world) {
        int lootingLevel;
        Optional lootingEntry;
        int fireAspectLevel;
        class_9304 enchantments = stack.method_58657();
        class_2378 enchantmentRegistry = world.method_30349().method_30530(class_7924.field_41265);
        Optional fireAspectEntry = enchantmentRegistry.method_40264(class_1893.field_9124);
        if (fireAspectEntry.isPresent() && (fireAspectLevel = enchantments.method_57536((class_6880)fireAspectEntry.get())) > 0) {
            target.method_5639((float)(fireAspectLevel * 4));
            world.method_14199((class_2394)class_2398.field_11240, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 5, 0.3, 0.5, 0.3, 0.1);
        }
        if ((lootingEntry = enchantmentRegistry.method_40264(class_1893.field_9110)).isPresent() && (lootingLevel = enchantments.method_57536((class_6880)lootingEntry.get())) > 0) {
            world.method_14199((class_2394)class_2398.field_11215, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), lootingLevel * 2, 0.2, 0.5, 0.2, 0.1);
        }
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (miner instanceof class_1657) {
            class_1657 player = (class_1657)miner;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                this.performAreaMining(player, serverWorld, pos, stack);
            }
        }
        return super.method_7879(stack, world, state, pos, miner);
    }

    private void performAreaMining(class_1657 player, class_3218 world, class_2338 center, class_1799 stack) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 targetPos;
                    class_2680 targetState;
                    if (x == 0 && y == 0 && z == 0 || !this.method_7885(targetState = world.method_8320(targetPos = center.method_10069(x, y, z)), (class_1937)world, targetPos, player) || !targetState.method_26164(class_3481.field_33715)) continue;
                    this.mineBlockWithEnchantments(world, targetPos, targetState, player, stack);
                    if (!stack.method_7963()) continue;
                    stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)player.method_6058()));
                }
            }
        }
    }

    private void mineBlockWithEnchantments(class_3218 world, class_2338 pos, class_2680 state, class_1657 player, class_1799 tool) {
        Optional fortuneEntry;
        class_9304 enchantments = tool.method_58657();
        class_2378 enchantmentRegistry = world.method_30349().method_30530(class_7924.field_41265);
        boolean hasSilkTouch = false;
        int fortuneLevel = 0;
        Optional silkTouchEntry = enchantmentRegistry.method_40264(class_1893.field_9099);
        if (silkTouchEntry.isPresent()) {
            boolean bl = hasSilkTouch = enchantments.method_57536((class_6880)silkTouchEntry.get()) > 0;
        }
        if ((fortuneEntry = enchantmentRegistry.method_40264(class_1893.field_9130)).isPresent()) {
            fortuneLevel = enchantments.method_57536((class_6880)fortuneEntry.get());
        }
        world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        if (hasSilkTouch) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)state.method_26204()));
        } else {
            List<class_1799> drops = class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, (class_2586)world.method_8321(pos), (class_1297)player, (class_1799)tool);
            if (fortuneLevel > 0) {
                drops = this.applyFortuneToDrops(drops, fortuneLevel, world.method_8409());
            }
            for (class_1799 drop : drops) {
                class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)drop);
            }
        }
        world.method_8396(null, pos, state.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
        world.method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.3, 0.3, 0.3, 0.1);
    }

    private List<class_1799> applyFortuneToDrops(List<class_1799> drops, int fortuneLevel, class_5819 random) {
        ArrayList<class_1799> fortuneDrops = new ArrayList<class_1799>();
        for (class_1799 drop : drops) {
            class_1799 fortuneDrop = drop.method_7972();
            if (this.isFortuneApplicable(drop)) {
                int multiplier = 1;
                for (int i = 0; i < fortuneLevel; ++i) {
                    if (!(random.method_43057() < 0.33f)) continue;
                    ++multiplier;
                }
                fortuneDrop.method_7939(drop.method_7947() * multiplier);
            }
            fortuneDrops.add(fortuneDrop);
        }
        return fortuneDrops;
    }

    private boolean isFortuneApplicable(class_1799 drop) {
        return drop.method_31574(class_1802.field_8713) || drop.method_31574(class_1802.field_8477) || drop.method_31574(class_1802.field_8687) || drop.method_31574(class_1802.field_8759) || drop.method_31574(class_1802.field_8725) || drop.method_31574(class_1802.field_8155) || drop.method_31574(class_1802.field_8601) || drop.method_31574(class_1802.field_27022) || drop.method_31574(class_1802.field_33401) || drop.method_31574(class_1802.field_33400) || drop.method_31574(class_1802.field_33402);
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        if (state.method_26164(class_3481.field_33715)) {
            return this.method_8022().method_8027();
        }
        return 1.0f;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return this.method_8022().method_8023().method_8093(ingredient) || super.method_7878(stack, ingredient);
    }
}

