/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.data.ClientPlayerDataCache;
import github.jorgaomc.data.PlayerAppData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record AppDataSyncPacket(String csv) implements class_8710
{
    public static final class_8710.class_9154<AppDataSyncPacket> ID = new class_8710.class_9154(class_2960.method_60655((String)"legendarymonuments", (String)"app_data_sync"));
    public static final class_9139<class_9129, AppDataSyncPacket> CODEC = new class_9139<class_9129, AppDataSyncPacket>(){

        public AppDataSyncPacket decode(class_9129 buf) {
            String csv = buf.method_19772();
            return new AppDataSyncPacket(csv);
        }

        public void encode(class_9129 buf, AppDataSyncPacket value) {
            buf.method_10814(value.csv);
        }
    };

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void registerPayload() {
        PayloadTypeRegistry.playS2C().register(ID, CODEC);
    }

    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            class_310 client = context.client();
            Set<String> apps = payload.parse();
            client.execute(() -> {
                PlayerAppData appData = ClientPlayerDataCache.getAppData();
                AppDataSyncPacket.appDataReplaceUnlocked(appData, apps);
                LegendaryMonuments.LOGGER.debug("Client received app data sync: {} apps", (Object)apps.size());
            });
        });
    }

    public Set<String> parse() {
        if (this.csv == null || this.csv.isEmpty()) {
            return new HashSet<String>();
        }
        return Arrays.stream(this.csv.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    private static void appDataReplaceUnlocked(PlayerAppData appData, Set<String> unlocked) {
        block3: {
            try {
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null) break block3;
                appData.readFromStorage((class_1657)client.field_1724);
                for (String app : unlocked) {
                    if (appData.isAppUnlocked(app)) continue;
                }
            }
            catch (Throwable t) {
                LegendaryMonuments.LOGGER.error("Failed to replace client app data", t);
            }
        }
    }

    public static void sendTo(class_3222 player, Set<String> unlocked) {
        String csv = String.join((CharSequence)",", unlocked);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new AppDataSyncPacket(csv));
    }
}

