/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.screen;

import github.jorgaomc.blocks.SanctuaryBlock;
import github.jorgaomc.network.SanctuaryUpdateC2SPacket;
import github.jorgaomc.screen.SanctuaryScreenHandler;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class SanctuaryScreen
extends class_465<SanctuaryScreenHandler> {
    private final class_2338 sanctuaryPos;
    private boolean active;
    private boolean explosionProtection;
    private boolean blockPlacement;
    private boolean blockBreaking;
    private boolean mobSpawning;
    private int horizontalRadius;
    private int verticalRadius;
    private class_4185 activeButton;
    private class_4185 explosionButton;
    private class_4185 placementButton;
    private class_4185 breakingButton;
    private class_4185 spawningButton;
    private class_357 horizontalSlider;
    private class_357 verticalSlider;

    public SanctuaryScreen(SanctuaryScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.sanctuaryPos = handler.getSanctuaryPos();
        this.field_2792 = 256;
        this.field_2779 = 220;
        System.out.println("Opening sanctuary UI for pos: " + String.valueOf(this.sanctuaryPos));
        SanctuaryBlock.SanctuaryData data = SanctuaryBlock.getSanctuaryData(this.sanctuaryPos);
        if (data != null) {
            this.active = data.active;
            this.explosionProtection = data.explosionProtection;
            this.blockPlacement = data.blockPlacement;
            this.blockBreaking = data.blockBreaking;
            this.mobSpawning = data.mobSpawning;
            this.horizontalRadius = data.horizontalRadius;
            this.verticalRadius = data.verticalRadius;
            System.out.println("Loaded data - Active: " + this.active + " - Explosion: " + this.explosionProtection);
        } else {
            this.active = true;
            this.explosionProtection = true;
            this.blockPlacement = true;
            this.blockBreaking = true;
            this.mobSpawning = true;
            this.horizontalRadius = 50;
            this.verticalRadius = 50;
            System.out.println("Using default data");
        }
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_2776 + this.field_2792 / 2;
        int startY = this.field_2800 + 30;
        this.activeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.active ? "Active" : "Inactive")).method_27692(this.active ? class_124.field_1060 : class_124.field_1061), button -> {
            this.active = !this.active;
            this.updateActiveButton();
            this.sendUpdate();
        }).method_46434(centerX - 50, startY, 100, 20).method_46431();
        this.method_37063((class_364)this.activeButton);
        this.explosionButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Explosions: " + (this.explosionProtection ? "Blocked" : "Allowed"))).method_27692(this.explosionProtection ? class_124.field_1061 : class_124.field_1060), button -> {
            this.explosionProtection = !this.explosionProtection;
            this.updateExplosionButton();
            this.sendUpdate();
        }).method_46434(centerX - 60, startY + 25, 120, 20).method_46431();
        this.method_37063((class_364)this.explosionButton);
        this.placementButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Placement: " + (this.blockPlacement ? "Blocked" : "Allowed"))).method_27692(this.blockPlacement ? class_124.field_1061 : class_124.field_1060), button -> {
            this.blockPlacement = !this.blockPlacement;
            this.updatePlacementButton();
            this.sendUpdate();
        }).method_46434(centerX - 60, startY + 50, 120, 20).method_46431();
        this.method_37063((class_364)this.placementButton);
        this.breakingButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Breaking: " + (this.blockBreaking ? "Blocked" : "Allowed"))).method_27692(this.blockBreaking ? class_124.field_1061 : class_124.field_1060), button -> {
            this.blockBreaking = !this.blockBreaking;
            this.updateBreakingButton();
            this.sendUpdate();
        }).method_46434(centerX - 60, startY + 75, 120, 20).method_46431();
        this.method_37063((class_364)this.breakingButton);
        this.spawningButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Mob Spawning: " + (this.mobSpawning ? "Blocked" : "Allowed"))).method_27692(this.mobSpawning ? class_124.field_1061 : class_124.field_1060), button -> {
            this.mobSpawning = !this.mobSpawning;
            this.updateSpawningButton();
            this.sendUpdate();
        }).method_46434(centerX - 65, startY + 100, 130, 20).method_46431();
        this.method_37063((class_364)this.spawningButton);
        this.horizontalSlider = new class_357(centerX - 60, startY + 125, 120, 20, (class_2561)class_2561.method_43470((String)("H-Radius: " + this.horizontalRadius)), (double)this.horizontalRadius / 100.0){

            protected void method_25346() {
                SanctuaryScreen.this.horizontalRadius = (int)(this.field_22753 * 100.0) + 1;
                this.method_25355((class_2561)class_2561.method_43470((String)("H-Radius: " + SanctuaryScreen.this.horizontalRadius)));
            }

            protected void method_25344() {
                SanctuaryScreen.this.sendUpdate();
            }
        };
        this.method_37063((class_364)this.horizontalSlider);
        this.verticalSlider = new class_357(centerX - 60, startY + 150, 120, 20, (class_2561)class_2561.method_43470((String)("V-Radius: " + this.verticalRadius)), (double)this.verticalRadius / 100.0){

            protected void method_25346() {
                SanctuaryScreen.this.verticalRadius = (int)(this.field_22753 * 100.0) + 1;
                this.method_25355((class_2561)class_2561.method_43470((String)("V-Radius: " + SanctuaryScreen.this.verticalRadius)));
            }

            protected void method_25344() {
                SanctuaryScreen.this.sendUpdate();
            }
        };
        this.method_37063((class_364)this.verticalSlider);
    }

    private void updateActiveButton() {
        this.activeButton.method_25355((class_2561)class_2561.method_43470((String)(this.active ? "Active" : "Inactive")).method_27692(this.active ? class_124.field_1060 : class_124.field_1061));
    }

    private void updateExplosionButton() {
        this.explosionButton.method_25355((class_2561)class_2561.method_43470((String)("Explosions: " + (this.explosionProtection ? "Blocked" : "Allowed"))).method_27692(this.explosionProtection ? class_124.field_1061 : class_124.field_1060));
    }

    private void updatePlacementButton() {
        this.placementButton.method_25355((class_2561)class_2561.method_43470((String)("Placement: " + (this.blockPlacement ? "Blocked" : "Allowed"))).method_27692(this.blockPlacement ? class_124.field_1061 : class_124.field_1060));
    }

    private void updateBreakingButton() {
        this.breakingButton.method_25355((class_2561)class_2561.method_43470((String)("Breaking: " + (this.blockBreaking ? "Blocked" : "Allowed"))).method_27692(this.blockBreaking ? class_124.field_1061 : class_124.field_1060));
    }

    private void updateSpawningButton() {
        this.spawningButton.method_25355((class_2561)class_2561.method_43470((String)("Mob Spawning: " + (this.mobSpawning ? "Blocked" : "Allowed"))).method_27692(this.mobSpawning ? class_124.field_1061 : class_124.field_1060));
    }

    private void sendUpdate() {
        System.out.println("Sending update - Active: " + this.active + " - Explosion: " + this.explosionProtection);
        SanctuaryUpdateC2SPacket.send(this.sanctuaryPos, this.active, this.explosionProtection, this.blockPlacement, this.blockBreaking, this.mobSpawning, this.horizontalRadius, this.verticalRadius);
        SanctuaryBlock.SanctuaryData data = SanctuaryBlock.getSanctuaryData(this.sanctuaryPos);
        if (data != null) {
            data.active = this.active;
            data.explosionProtection = this.explosionProtection;
            data.blockPlacement = this.blockPlacement;
            data.blockBreaking = this.blockBreaking;
            data.mobSpawning = this.mobSpawning;
            data.horizontalRadius = this.horizontalRadius;
            data.verticalRadius = this.verticalRadius;
            System.out.println("Updated local data - Active: " + data.active + " - Explosion: " + data.explosionProtection);
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25294(this.field_2776, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -2013265920);
        context.method_49601(this.field_2776, this.field_2800, this.field_2792, this.field_2779, -1);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        class_5250 title = class_2561.method_43470((String)"Sanctuary Configuration").method_27692(class_124.field_1067);
        int titleWidth = this.field_22793.method_27525((class_5348)title);
        context.method_51439(this.field_22793, (class_2561)title, this.field_2776 + (this.field_2792 - titleWidth) / 2, this.field_2800 + 10, 0xFFFFFF, false);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }
}

