/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.dimension;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_5425;

public class HallOfOriginTeleporter {
    private static final class_2338 SPAWN_POS = new class_2338(13, 6, 74);
    private static final class_2338 STRUCTURE_POS = new class_2338(1, 5, 1);

    public static boolean teleportToHallOfOrigin(class_3222 player) {
        class_3218 serverWorld = player.method_5682().method_3847(HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY);
        if (serverWorld == null) {
            LegendaryMonuments.LOGGER.error("Failed to find Hall of Origin dimension");
            return false;
        }
        player.method_14251(serverWorld, (double)SPAWN_POS.method_10263() + 0.5, (double)SPAWN_POS.method_10264(), (double)SPAWN_POS.method_10260() + 0.5, player.method_36454(), player.method_36455());
        HallOfOriginTeleporter.ensureStructurePlaced(serverWorld);
        player.method_7353((class_2561)class_2561.method_43471((String)"message.legendarymonuments.enter_hall_of_origin"), true);
        return true;
    }

    public static boolean teleportFromHallOfOrigin(class_3222 player) {
        class_3218 overworld = player.method_5682().method_30002();
        class_2338 spawnPos = player.method_26280();
        if (spawnPos == null) {
            spawnPos = overworld.method_43126();
        }
        double x = (double)spawnPos.method_10263() + 0.5;
        double y = Math.max(1, spawnPos.method_10264());
        double z = (double)spawnPos.method_10260() + 0.5;
        player.method_14251(overworld, x, y, z, player.method_36454(), player.method_36455());
        player.method_7353((class_2561)class_2561.method_43471((String)"message.legendarymonuments.exit_hall_of_origin"), true);
        return true;
    }

    public static void handleVoidFall(class_3222 player) {
        if (player.method_37908().method_27983() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY && player.method_23318() < 0.0) {
            class_3218 currentWorld = (class_3218)player.method_37908();
            player.method_14251(currentWorld, (double)SPAWN_POS.method_10263() + 0.5, (double)SPAWN_POS.method_10264(), (double)SPAWN_POS.method_10260() + 0.5, player.method_36454(), player.method_36455());
            player.method_18800(0.0, 0.0, 0.0);
            player.field_6037 = true;
            player.method_7353((class_2561)class_2561.method_43471((String)"message.legendarymonuments.hall_origin_void_return"), true);
        }
    }

    private static void ensureStructurePlaced(class_3218 world) {
        int cx = STRUCTURE_POS.method_10263() >> 4;
        int cz = STRUCTURE_POS.method_10260() >> 4;
        world.method_8497(cx, cz);
        try {
            world.method_17988(cx, cz, true);
        }
        catch (Throwable t) {
            LegendaryMonuments.LOGGER.debug("setChunkForced not available or failed: {}", (Object)t.toString());
        }
        if (world.method_22347(STRUCTURE_POS)) {
            HallOfOriginTeleporter.placeStructureTemplate(world, "hall_of_origin", STRUCTURE_POS);
            LegendaryMonuments.LOGGER.info("Attempted Hall of Origin structure placement at {}", (Object)STRUCTURE_POS);
        }
    }

    private static void placeStructureTemplate(class_3218 world, String templateName, class_2338 pos) {
        class_2960 templateId = class_2960.method_60655((String)"legendarymonuments", (String)templateName);
        class_3485 structureManager = world.method_8503().method_27727();
        structureManager.method_15094(templateId).ifPresentOrElse(template -> {
            class_3492 placementSettings = new class_3492().method_15125(class_2415.field_11302).method_15123(class_2470.field_11467).method_15133(false);
            template.method_15172((class_5425)world, pos, pos, placementSettings, world.method_8409(), 2);
            LegendaryMonuments.LOGGER.info("Successfully placed structure template {} at {}", (Object)templateId, (Object)pos);
        }, () -> LegendaryMonuments.LOGGER.error("Structure template {} not found", (Object)templateId));
    }
}

