/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.jorgaomc.LegendaryMonuments;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_7923;

public class NetherOpenAreaProcessor
extends class_3491 {
    public static final MapCodec<NetherOpenAreaProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)32).fieldOf("horizontal_radius").forGetter(processor -> processor.horizontalRadius), (App)Codec.intRange((int)1, (int)16).fieldOf("vertical_radius").forGetter(processor -> processor.verticalRadius), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("min_open_percentage").forGetter(processor -> processor.minOpenPercentage)).apply((Applicative)instance, NetherOpenAreaProcessor::new));
    public static final class_3828<NetherOpenAreaProcessor> TYPE = () -> CODEC;
    private final int horizontalRadius;
    private final int verticalRadius;
    private final double minOpenPercentage;
    private boolean hasValidated = false;
    private boolean isValidLocation = true;

    public NetherOpenAreaProcessor(int horizontalRadius, int verticalRadius, double minOpenPercentage) {
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.minOpenPercentage = minOpenPercentage;
    }

    public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 pivot, class_3499.class_3501 originalBlockInfo, class_3499.class_3501 currentBlockInfo, class_3492 data) {
        if (!this.hasValidated) {
            this.hasValidated = true;
            this.isValidLocation = this.isValidNetherOpenArea(world, pivot);
            LegendaryMonuments.LOGGER.info("Shrine placement validation at {}: {}", (Object)pivot, (Object)(this.isValidLocation ? "PASSED" : "FAILED"));
        }
        return currentBlockInfo;
    }

    private boolean isValidNetherOpenArea(class_4538 world, class_2338 centerPos) {
        int openBlockCount = 0;
        int totalCheckedBlocks = 0;
        int lavaBlocksNearby = 0;
        int solidBlocksImmediate = 0;
        for (int x = -this.horizontalRadius; x <= this.horizontalRadius; ++x) {
            for (int z = -this.horizontalRadius; z <= this.horizontalRadius; ++z) {
                for (int y = -this.verticalRadius; y <= this.verticalRadius; ++y) {
                    class_2338 checkPos = centerPos.method_10069(x, y, z);
                    class_2680 state = world.method_8320(checkPos);
                    ++totalCheckedBlocks;
                    if (state.method_26215() || state.method_27852(class_2246.field_10543) || !state.method_51366() || state.method_27852(class_2246.field_10036) || state.method_27852(class_2246.field_22089)) {
                        ++openBlockCount;
                    }
                    if (state.method_27852(class_2246.field_10164) && Math.abs(x) <= 2 && Math.abs(z) <= 2 && Math.abs(y) <= 1) {
                        ++lavaBlocksNearby;
                    }
                    if (!state.method_27852(class_2246.field_10515) && !state.method_27852(class_2246.field_23869) && !state.method_27852(class_2246.field_22091) && !state.method_27852(class_2246.field_10114) && !state.method_27852(class_2246.field_22090) || Math.abs(x) > 1 || Math.abs(z) > 1 || Math.abs(y) > 1) continue;
                    ++solidBlocksImmediate;
                }
            }
        }
        double openPercentage = (double)openBlockCount / (double)totalCheckedBlocks;
        boolean hasEnoughOpenSpace = openPercentage >= this.minOpenPercentage * 0.5;
        boolean notTooMuchLava = lavaBlocksNearby < 10;
        boolean notTooSolid = solidBlocksImmediate < 15;
        boolean result = hasEnoughOpenSpace && notTooMuchLava && notTooSolid;
        LegendaryMonuments.LOGGER.info("Shrine validation details at {}: open={}% ({}/{}), lava={}, solid={}, result={}", new Object[]{centerPos, String.format("%.1f", openPercentage * 100.0), openBlockCount, totalCheckedBlocks, lavaBlocksNearby, solidBlocksImmediate, result});
        return result;
    }

    protected class_3828<?> method_16772() {
        return TYPE;
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41161, (class_2960)class_2960.method_60655((String)"legendarymonuments", (String)"nether_open_area"), TYPE);
    }
}

