/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6797;
import net.minecraft.class_6798;
import net.minecraft.class_7923;

public class NetherOpenAreaPlacementModifier
extends class_6797 {
    public static final MapCodec<NetherOpenAreaPlacementModifier> MODIFIER_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)32).fieldOf("horizontal_radius").forGetter(modifier -> modifier.horizontalRadius), (App)Codec.intRange((int)1, (int)16).fieldOf("vertical_radius").forGetter(modifier -> modifier.verticalRadius), (App)Codec.intRange((int)1, (int)10).fieldOf("min_open_blocks").forGetter(modifier -> modifier.minOpenBlocks)).apply((Applicative)instance, NetherOpenAreaPlacementModifier::new));
    public static final class_6798<NetherOpenAreaPlacementModifier> TYPE = () -> MODIFIER_CODEC;
    private final int horizontalRadius;
    private final int verticalRadius;
    private final int minOpenBlocks;

    public NetherOpenAreaPlacementModifier(int horizontalRadius, int verticalRadius, int minOpenBlocks) {
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.minOpenBlocks = minOpenBlocks;
    }

    public Stream<class_2338> method_14452(class_5444 context, class_5819 random, class_2338 pos) {
        class_5281 world = context.method_34383();
        if (!this.isValidNetherOpenArea((class_4538)world, pos)) {
            return Stream.empty();
        }
        return Stream.of(pos);
    }

    private boolean isValidNetherOpenArea(class_4538 world, class_2338 pos) {
        int openBlockCount = 0;
        int totalCheckedBlocks = 0;
        for (int x = -this.horizontalRadius; x <= this.horizontalRadius; ++x) {
            for (int z = -this.horizontalRadius; z <= this.horizontalRadius; ++z) {
                for (int y = -this.verticalRadius; y <= this.verticalRadius; ++y) {
                    class_2338 above;
                    class_2338 checkPos = pos.method_10069(x, y, z);
                    class_2680 state = world.method_8320(checkPos);
                    ++totalCheckedBlocks;
                    if (state.method_26215() || state.method_27852(class_2246.field_10543) || !state.method_51366() || state.method_27852(class_2246.field_10036) || state.method_27852(class_2246.field_22089)) {
                        ++openBlockCount;
                    }
                    if (state.method_27852(class_2246.field_10164) && pos.method_10262((class_2382)(above = checkPos.method_10084())) < 4.0) {
                        return false;
                    }
                    if (!state.method_27852(class_2246.field_10515) && !state.method_27852(class_2246.field_23869) && !state.method_27852(class_2246.field_22091) && !state.method_27852(class_2246.field_10114) && !state.method_27852(class_2246.field_22090) || Math.abs(x) > 2 || Math.abs(z) > 2 || Math.abs(y) > 1) continue;
                    return false;
                }
            }
        }
        double openPercentage = (double)openBlockCount / (double)totalCheckedBlocks;
        return openPercentage >= 0.6 && openBlockCount >= this.minOpenBlocks;
    }

    public class_6798<?> method_39615() {
        return TYPE;
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41148, (class_2960)class_2960.method_60655((String)"legendarymonuments", (String)"nether_open_area"), TYPE);
    }
}

