/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.client.gui.screen.ingame;

import dev.mariany.arcanehand.ArcaneHand;
import dev.mariany.arcanehand.client.gui.tooltip.EnchantmentProgressionTooltipComponent;
import dev.mariany.arcanehand.component.type.EnchantmentProgressionComponent;
import dev.mariany.arcanehand.enchantment.EnchantmentProgression;
import dev.mariany.arcanehand.screen.ArcaneConsoleScreenHandler;
import dev.mariany.arcanehand.util.AHHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7924;
import net.minecraft.class_8001;

@Environment(value=EnvType.CLIENT)
public class ArcaneConsoleScreen
extends class_465<ArcaneConsoleScreenHandler> {
    private static final class_2960 BACKGROUND = ArcaneHand.id("textures/gui/container/arcane_console.png");
    private static final class_2960 ENABLED = ArcaneHand.id("container/arcane_console/enabled");
    private static final class_2960 OPTION = ArcaneHand.id("container/arcane_console/option");
    private static final class_2960 OPTION_HIGHLIGHTED = ArcaneHand.id("container/arcane_console/option_highlighted");
    private static final class_2960 OPTION_DISABLED = ArcaneHand.id("container/arcane_console/option_disabled");
    private static final class_2960 SCROLLER = ArcaneHand.id("container/arcane_console/scroller");
    private static final class_2960 SCROLLER_DISABLED = ArcaneHand.id("container/arcane_console/scroller_disabled");
    private static final String ELLIPSIS = "...";
    private static final int TEXT_COLOR = -9937334;
    private static final int TEXT_COLOR_HIGHLIGHTED = -128;
    private static final int TEXT_COLOR_DISABLED = -8227748;
    private static final int MAX_DISPLAYED_ENCHANTMENTS = 4;
    private static final int OPTION_WIDTH = 107;
    private static final int OPTION_HEIGHT = 18;
    private static final int ICON_WIDTH = 18;
    private static final int ICON_HEIGHT = 18;
    private static final int TEXT_RIGHT_PADDING = 4;
    private static final int TEXT_LEFT_PADDING = 2;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int SCROLLER_TRACK_HEIGHT = 72;
    private static final int SCROLLER_TOP_LEFT_X = 156;
    private static final int SCROLLER_TOP_LEFT_Y = 19;
    private static final int OPTIONS_TOP_LEFT_X = 46;
    private static final int OPTIONS_TOP_LEFT_Y = 19;
    private boolean mouseClicked;
    private float scrollAmount;
    private int scrollOffset;

    public ArcaneConsoleScreen(ArcaneConsoleScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        this.field_2779 = 190;
        this.field_25270 += 24;
    }

    private void onInventoryChange() {
        if (!this.shouldScroll()) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }

    public int getOptionsX() {
        return this.field_2776 + 46;
    }

    public int getOptionsY() {
        return this.field_2800 + 19;
    }

    public int getEndIndexExclusive() {
        return this.scrollOffset + 4;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        this.method_2380(context, mouseX, mouseY);
        this.drawEnchantmentTooltip(context, mouseX, mouseY);
    }

    private void drawEnchantmentTooltip(class_332 context, int mouseX, int mouseY) {
        if (this.field_22787 != null && this.field_22787.field_1687 != null) {
            this.field_22787.field_1687.method_30349().method_46759(class_7924.field_41265).ifPresent(enchantmentRegistry -> {
                List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> enchantments = ((ArcaneConsoleScreenHandler)this.field_2797).getSortedAvailableEnchantments();
                int start = this.scrollOffset;
                int end = Math.min(this.getEndIndexExclusive(), enchantments.size());
                for (int i = start; i < end; ++i) {
                    int row = i - start;
                    int placedY = this.getOptionsY() + row * 18;
                    if (!this.isOptionHighlighted(mouseX, mouseY, this.getOptionsX(), placedY)) continue;
                    EnchantmentProgression progress = enchantments.get(i).getValue();
                    boolean drawn = enchantmentRegistry.method_46746(enchantments.get(i).getKey()).map(enchantment -> {
                        context.method_51435(this.field_22793, ArcaneConsoleScreen.getEnchantmentTooltip(this.field_22793, (class_6880<class_1887>)enchantment, progress), mouseX, mouseY, class_8001.field_41687, null);
                        return true;
                    }).orElse(false);
                    if (drawn) break;
                }
            });
        }
    }

    private static List<class_5684> getEnchantmentTooltip(class_327 textRenderer, class_6880<class_1887> enchantment, EnchantmentProgression progress) {
        ArrayList<class_5684> tooltip = new ArrayList<class_5684>();
        class_5684 enchantmentName = class_5684.method_32662((class_5481)EnchantmentProgression.getEnchantmentText(enchantment, progress).method_30937());
        tooltip.add(enchantmentName);
        enchantment.method_40230().ifPresent(enchantmentKey -> {
            EnchantmentProgressionTooltipComponent progressTooltip = ArcaneConsoleScreen.getEnchantmentProgressionTooltipComponent((class_5321<class_1887>)enchantmentKey, progress);
            List<class_5684> enchantmentDescription = ArcaneConsoleScreen.getEnchantmentDescription(textRenderer, (class_1887)enchantment.comp_349(), progressTooltip.method_32664(textRenderer)).stream().map(class_5481::method_34906).map(class_5684::method_32662).toList();
            tooltip.addAll(enchantmentDescription);
            tooltip.add(ArcaneConsoleScreen.getEnchantmentProgressionTooltipComponent((class_5321<class_1887>)enchantmentKey, progress));
        });
        return tooltip;
    }

    private static List<class_5481> getEnchantmentDescription(class_327 textRenderer, class_1887 enchantment, int width) {
        class_5250 description = ArcaneConsoleScreen.getEnchantmentDescription(enchantment).method_27661().method_27692(class_124.field_1063);
        return textRenderer.method_1728((class_5348)description, width);
    }

    private static class_2561 getEnchantmentDescription(class_1887 enchantment) {
        class_7417 class_74172 = enchantment.comp_2686().method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableTextContent = (class_2588)class_74172;
            String enchantmentKey = translatableTextContent.method_11022();
            String abbreviatedDescriptionKey = enchantmentKey + ".desc";
            String descriptionKey = enchantmentKey + ".description";
            if (!class_1074.method_4663((String)descriptionKey) && class_1074.method_4663((String)abbreviatedDescriptionKey)) {
                descriptionKey = abbreviatedDescriptionKey;
            }
            return class_2561.method_48321((String)descriptionKey, (String)"");
        }
        return class_2561.method_43473();
    }

    private static EnchantmentProgressionTooltipComponent getEnchantmentProgressionTooltipComponent(class_5321<class_1887> enchantmentKey, EnchantmentProgression progress) {
        EnchantmentProgressionComponent singularProgression = new EnchantmentProgressionComponent(Map.of(enchantmentKey, progress), 0);
        return new EnchantmentProgressionTooltipComponent(singularProgression, false, -1);
    }

    protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
        int centerX = (this.field_22789 - this.field_2792) / 2;
        int centerY = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(class_10799.field_56883, BACKGROUND, centerX, centerY, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        this.renderScroller(context, this.field_2776 + 156, this.field_2800 + 19);
        this.renderOptions(context, mouseX, mouseY);
    }

    private void renderScroller(class_332 context, int x, int y) {
        int offset = Math.round(this.scrollAmount * 57.0f);
        context.method_52706(class_10799.field_56883, this.shouldScroll() ? SCROLLER : SCROLLER_DISABLED, x, y + offset, 12, 15);
    }

    private void renderOptions(class_332 context, int mouseX, int mouseY) {
        List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> availableEnchantments = ((ArcaneConsoleScreenHandler)this.field_2797).getSortedAvailableEnchantments();
        this.renderOptionsBackground(context, availableEnchantments, mouseX, mouseY);
        this.renderOptionsIcon(context, availableEnchantments);
        this.renderOptionsText(context, availableEnchantments, mouseX, mouseY);
    }

    private void renderOptionsBackground(class_332 context, List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> availableEnchantments, int mouseX, int mouseY) {
        int x = this.getOptionsX();
        int start = this.scrollOffset;
        int end = Math.min(this.getEndIndexExclusive(), availableEnchantments.size());
        for (int i = start; i < end; ++i) {
            int row = i - start;
            int placedY = this.getOptionsY() + row * 18;
            class_2960 texture = OPTION_DISABLED;
            if (((ArcaneConsoleScreenHandler)this.field_2797).isCompatible(availableEnchantments.get(i).getKey())) {
                texture = this.isOptionHighlighted(mouseX, mouseY, x, placedY) ? OPTION_HIGHLIGHTED : OPTION;
            }
            context.method_52706(class_10799.field_56883, texture, x, placedY, 107, 18);
        }
    }

    private void renderOptionsIcon(class_332 context, List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> availableEnchantments) {
        int start = this.scrollOffset;
        int end = Math.min(this.getEndIndexExclusive(), availableEnchantments.size());
        for (int i = start; i < end; ++i) {
            int row = i - start;
            int placedY = this.getOptionsY() + row * 18;
            if (!((ArcaneConsoleScreenHandler)this.field_2797).isCompatible(availableEnchantments.get(i).getKey()) || !availableEnchantments.get(i).getValue().isEnabled()) continue;
            context.method_52706(class_10799.field_56883, ENABLED, this.getOptionsX(), placedY, 18, 18);
        }
    }

    private void renderOptionsText(class_332 context, List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> availableEnchantments, int mouseX, int mouseY) {
        if (this.field_22787 != null && this.field_22787.field_1687 != null) {
            this.field_22787.field_1687.method_30349().method_46759(class_7924.field_41265).ifPresent(enchantmentRegistry -> {
                int start = this.scrollOffset;
                int end = Math.min(this.getEndIndexExclusive(), availableEnchantments.size());
                for (int i = start; i < end; ++i) {
                    int row = i - start;
                    int optionX = this.getOptionsX();
                    int optionY = this.getOptionsY() + row * 18;
                    int textX = optionX + 18 + 2;
                    int textMaxWidth = Math.max(0, 83);
                    class_5321 enchantmentKey = (class_5321)((Map.Entry)availableEnchantments.get(i)).getKey();
                    enchantmentRegistry.method_46746(enchantmentKey).ifPresent(enchantment -> {
                        String raw = ((class_1887)enchantment.comp_349()).comp_2686().getString();
                        Object display = raw;
                        if (this.field_22793.method_1727(raw) > textMaxWidth) {
                            int allowed = textMaxWidth - this.field_22793.method_1727(ELLIPSIS);
                            display = allowed > 0 ? this.field_22793.method_27523(raw, allowed) + ELLIPSIS : ELLIPSIS;
                        }
                        Objects.requireNonNull(this.field_22793);
                        int fontHeight = 9;
                        int textY = optionY + (18 - fontHeight) / 2 + 1;
                        int color = -8227748;
                        if (((ArcaneConsoleScreenHandler)this.field_2797).isCompatible((class_5321<class_1887>)enchantmentKey)) {
                            color = this.isOptionHighlighted(mouseX, mouseY, optionX, optionY) ? -128 : -9937334;
                        }
                        context.method_51433(this.field_22793, (String)display, textX, textY, color, false);
                    });
                }
            });
        }
    }

    private boolean isOptionHighlighted(double mouseX, double mouseY, int optionX, int optionY) {
        return AHHelper.pointInRect(mouseX, mouseY, optionX, optionY, 107, 18);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int optionsX = this.field_2776 + 46;
        int optionsY = this.field_2800 + 19;
        int scrollerX = this.field_2776 + 156;
        int scrollerY = this.field_2800 + 19;
        this.mouseClicked = false;
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1761 != null) {
            int count = this.getAvailableEnchantmentsCount();
            int start = this.scrollOffset;
            int end = Math.min(start + 4, count);
            for (int i = start; i < end; ++i) {
                int row = i - start;
                int optionY = optionsY + row * 18;
                if (this.isOptionHighlighted(mouseX, mouseY, optionsX, optionY)) {
                    if (((ArcaneConsoleScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, i)) {
                        this.field_22787.field_1761.method_2900(((ArcaneConsoleScreenHandler)this.field_2797).field_7763, i);
                        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                    }
                    return true;
                }
                if (!AHHelper.pointInRect(mouseX, mouseY, scrollerX, scrollerY, 12, 72)) continue;
                this.mouseClicked = true;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int top = this.field_2800 + 15 - 1;
            float mouseOffsetFromCenter = (float)mouseY - (float)top - 7.5f;
            float scrollableHeight = 57.0f;
            this.scrollAmount = class_3532.method_15363((float)(mouseOffsetFromCenter / scrollableHeight), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)(this.scrollAmount * (float)this.getMaxScroll() + 0.5f);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount) && this.shouldScroll()) {
            int maxScroll = this.getMaxScroll();
            float scrollStep = (float)verticalAmount / (float)maxScroll;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - scrollStep), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)(this.scrollAmount * (float)this.getMaxScroll() + 0.5f);
        }
        return true;
    }

    private boolean shouldScroll() {
        return this.getAvailableEnchantmentsCount() > 4;
    }

    private int getMaxScroll() {
        return Math.max(0, this.getAvailableEnchantmentsCount() - 4);
    }

    private int getAvailableEnchantmentsCount() {
        return ((ArcaneConsoleScreenHandler)this.field_2797).getSortedAvailableEnchantments().size();
    }
}

