/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.client.gui.tooltip;

import dev.mariany.arcanehand.ArcaneHand;
import dev.mariany.arcanehand.component.type.EnchantmentProgressionComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import org.apache.commons.lang3.math.Fraction;

@Environment(value=EnvType.CLIENT)
public class EnchantmentProgressionTooltipComponent
implements class_5684 {
    private static final class_2960 ENCHANTMENT_PROGRESS_BAR_BORDER_TEXTURE = ArcaneHand.id("container/enchantment/enchantment_progressbar_border");
    private static final class_2960 ENCHANTMENT_PROGRESS_BAR_FILL_TEXTURE = ArcaneHand.id("container/enchantment/enchantment_progressbar_fill");
    protected final EnchantmentProgressionComponent enchantmentProgression;
    protected final boolean considerDisabled;
    protected final int offset;

    public EnchantmentProgressionTooltipComponent(EnchantmentProgressionComponent enchantmentProgression, boolean considerDisabled) {
        this(enchantmentProgression, considerDisabled, 0);
    }

    public EnchantmentProgressionTooltipComponent(EnchantmentProgressionComponent enchantmentProgression, boolean considerDisabled, int offset) {
        this.enchantmentProgression = enchantmentProgression;
        this.considerDisabled = considerDisabled;
        this.offset = offset;
    }

    public int getWidth() {
        return 124;
    }

    public int getHeight() {
        return this.enchantmentProgression.isEmpty() ? 0 : 16;
    }

    public int method_32664(class_327 textRenderer) {
        return this.getWidth();
    }

    public int method_32661(class_327 textRenderer) {
        return this.getHeight();
    }

    private int getXMargin(int width) {
        return (width - this.getWidth() - 1) / 2;
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        if (!this.enchantmentProgression.isEmpty()) {
            this.drawProgressBar(x + this.getXMargin(width), y - this.offset, textRenderer, context);
        }
    }

    private void drawProgressBar(int x, int y, class_327 textRenderer, class_332 drawContext) {
        drawContext.method_52706(class_10799.field_56883, ENCHANTMENT_PROGRESS_BAR_FILL_TEXTURE, x + 1, y, this.getProgressBarFill(), this.getHeight() - 3);
        drawContext.method_52706(class_10799.field_56883, ENCHANTMENT_PROGRESS_BAR_BORDER_TEXTURE, x, y, this.getWidth(), this.getHeight() - 3);
        drawContext.method_27534(textRenderer, this.getProgressBarLabel(), x + this.getWidth() / 2, y + 3, -1);
    }

    private class_2561 getProgressBarLabel() {
        double progress = this.getSelectedProgress().doubleValue();
        int percentage = class_3532.method_15357((double)(progress * 100.0));
        if (progress > 0.0 && percentage <= 0) {
            percentage = 1;
        }
        return class_2561.method_30163((String)(percentage + "%"));
    }

    private int getProgressBarFill() {
        int multiplier = this.getWidth() - 2;
        return class_3532.method_15340((int)class_3532.method_59515((Fraction)this.getSelectedProgress(), (int)multiplier), (int)0, (int)multiplier);
    }

    private Fraction getSelectedProgress() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            return this.enchantmentProgression.getSelectedProgress(player.method_56673(), this.considerDisabled);
        }
        return Fraction.ZERO;
    }
}

