/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.client.render.entity.feature;

import dev.mariany.arcanehand.ArcaneHand;
import dev.mariany.arcanehand.client.render.entity.model.AHModels;
import dev.mariany.arcanehand.client.render.entity.model.GauntletEntityModel;
import dev.mariany.arcanehand.client.render.entity.state.EntityWithGauntletRenderState;
import dev.mariany.arcanehand.client.render.entity.state.GauntletRenderState;
import dev.mariany.arcanehand.item.GauntletItem;
import dev.mariany.arcanehand.mixin.accessor.PlayerEntityModelAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10034;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class GauntletFeatureRenderer<S extends class_10034, M extends class_572<S>>
extends class_3887<S, M> {
    private static final String TEXTURE_ROOT = "textures/entity/equipment/humanoid/gauntlet/gauntlet";
    private static final class_2960 TEXTURE = ArcaneHand.id("textures/entity/equipment/humanoid/gauntlet/gauntlet.png");
    private static final class_2960 TEXTURE_SLIM = ArcaneHand.id("textures/entity/equipment/humanoid/gauntlet/gauntlet_slim.png");
    private static final String OVERLAY_ROOT = "textures/entity/equipment/humanoid/gauntlet/overlay";
    private static final class_2960 OVERLAY = ArcaneHand.id("textures/entity/equipment/humanoid/gauntlet/overlay.png");
    private static final class_2960 OVERLAY_SLIM = ArcaneHand.id("textures/entity/equipment/humanoid/gauntlet/overlay_slim.png");
    private final GauntletEntityModel<S> defaultModel;
    private final GauntletEntityModel<S> slimModel;
    private final GauntletEntityModel<S> firstPersonModel;
    private final GauntletEntityModel<S> firstPersonSlimModel;

    public GauntletFeatureRenderer(class_3883<S, M> context, class_5599 models) {
        super(context);
        this.defaultModel = new GauntletEntityModel(models.method_32072(AHModels.GAUNTLET));
        this.slimModel = new GauntletEntityModel(models.method_32072(AHModels.GAUNTLET_SLIM));
        this.firstPersonModel = new GauntletEntityModel(models.method_32072(AHModels.GAUNTLET_FIRST_PERSON));
        this.firstPersonSlimModel = new GauntletEntityModel(models.method_32072(AHModels.GAUNTLET_FIRST_PERSON_SLIM));
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, S state, float limbAngle, float limbDistance) {
        if (state instanceof EntityWithGauntletRenderState) {
            EntityWithGauntletRenderState entityWithGauntletRenderState = (EntityWithGauntletRenderState)state;
            GauntletRenderState gauntletRenderState = entityWithGauntletRenderState.arcanehand$getGauntletRenderState();
            if (!gauntletRenderState.inMainHand && !gauntletRenderState.inOffHand) {
                return;
            }
            matrices.method_22903();
            GauntletEntityModel<S> gauntletModel = this.getUsedModel(this.method_17165());
            gauntletModel.method_2805(false);
            this.renderArms(vertexConsumers, gauntletModel, gauntletRenderState, matrices, light);
            matrices.method_22909();
        }
    }

    public void renderFirstPerson(class_4587 matrices, class_4597 vertices, class_1799 stack, int light, class_1306 arm) {
        this.renderArmWithOverlay(this.getUsedModelFirstPerson(this.method_17165()), matrices, vertices, light, arm == class_1306.field_6183, GauntletItem.getColor(stack), stack.method_7958(), this.getUsedTexture(this.method_17165()), this.getUsedOverlay(this.method_17165()));
    }

    private boolean isSlim(class_583<?> model) {
        if (model instanceof class_591) {
            class_591 playerModel = (class_591)model;
            return ((PlayerEntityModelAccessor)playerModel).arcanehand$thinArms();
        }
        return false;
    }

    private class_2960 getUsedTexture(class_583<?> model) {
        return this.isSlim(model) ? TEXTURE_SLIM : TEXTURE;
    }

    private class_2960 getUsedOverlay(class_583<?> model) {
        return this.isSlim(model) ? OVERLAY_SLIM : OVERLAY;
    }

    private GauntletEntityModel<S> getUsedModel(class_583<?> model) {
        return this.isSlim(model) ? this.slimModel : this.defaultModel;
    }

    private GauntletEntityModel<S> getUsedModelFirstPerson(class_583<?> model) {
        return this.isSlim(model) ? this.firstPersonSlimModel : this.firstPersonModel;
    }

    private void renderArms(class_4597 vertices, GauntletEntityModel<S> gauntletModel, GauntletRenderState gauntletRenderState, class_4587 matrices, int light) {
        class_2960 texture = this.getUsedTexture(this.method_17165());
        class_2960 overlay = this.getUsedOverlay(this.method_17165());
        if (gauntletRenderState.inMainHand) {
            this.renderArmWithOverlay(gauntletModel, matrices, vertices, light, gauntletRenderState.mainHandAlignedRight, gauntletRenderState.mainHandColor, gauntletRenderState.mainHandGlinted, texture, overlay);
        }
        if (gauntletRenderState.inOffHand) {
            this.renderArmWithOverlay(gauntletModel, matrices, vertices, light, !gauntletRenderState.mainHandAlignedRight, gauntletRenderState.offHandColor, gauntletRenderState.offHandGlinted, texture, overlay);
        }
    }

    private void renderArmWithOverlay(GauntletEntityModel<S> gauntletModel, class_4587 matrices, class_4597 vertices, int light, boolean rightArm, int color, boolean glint, class_2960 gauntletTexture, class_2960 overlayTexture) {
        this.renderArm(gauntletModel, matrices, vertices, light, rightArm, color, glint, gauntletTexture);
        this.renderArm(gauntletModel, matrices, vertices, light, rightArm, -1, glint, overlayTexture);
    }

    private void renderArm(GauntletEntityModel<S> gauntletModel, class_4587 matrices, class_4597 vertices, int light, boolean rightArm, int color, boolean glint, class_2960 texture) {
        ((class_572)this.method_17165()).method_64254(gauntletModel);
        class_4588 consumer = class_918.method_27952((class_4597)vertices, (class_1921)class_1921.method_25448((class_2960)texture), (boolean)glint);
        if (rightArm) {
            gauntletModel.field_3401.field_3665 = true;
            gauntletModel.field_3401.method_22699(matrices, consumer, light, class_4608.field_21444, color);
        } else {
            gauntletModel.field_27433.field_3665 = true;
            gauntletModel.field_27433.method_22699(matrices, consumer, light, class_4608.field_21444, color);
        }
    }
}

