/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.component.type;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mariany.arcanehand.enchantment.EnchantmentProgression;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5632;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9304;
import net.minecraft.class_9473;
import net.minecraft.class_9636;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public record EnchantmentProgressionComponent(ImmutableMap<class_5321<class_1887>, EnchantmentProgression> enchantments, int selectedEnchantment) implements class_9299,
class_5632
{
    public static final EnchantmentProgressionComponent DEFAULT = new EnchantmentProgressionComponent(new HashMap<class_5321<class_1887>, EnchantmentProgression>(), 0);
    private static final Codec<class_5321<class_1887>> ENCHANTMENT_CODEC = class_5321.method_39154((class_5321)class_7924.field_41265);
    private static final class_9139<ByteBuf, class_5321<class_1887>> ENCHANTMENT_PACKET_CODEC = class_5321.method_56038((class_5321)class_7924.field_41265);
    public static final Codec<EnchantmentProgressionComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(ENCHANTMENT_CODEC, EnchantmentProgression.CODEC).fieldOf("enchantments").forGetter(EnchantmentProgressionComponent::enchantments), (App)Codec.INT.optionalFieldOf("selected_enchantment", (Object)0).forGetter(EnchantmentProgressionComponent::selectedEnchantment)).apply((Applicative)instance, EnchantmentProgressionComponent::new));
    public static final class_9139<class_9129, EnchantmentProgressionComponent> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.method_56377(HashMap::new, ENCHANTMENT_PACKET_CODEC, EnchantmentProgression.PACKET_CODEC), EnchantmentProgressionComponent::enchantments, (class_9139)class_9135.field_49675, EnchantmentProgressionComponent::selectedEnchantment, (x$0, x$1) -> new EnchantmentProgressionComponent((Map)x$0, (int)x$1));

    public EnchantmentProgressionComponent(Map<class_5321<class_1887>, EnchantmentProgression> enchantments, int selectedEnchantment) {
        this((ImmutableMap<class_5321<class_1887>, EnchantmentProgression>)ImmutableMap.copyOf(enchantments), selectedEnchantment);
    }

    public static List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> sortByTooltipOrder(class_7225.class_7226<class_1887> enchantmentRegistry, List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> entries, boolean groupByProgression) {
        HashMap<class_5321<class_1887>, Integer> orderMap = new HashMap<class_5321<class_1887>, Integer>();
        enchantmentRegistry.method_46733(class_9636.field_51362).ifPresent(namedList -> {
            int i = 0;
            for (class_6880 entry : namedList) {
                Optional optionalKey = entry.method_40230();
                if (!optionalKey.isPresent()) continue;
                orderMap.put((class_5321)optionalKey.get(), i++);
            }
        });
        Comparator<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> comparator = EnchantmentProgressionComponent.getEntryComparator(orderMap, groupByProgression);
        return entries.stream().sorted(comparator).toList();
    }

    @NotNull
    private static Comparator<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> getEntryComparator(Map<class_5321<class_1887>, Integer> orderMap, boolean groupByProgression) {
        Comparator<Map.Entry> presence = Comparator.comparingInt(entry -> orderMap.containsKey(entry.getKey()) ? 0 : 1);
        Comparator<Map.Entry> tagOrder = Comparator.comparingInt(entry -> orderMap.getOrDefault(entry.getKey(), Integer.MAX_VALUE));
        Comparator<Map.Entry> idTiebreaker = Comparator.comparing(entry -> ((class_5321)entry.getKey()).method_29177().toString());
        if (groupByProgression) {
            Comparator<Map.Entry> progressionBucket = Comparator.comparingInt(entry -> ((EnchantmentProgression)entry.getValue()).level() > 0 ? 0 : 1);
            return progressionBucket.thenComparing(presence).thenComparing(tagOrder).thenComparing(idTiebreaker);
        }
        return presence.thenComparing(tagOrder).thenComparing(idTiebreaker);
    }

    public static List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> getSortedEntries(class_7225.class_7874 registries, Map<class_5321<class_1887>, EnchantmentProgression> enchantments) {
        return EnchantmentProgressionComponent.getSortedEntries(registries, enchantments, false);
    }

    public static List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> getSortedEntries(class_7225.class_7874 registries, Map<class_5321<class_1887>, EnchantmentProgression> enchantments, boolean groupByCompletion) {
        return registries.method_46759(class_7924.field_41265).map(enchantmentRegistry -> EnchantmentProgressionComponent.sortByTooltipOrder((class_7225.class_7226<class_1887>)enchantmentRegistry, enchantments.entrySet().stream().toList(), groupByCompletion)).orElse(List.of());
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public class_9304 toEnchantments(class_5455 registryManager) {
        class_2378 enchantmentRegistry = registryManager.method_30530(class_7924.field_41265);
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        for (Map.Entry entry : this.enchantments.entrySet()) {
            EnchantmentProgression progression = (EnchantmentProgression)entry.getValue();
            if (!progression.isEnabled()) continue;
            builder.method_57547((class_6880)enchantmentRegistry.method_46747((class_5321)entry.getKey()), progression.level());
        }
        return builder.method_57549();
    }

    public EnchantmentProgressionComponent excludingUnset() {
        HashMap<class_5321<class_1887>, EnchantmentProgression> enchantments = new HashMap<class_5321<class_1887>, EnchantmentProgression>((Map<class_5321<class_1887>, EnchantmentProgression>)this.enchantments);
        enchantments.entrySet().removeIf(entry -> ((EnchantmentProgression)entry.getValue()).isUnset());
        return new EnchantmentProgressionComponent(enchantments, this.selectedEnchantment);
    }

    public Fraction getSelectedProgress(class_5455 registryManager, boolean strict) {
        return registryManager.method_46759(class_7924.field_41265).flatMap(enchantmentRegistry -> {
            List<Map.Entry> entries = EnchantmentProgressionComponent.sortByTooltipOrder((class_7225.class_7226<class_1887>)enchantmentRegistry, this.enchantments.entrySet().stream().toList(), true).stream().filter(entry -> !strict || ((EnchantmentProgression)entry.getValue()).isEnabled()).toList();
            return Optional.of(entries).filter(enchantments -> this.selectedEnchantment < enchantments.size()).map(enchantments -> (Map.Entry)enchantments.get(this.selectedEnchantment)).flatMap(entry -> enchantmentRegistry.method_46746((class_5321)entry.getKey()).map(enchantment -> this.getProgressFraction((EnchantmentProgression)entry.getValue(), (class_1887)enchantment.comp_349())));
        }).orElse(Fraction.ZERO);
    }

    private Fraction getProgressFraction(EnchantmentProgression progression, class_1887 enchantment) {
        class_1887.class_9427 enchantmentDefinition = enchantment.comp_2687();
        if (progression.level() >= enchantmentDefinition.comp_2509()) {
            return Fraction.ONE;
        }
        int neededExperience = progression.getUpgradeCost(enchantmentDefinition);
        int earnedExperience = progression.earnedExperience();
        return Fraction.getFraction((int)earnedExperience, (int)neededExperience);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        class_7225.class_7874 wrapperLookup = context.method_59527();
        if (wrapperLookup != null) {
            wrapperLookup.method_46759(class_7924.field_41265).ifPresent(enchantmentRegistry -> {
                List<Map.Entry> entries = EnchantmentProgressionComponent.sortByTooltipOrder((class_7225.class_7226<class_1887>)enchantmentRegistry, this.enchantments.entrySet().stream().toList(), true).stream().filter(entry -> ((EnchantmentProgression)entry.getValue()).isEnabled()).toList();
                int enchantCount = entries.size();
                for (int i = 0; i < enchantCount; ++i) {
                    Map.Entry entry2 = entries.get(i);
                    class_5321 enchantmentKey = (class_5321)entry2.getKey();
                    EnchantmentProgression progress = (EnchantmentProgression)entry2.getValue();
                    boolean isSelected = this.selectedEnchantment == i && enchantCount > 1;
                    enchantmentRegistry.method_46746(enchantmentKey).ifPresent(enchantment -> textConsumer.accept(EnchantmentProgression.getEnchantmentText((class_6880<class_1887>)enchantment, progress, isSelected)));
                }
            });
        }
    }
}

