/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mariany.arcanehand.enchantment.EnchantmentProgressionState;
import net.minecraft.class_124;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record EnchantmentProgression(int level, int earnedExperience, EnchantmentProgressionState state) {
    public static final Codec<EnchantmentProgression> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("level").forGetter(EnchantmentProgression::level), (App)Codec.INT.fieldOf("earned_experience").forGetter(EnchantmentProgression::earnedExperience), (App)EnchantmentProgressionState.CODEC.fieldOf("state").forGetter(EnchantmentProgression::state)).apply((Applicative)instance, EnchantmentProgression::new));
    public static final class_9139<class_9129, EnchantmentProgression> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.field_48550, EnchantmentProgression::level, (class_9139)class_9135.field_48550, EnchantmentProgression::earnedExperience, EnchantmentProgressionState.PACKET_CODEC, EnchantmentProgression::state, EnchantmentProgression::new);

    public static class_2561 getEnchantmentText(class_6880<class_1887> enchantment, EnchantmentProgression progress) {
        return EnchantmentProgression.getEnchantmentText(enchantment, progress, false);
    }

    public static class_2561 getEnchantmentText(class_6880<class_1887> enchantment, EnchantmentProgression progress, boolean bold) {
        int level = progress.level();
        boolean isAppliedEnchantment = progress.level() > 0;
        class_5250 name = level > 0 ? class_1887.method_8179(enchantment, (int)level).method_27661() : ((class_1887)enchantment.comp_349()).comp_2686().method_27661();
        class_124 color = isAppliedEnchantment ? class_124.field_1080 : class_124.field_1063;
        class_2564.method_10889((class_5250)name, (class_2583)class_2583.field_24360.method_10977(color).method_10982(Boolean.valueOf(bold)));
        return name;
    }

    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    public boolean isUnset() {
        return this.state.isUnset();
    }

    public EnchantmentProgression withToggledState() {
        EnchantmentProgressionState newState = this.state.toggle();
        if (!newState.isEnabled() && this.level <= 0 && this.earnedExperience <= 0) {
            newState = EnchantmentProgressionState.UNSET;
        }
        return new EnchantmentProgression(this.level, this.earnedExperience, newState);
    }

    public int getUpgradeCost(class_1887.class_9427 definition) {
        int nextLevel = this.level + 1;
        class_1887.class_9426 minCost = definition.comp_2510();
        int base = Math.max(minCost.comp_2504(), minCost.comp_2690());
        int cost = Math.min(15, Math.max(base / 2, 1) * nextLevel);
        return this.convertLevelsToExperience(cost);
    }

    private int convertLevelsToExperience(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(level * 6));
        }
        if (level <= 31) {
            return (int)(Math.pow(level, 2.0) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)(Math.pow(level, 2.0) * 4.5 - 162.5 * (double)level + 2220.0);
    }
}

