/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.item;

import com.google.common.collect.ImmutableMap;
import dev.mariany.arcanehand.advancement.criterion.AHCriteria;
import dev.mariany.arcanehand.component.AHComponents;
import dev.mariany.arcanehand.component.type.EnchantmentProgressionComponent;
import dev.mariany.arcanehand.enchantment.EnchantmentProgression;
import dev.mariany.arcanehand.enchantment.EnchantmentProgressionState;
import dev.mariany.arcanehand.tag.AHTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5632;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class GauntletItem
extends class_1792 {
    public static final int DEFAULT_GAUNTLET_COLOR = -6265536;
    private static final List<class_6862<class_1792>> GAUNTLET_ENCHANTABLE = List.of(AHTags.Items.GAUNTLET_ENCHANTABLE, class_3489.field_48303, class_3489.field_48310, class_3489.field_48306, class_3489.field_48307, class_3489.field_48304, class_3489.field_48305);

    public GauntletItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_7886(class_1799 stack) {
        return false;
    }

    public boolean method_7885(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1309 user) {
        return GauntletItem.hasNeededDurability(world, pos, stack) && super.method_7885(stack, state, world, pos, user);
    }

    public static boolean hasNeededDurability(class_1937 world, class_2338 pos, class_1799 stack) {
        return world.method_8320(pos).method_26214((class_1922)world, pos) <= 0.0f || !GauntletItem.isConsideredBroken(stack);
    }

    private static boolean isConsideredBroken(class_1799 stack) {
        return stack.method_61657() || stack.method_63692();
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        if (GauntletItem.isConsideredBroken(stack)) {
            class_5250 text = class_2561.method_43471((String)"item.arcanehand.gauntlet.broken");
            class_2564.method_10889((class_5250)text, (class_2583)class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)));
            textConsumer.accept((class_2561)text);
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_10712 tooltipDisplayComponent = (class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        return tooltipDisplayComponent.method_67214(AHComponents.ENCHANTMENT_PROGRESSION) ? Optional.ofNullable((class_5632)stack.method_58694(AHComponents.ENCHANTMENT_PROGRESSION)) : Optional.empty();
    }

    public static boolean isGauntlet(class_1799 stack) {
        return stack.method_7909() instanceof GauntletItem;
    }

    public static int getColor(class_1799 stack) {
        if (GauntletItem.isGauntlet(stack)) {
            int color = class_9282.method_57470((class_1799)stack, (int)0);
            return color != 0 ? color : -6265536;
        }
        return -6265536;
    }

    public static boolean isAcceptableEnchantment(class_1887 enchantment) {
        return enchantment.comp_2687().comp_2506().method_45925().map(GAUNTLET_ENCHANTABLE::contains).orElse(false);
    }

    public static ImmutableMap<class_5321<class_1887>, EnchantmentProgression> getEnchantments(class_1799 stack) {
        return ((EnchantmentProgressionComponent)stack.method_58695(AHComponents.ENCHANTMENT_PROGRESSION, (Object)EnchantmentProgressionComponent.DEFAULT)).enchantments();
    }

    public static int getEnchantmentCount(class_1799 stack) {
        return Math.toIntExact(GauntletItem.getEnchantments(stack).values().stream().filter(EnchantmentProgression::isEnabled).count());
    }

    public static int getSelectedEnchantmentIndex(class_1799 stack) {
        return ((EnchantmentProgressionComponent)stack.method_58695(AHComponents.ENCHANTMENT_PROGRESSION, (Object)EnchantmentProgressionComponent.DEFAULT)).selectedEnchantment();
    }

    public static void setSelectedEnchantmentIndex(class_1799 stack, int selectedEnchantmentIndex) {
        EnchantmentProgressionComponent enchantmentProgressionComponent = (EnchantmentProgressionComponent)stack.method_58694(AHComponents.ENCHANTMENT_PROGRESSION);
        if (enchantmentProgressionComponent != null) {
            stack.method_57379(AHComponents.ENCHANTMENT_PROGRESSION, (Object)new EnchantmentProgressionComponent(enchantmentProgressionComponent.enchantments(), selectedEnchantmentIndex));
        }
    }

    public static void applyProgress(class_5455 dynamicRegistryManager, class_5321<class_1887> enchantmentKey, EnchantmentProgression progress, class_1799 stack) {
        EnchantmentProgressionComponent enchantmentProgressionComponent = (EnchantmentProgressionComponent)stack.method_58695(AHComponents.ENCHANTMENT_PROGRESSION, (Object)EnchantmentProgressionComponent.DEFAULT);
        HashMap<class_5321<class_1887>, EnchantmentProgression> progression = new HashMap<class_5321<class_1887>, EnchantmentProgression>((Map<class_5321<class_1887>, EnchantmentProgression>)enchantmentProgressionComponent.enchantments());
        progression.put(enchantmentKey, progress);
        GauntletItem.applyProgress(dynamicRegistryManager, progression, stack);
    }

    public static void applyProgress(class_5455 dynamicRegistryManager, Map<class_5321<class_1887>, EnchantmentProgression> progression, class_1799 stack) {
        EnchantmentProgressionComponent enchantmentProgressionComponent = (EnchantmentProgressionComponent)stack.method_58695(AHComponents.ENCHANTMENT_PROGRESSION, (Object)EnchantmentProgressionComponent.DEFAULT);
        EnchantmentProgressionComponent progressionComponent = new EnchantmentProgressionComponent(progression, enchantmentProgressionComponent.selectedEnchantment()).excludingUnset();
        stack.method_57379(AHComponents.ENCHANTMENT_PROGRESSION, (Object)progressionComponent);
        stack.method_57379(class_9334.field_49633, (Object)progressionComponent.toEnchantments(dynamicRegistryManager));
    }

    public static int progress(class_3222 player, class_1799 stack, int experience) {
        class_3218 world = player.method_51469();
        class_5455 registryManager = world.method_30349();
        class_2378 enchantmentRegistry = registryManager.method_30530(class_7924.field_41265);
        EnchantmentProgressionComponent enchantmentProgressionComponent = (EnchantmentProgressionComponent)stack.method_58695(AHComponents.ENCHANTMENT_PROGRESSION, (Object)EnchantmentProgressionComponent.DEFAULT);
        if (enchantmentProgressionComponent.isEmpty()) {
            return experience;
        }
        HashMap<class_5321<class_1887>, EnchantmentProgression> progression = new HashMap<class_5321<class_1887>, EnchantmentProgression>();
        ArrayList entries = new ArrayList(enchantmentProgressionComponent.enchantments().entrySet());
        Collections.shuffle(entries, () -> ((class_5819)world.field_9229).method_43055());
        int remaining = experience;
        int skipped = 0;
        for (Map.Entry entry : entries) {
            int consumed;
            class_5321 enchantmentKey = (class_5321)entry.getKey();
            EnchantmentProgression progress = (EnchantmentProgression)entry.getValue();
            boolean enabled = progress.isEnabled();
            int level = progress.level();
            int nextLevel = level + 1;
            Optional optionalEnchantment = enchantmentRegistry.method_31189(enchantmentKey);
            if (!optionalEnchantment.isPresent()) continue;
            class_1887 enchantment = (class_1887)optionalEnchantment.get();
            class_1887.class_9427 enchantmentDefinition = enchantment.comp_2687();
            if (!enabled || level >= enchantmentDefinition.comp_2509()) {
                progression.put((class_5321<class_1887>)enchantmentKey, progress);
                ++skipped;
                continue;
            }
            int previousExperience = progress.earnedExperience();
            int target = progress.getUpgradeCost(enchantmentDefinition);
            if (remaining >= target - previousExperience) {
                consumed = target - previousExperience;
                remaining -= consumed;
                progression.put((class_5321<class_1887>)enchantmentKey, new EnchantmentProgression(nextLevel, 0, EnchantmentProgressionState.ENABLED));
                AHCriteria.LEVELED_UP.method_9141(player);
            } else {
                consumed = remaining;
                progression.put((class_5321<class_1887>)enchantmentKey, new EnchantmentProgression(level, previousExperience + consumed, EnchantmentProgressionState.ENABLED));
                remaining = 0;
            }
            remaining = Math.max(0, remaining - consumed);
        }
        GauntletItem.applyProgress(registryManager, progression, stack);
        if (remaining > 0 && skipped < progression.size()) {
            return GauntletItem.progress(player, stack, remaining);
        }
        return remaining;
    }
}

