/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.logic;

import dev.mariany.arcanehand.logic.ExcavatorBreaker;
import dev.mariany.arcanehand.logic.VeinBreaker;
import dev.mariany.arcanehand.server.network.MiningState;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9698;
import net.minecraft.class_9723;
import org.apache.commons.lang3.mutable.MutableFloat;

public interface BlockBreaker {
    public static final ExcavatorBreaker EXCAVATOR = new ExcavatorBreaker();
    public static final VeinBreaker VEIN = new VeinBreaker();

    public List<class_2338> collectPositions(class_1937 var1, class_1657 var2);

    default public List<class_2338> collectPossiblePositions(class_1937 world, class_1657 player) {
        class_1799 stack = player.method_6047();
        class_9424 toolComponent = (class_9424)stack.method_58694(class_9334.field_50077);
        List<class_2338> positions = this.collectPositions(world, player);
        if (toolComponent != null) {
            int remainingDamage = stack.method_7936() - stack.method_7919();
            int maxBreaks = class_3532.method_15375((float)((float)remainingDamage / (float)toolComponent.comp_2500())) - 1;
            if (maxBreaks > 0) {
                return positions.stream().limit(maxBreaks).toList();
            }
            return List.of();
        }
        return positions;
    }

    public static Optional<BlockBreaker> getBlockBreaker(class_1657 player) {
        if (ExcavatorBreaker.getMineRadius(player) > 0) {
            return Optional.of(EXCAVATOR);
        }
        if (VeinBreaker.getMaxVeinSize(player) > 0) {
            return Optional.of(VEIN);
        }
        return Optional.empty();
    }

    public static class_3965 getBlockHitResult(class_1657 player) {
        class_243 cameraPos = player.method_5836(1.0f);
        class_243 rotation = player.method_5828(1.0f);
        double blockInteractionRange = player.method_55754();
        class_243 rayEnd = cameraPos.method_1031(rotation.field_1352 * blockInteractionRange, rotation.field_1351 * blockInteractionRange, rotation.field_1350 * blockInteractionRange);
        return player.method_37908().method_17742(new class_3959(cameraPos, rayEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
    }

    public static int getValue(class_1657 player, class_9331<List<class_9698<class_9723>>> type) {
        MutableFloat mineRadius = new MutableFloat();
        class_1890.method_8220((class_1799)player.method_6047(), (enchantment, level) -> BlockBreaker.modifyValue(type, (class_1887)enchantment.comp_349(), level, mineRadius));
        return Math.max(0, mineRadius.intValue());
    }

    private static void modifyValue(class_9331<List<class_9698<class_9723>>> type, class_1887 enchantment, int level, MutableFloat repairWithExperience) {
        for (class_9698 enchantmentEffectEntry : enchantment.method_60034(type)) {
            repairWithExperience.setValue(((class_9723)enchantmentEffectEntry.comp_2680()).method_60213(level, class_5819.method_43047(), repairWithExperience.getValue().floatValue()));
        }
    }

    public static boolean canHarvest(class_1657 player, class_2338 pos) {
        class_1937 world = player.method_37908();
        class_2680 state = world.method_8320(pos);
        class_1799 stack = player.method_6047();
        if (stack.method_61657() || stack.method_63692()) {
            return false;
        }
        return !state.method_26215() && player.method_7305(state) && world.method_8621().method_11952(pos);
    }

    public static boolean attemptBreak(class_1937 world, class_2338 pos, class_1657 player) {
        if (!player.method_5715() && BlockBreaker.canHarvest(player, pos)) {
            BlockBreaker.performBreak(world, player);
            return true;
        }
        return false;
    }

    public static void performBreak(class_1937 world, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_3218 serverWorld = serverPlayer.method_51469();
            class_3225 interactionManager = serverPlayer.field_13974;
            class_3225 class_32252 = serverPlayer.field_13974;
            if (class_32252 instanceof MiningState) {
                MiningState miningState = (MiningState)class_32252;
                miningState.arcaneHand$setIsMining(true);
                ArrayList needsBreaking = new ArrayList();
                BlockBreaker.getBlockBreaker(player).ifPresent(blockBreaker -> needsBreaking.addAll(blockBreaker.collectPossiblePositions(world, player)));
                for (class_2338 pos : needsBreaking) {
                    boolean shouldContinue;
                    class_2586 blockEntity;
                    class_2680 state = world.method_8320(pos);
                    class_2586 class_25862 = blockEntity = state.method_31709() ? world.method_8321(pos) : null;
                    if (!player.method_7305(state) || state.method_26215()) continue;
                    state.method_26204().method_9576(world, pos, state, player);
                    if (!interactionManager.method_14266(pos) || !(shouldContinue = ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(world, player, pos, state, world.method_8321(pos)))) continue;
                    if (world.method_8650(pos, false)) {
                        state.method_26204().method_9585((class_1936)world, pos, state);
                    }
                    if (player.method_68878()) continue;
                    class_1799 stack = player.method_6047();
                    class_2248.method_9609((class_2680)state, (class_3218)serverWorld, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)stack).forEach(drop -> class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)drop));
                    state.method_26180(serverWorld, pos, stack, true);
                    stack.method_7952(world, state, pos, player);
                    if (!player.method_7305(state)) continue;
                    player.method_7259(class_3468.field_15427.method_14956((Object)state.method_26204()));
                    player.method_7322(0.005f);
                }
                miningState.arcaneHand$setIsMining(false);
            }
        }
    }
}

