/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.logic;

import com.google.common.collect.Sets;
import dev.mariany.arcanehand.component.AHEnchantmentEffectComponents;
import dev.mariany.arcanehand.logic.BlockBreaker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3545;
import net.minecraft.class_3965;

public class VeinBreaker
implements BlockBreaker {
    public static int getMaxVeinSize(class_1657 player) {
        return BlockBreaker.getValue(player, AHEnchantmentEffectComponents.VEIN_MINE);
    }

    @Override
    public List<class_2338> collectPositions(class_1937 world, class_1657 player) {
        int maxVeinSize = VeinBreaker.getMaxVeinSize(player);
        LinkedList<class_3545<class_2338, Integer>> candidates = new LinkedList<class_3545<class_2338, Integer>>();
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_3965 blockHitResult = BlockBreaker.getBlockHitResult(player);
        if (blockHitResult.method_17783().equals((Object)class_239.class_240.field_1332)) {
            class_2338 startPos = blockHitResult.method_17777();
            class_2248 source = world.method_8320(startPos).method_26204();
            positions.add(startPos);
            VeinBreaker.addValidNeighbors(candidates, startPos, 1);
            HashSet visited = Sets.newHashSet((Object[])new class_2338[]{startPos});
            int blocks = 0;
            while (!candidates.isEmpty() && blocks < maxVeinSize) {
                class_3545<class_2338, Integer> candidate = candidates.poll();
                class_2338 pos = (class_2338)candidate.method_15442();
                int blockDistance = (Integer)candidate.method_15441();
                if (!world.method_24794(pos)) {
                    return positions;
                }
                if (!visited.add(pos) || !VeinBreaker.canHarvest(player, pos, source)) continue;
                positions.add(pos);
                if (blockDistance < maxVeinSize) {
                    VeinBreaker.addValidNeighbors(candidates, pos, blockDistance + 1);
                }
                ++blocks;
            }
        }
        return positions;
    }

    private static boolean canHarvest(class_1657 player, class_2338 pos, class_2248 source) {
        return player.method_37908().method_8320(pos).method_27852(source) && BlockBreaker.canHarvest(player, pos);
    }

    private static void addValidNeighbors(LinkedList<class_3545<class_2338, Integer>> candidates, class_2338 source, int distance) {
        class_2338[] blockPositions;
        class_2338 up = source.method_10084();
        class_2338 down = source.method_10074();
        candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)up, (Object)distance));
        candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)down, (Object)distance));
        for (class_2338 blockPos : blockPositions = new class_2338[]{up, down, source}) {
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10067(), (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10078(), (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10095(), (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10072(), (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10095().method_10067(), (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10095().method_10078(), (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10072().method_10067(), (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10072().method_10078(), (Object)distance));
        }
    }
}

