/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.arcanehand.screen;

import com.google.common.collect.ImmutableMap;
import dev.mariany.arcanehand.ArcaneHand;
import dev.mariany.arcanehand.block.AHBlocks;
import dev.mariany.arcanehand.component.AHComponents;
import dev.mariany.arcanehand.component.type.EnchantmentProgressionComponent;
import dev.mariany.arcanehand.enchantment.EnchantmentEntry;
import dev.mariany.arcanehand.enchantment.EnchantmentProgression;
import dev.mariany.arcanehand.enchantment.EnchantmentProgressionState;
import dev.mariany.arcanehand.item.GauntletItem;
import dev.mariany.arcanehand.screen.AHScreenHandlers;
import dev.mariany.arcanehand.tag.AHTags;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3914;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class ArcaneConsoleScreenHandler
extends class_1703 {
    private static final class_2960 EMPTY_GAUNTLET_SLOT_TEXTURE = ArcaneHand.id("container/arcane_console/gauntlet");
    private final class_3914 context;
    private final class_1937 world;
    Runnable contentsChangedListener = () -> {};
    private final class_1263 inventory = new class_1277(1){

        public void method_5431() {
            super.method_5431();
            ArcaneConsoleScreenHandler.this.method_7609((class_1263)this);
            ArcaneConsoleScreenHandler.this.contentsChangedListener.run();
        }
    };
    private final class_1735 inputSlot;
    private class_1799 inputStack = class_1799.field_8037;
    private final Map<class_5321<class_1887>, EnchantmentProgression> availableEnchantments = new HashMap<class_5321<class_1887>, EnchantmentProgression>();

    public ArcaneConsoleScreenHandler(int syncId, class_1661 inventory) {
        this(syncId, inventory, class_3914.field_17304);
    }

    public ArcaneConsoleScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(AHScreenHandlers.ARCANE_CONSOLE, syncId);
        this.context = context;
        this.world = playerInventory.field_7546.method_37908();
        this.inputSlot = this.method_7621(new class_1735(this, this.inventory, 0, 17, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(AHTags.Items.ARCANE_CONSOLE_MODIFIABLE);
            }

            public int method_7675() {
                return 1;
            }

            public class_2960 method_7679() {
                return EMPTY_GAUNTLET_SLOT_TEXTURE;
            }
        });
        this.method_61624((class_1263)playerInventory, 8, 108);
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public ImmutableMap<class_5321<class_1887>, EnchantmentProgression> getStackEnchantments() {
        return GauntletItem.getEnchantments(this.inputStack);
    }

    public boolean isCompatible(class_5321<class_1887> candidate) {
        HashMap<class_5321<class_1887>, EnchantmentProgression> existing = new HashMap<class_5321<class_1887>, EnchantmentProgression>((Map<class_5321<class_1887>, EnchantmentProgression>)this.getStackEnchantments());
        existing.remove(candidate);
        return this.isCompatible(existing, candidate);
    }

    public boolean isCompatible(Map<class_5321<class_1887>, EnchantmentProgression> existing, class_5321<class_1887> candidate) {
        return this.world.method_30349().method_46759(class_7924.field_41265).map(enchantmentRegistry -> {
            List<class_6880> enchantments = existing.entrySet().stream().map(entry -> ((EnchantmentProgression)entry.getValue()).isEnabled() ? (class_6880.class_6883)enchantmentRegistry.method_46746((class_5321)entry.getKey()).orElse(null) : null).filter(Objects::nonNull).toList();
            return enchantmentRegistry.method_46746(candidate).map(enchantment -> class_1890.method_8201((Collection)enchantments, (class_6880)enchantment)).orElse(false);
        }).orElse(false);
    }

    public List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> getSortedAvailableEnchantments() {
        return EnchantmentProgressionComponent.getSortedEntries((class_7225.class_7874)this.world.method_30349(), this.getAvailableEnchantments());
    }

    private Map<class_5321<class_1887>, EnchantmentProgression> getAvailableEnchantments() {
        return Map.copyOf(this.availableEnchantments);
    }

    public boolean method_7597(class_1657 player) {
        return ArcaneConsoleScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)AHBlocks.ARCANE_CONSOLE);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    public boolean method_7604(class_1657 player, int id) {
        Map.Entry<class_5321<class_1887>, EnchantmentProgression> entry;
        List<Map.Entry<class_5321<class_1887>, EnchantmentProgression>> sortedAvailableEnchantments = this.getSortedAvailableEnchantments();
        if (sortedAvailableEnchantments.size() > id && this.isCompatible((entry = sortedAvailableEnchantments.get(id)).getKey())) {
            class_1799 stack = this.inputStack.method_7972();
            GauntletItem.applyProgress(player.method_56673(), entry.getKey(), entry.getValue().withToggledState(), stack);
            this.inputSlot.method_53512(stack);
            return true;
        }
        return false;
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 result = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            result = slotStack.method_7972();
            if (slotIndex == 0) {
                if (!this.method_7616(slotStack, 1, 37, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(slotStack, result);
            } else if (!this.inputSlot.method_7681() && this.inputSlot.method_7680(slotStack) && slotStack.method_7947() == 1 ? !this.method_7616(slotStack, 0, 1, false) : (slotIndex >= 1 && slotIndex < 28 ? !this.method_7616(slotStack, 28, 37, false) : (slotIndex >= 28 && slotIndex < 37 ? !this.method_7616(slotStack, 1, 28, false) : !this.method_7616(slotStack, 1, 37, false)))) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == result.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return result;
    }

    public void method_7609(class_1263 inventory) {
        class_1799 itemStack = this.inputSlot.method_7677();
        this.inputStack = itemStack.method_7972();
        this.updateInput(itemStack);
    }

    private void updateInput(class_1799 stack) {
        this.availableEnchantments.clear();
        if (!stack.method_7960()) {
            class_5455 registryManager = this.world.method_30349();
            class_2378 enchantmentRegistry = registryManager.method_30530(class_7924.field_41265);
            for (Map.Entry entry : enchantmentRegistry.method_29722()) {
                EnchantmentEntry enchantmentEntry = new EnchantmentEntry(entry);
                if (!this.isAcceptable(registryManager, stack, enchantmentEntry)) continue;
                this.availableEnchantments.put(enchantmentEntry.id(), new EnchantmentProgression(0, 0, EnchantmentProgressionState.UNSET));
            }
            EnchantmentProgressionComponent enchantmentProgressionComponent = (EnchantmentProgressionComponent)stack.method_58695(AHComponents.ENCHANTMENT_PROGRESSION, (Object)EnchantmentProgressionComponent.DEFAULT);
            this.availableEnchantments.putAll((Map<class_5321<class_1887>, EnchantmentProgression>)enchantmentProgressionComponent.enchantments());
        }
    }

    private boolean isAcceptable(class_5455 registryManager, class_1799 stack, EnchantmentEntry enchantmentEntry) {
        class_2378 enchantmentRegistry = registryManager.method_30530(class_7924.field_41265);
        class_5321<class_1887> enchantmentId = enchantmentEntry.id();
        class_1887 enchantment = enchantmentEntry.value();
        Optional optionalInArcaneConsole = enchantmentRegistry.method_46733(AHTags.Enchantments.IN_ARCANE_CONSOLE);
        if (optionalInArcaneConsole.isPresent() && ((class_6885.class_6888)optionalInArcaneConsole.get()).method_40239().noneMatch(entry -> entry.method_40225(enchantmentId))) {
            return false;
        }
        if (stack.method_7909() instanceof GauntletItem) {
            Optional optionalGauntletBlacklist = enchantmentRegistry.method_46733(AHTags.Enchantments.GAUNTLET_BLACKLIST);
            if (optionalGauntletBlacklist.isPresent() && ((class_6885.class_6888)optionalGauntletBlacklist.get()).method_40239().anyMatch(entry -> entry.method_40225(enchantmentId))) {
                return false;
            }
            return GauntletItem.isAcceptableEnchantment(enchantment);
        }
        return enchantment.method_8192(stack);
    }
}

