/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class FoodProperties {
    public static final Codec<FoodProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("duration").forGetter(d -> d.duration), (App)Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)Codec.DOUBLE).fieldOf("effects").forGetter(d -> d.effects), (App)Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)Codec.DOUBLE).fieldOf("effects_percentage").forGetter(d -> d.effectsPercentage), (App)Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus").forGetter(d -> d.cookingBonus), (App)Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus_percent").forGetter(d -> d.cookingBonusPercent), (App)SimpleEffect.CODEC.listOf().fieldOf("potion_apply").forGetter(d -> d.potionApply), (App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().listOf().fieldOf("potion_remove").forGetter(d -> d.potionRemove)).apply((Applicative)instance, FoodProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodProperties> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FoodProperties>(){

        public FoodProperties decode(RegistryFriendlyByteBuf buf) {
            return new FoodProperties(buf.readInt(), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), buf.readList(b -> (SimpleEffect)SimpleEffect.STREAM_CODEC.decode((Object)buf)), buf.readList(b -> (Holder)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT).decode((Object)buf)));
        }

        public void encode(RegistryFriendlyByteBuf buf, FoodProperties props) {
            buf.writeInt(props.duration);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.effects);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.effectsPercentage);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.cookingBonus);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.cookingBonusPercent);
            buf.writeCollection(props.potionApply, (b, val) -> SimpleEffect.STREAM_CODEC.encode((Object)buf, val));
            buf.writeCollection(props.potionRemove, (b, val) -> ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT).encode((Object)buf, val));
        }
    };
    private final Map<Holder<Attribute>, Double> effects;
    private final Map<Holder<Attribute>, Double> effectsPercentage;
    private final Map<Holder<Attribute>, Double> cookingBonus;
    private final Map<Holder<Attribute>, Double> cookingBonusPercent;
    private final int duration;
    private final List<SimpleEffect> potionApply;
    private final List<Holder<MobEffect>> potionRemove;

    public FoodProperties(int duration, Map<Holder<Attribute>, Double> effects, Map<Holder<Attribute>, Double> effectsPercentage, Map<Holder<Attribute>, Double> cookingBonus, Map<Holder<Attribute>, Double> cookingBonusPercent, List<SimpleEffect> potionApply, List<Holder<MobEffect>> potionRemove) {
        this.effects = FoodProperties.createFor(effects);
        this.effectsPercentage = FoodProperties.createFor(effectsPercentage);
        this.cookingBonus = FoodProperties.createFor(cookingBonus);
        this.cookingBonusPercent = FoodProperties.createFor(cookingBonusPercent);
        this.duration = duration;
        this.potionApply = potionApply;
        this.potionRemove = potionRemove;
    }

    private static Map<Holder<Attribute>, Double> createFor(Map<Holder<Attribute>, Double> map) {
        Object2DoubleAVLTreeMap sorted = new Object2DoubleAVLTreeMap(RuneCraftoryAttributes.SORTED);
        sorted.putAll(map);
        return Object2DoubleSortedMaps.unmodifiable((Object2DoubleSortedMap)sorted);
    }

    public int getHPGain() {
        return this.effects.getOrDefault(RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), 0.0).intValue();
    }

    public int getHpPercentGain() {
        return this.effects.getOrDefault(RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), 0.0).intValue();
    }

    public int getRPRegen() {
        return this.effects.getOrDefault(RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), 0.0).intValue();
    }

    public int getRpPercentRegen() {
        return this.effectsPercentage.getOrDefault(RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), 0.0).intValue();
    }

    public int duration() {
        return this.duration;
    }

    public Map<Holder<Attribute>, Double> effects() {
        return this.effects;
    }

    public Map<Holder<Attribute>, Double> effectsMultiplier() {
        return this.effectsPercentage;
    }

    public Map<Holder<Attribute>, Double> cookingBonus() {
        return this.cookingBonus;
    }

    public Map<Holder<Attribute>, Double> cookingBonusPercent() {
        return this.cookingBonusPercent;
    }

    public List<Holder<MobEffect>> potionHeals() {
        return this.potionRemove;
    }

    public List<SimpleEffect> potionApply() {
        return this.potionApply;
    }

    public List<Component> texts(ItemStack stack) {
        MutableComponent comp;
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"runecraftory.tooltip.item.eaten").withStyle(ChatFormatting.GRAY));
        Pair<Map<Holder<Attribute>, Double>, Map<Holder<Attribute>, Double>> foodStats = ItemComponentUtils.foodStats(stack);
        Map effects = (Map)foodStats.getFirst();
        Map effectsPercent = (Map)foodStats.getSecond();
        ArrayList<MutableComponent> hpRpGain = new ArrayList<MutableComponent>();
        ArrayList<MutableComponent> hpRpIncrease = new ArrayList<MutableComponent>();
        ArrayList<MutableComponent> attributes = new ArrayList<MutableComponent>();
        for (Map.Entry entry : effects.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = Component.translatable((String)"runecraftory.tooltip.item.attribute", (Object[])new Object[]{Component.translatable((String)((Attribute)((Holder)entry.getKey()).value()).getDescriptionId()), this.format((Double)entry.getValue())}).withStyle(ChatFormatting.AQUA);
            if (((Holder)entry.getKey()).is(RuneCraftoryAttributes.HEALTH_GAIN.getKey()) || ((Holder)entry.getKey()).is(RuneCraftoryAttributes.RUNE_POINTS_GAIN.getKey())) {
                hpRpGain.add(comp);
                continue;
            }
            if (((Holder)entry.getKey()).value() == Attributes.MAX_HEALTH.value() || ((Holder)entry.getKey()).is(RuneCraftoryAttributes.MAX_RUNEPOINTS.getKey())) {
                hpRpIncrease.add(comp);
                continue;
            }
            attributes.add(CommonComponents.space().append((Component)comp));
        }
        for (Map.Entry entry : effectsPercent.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = Component.translatable((String)"runecraftory.tooltip.item.attribute.percentage", (Object[])new Object[]{Component.translatable((String)((Attribute)((Holder)entry.getKey()).value()).getDescriptionId()), this.format((Double)entry.getValue())}).withStyle(ChatFormatting.AQUA);
            if (((Holder)entry.getKey()).is(RuneCraftoryAttributes.HEALTH_GAIN.getKey()) || ((Holder)entry.getKey()).is(RuneCraftoryAttributes.RUNE_POINTS_GAIN.getKey())) {
                hpRpGain.add(comp);
                continue;
            }
            if (((Holder)entry.getKey()).value() == Attributes.MAX_HEALTH.value() || ((Holder)entry.getKey()).is(RuneCraftoryAttributes.MAX_RUNEPOINTS.getKey())) {
                hpRpIncrease.add(comp);
                continue;
            }
            attributes.add(CommonComponents.space().append((Component)comp));
        }
        if (!hpRpGain.isEmpty()) {
            list.add((Component)CommonComponents.space().append(ComponentUtils.formatList(hpRpGain, (Component)CommonComponents.space())));
        }
        if (!hpRpIncrease.isEmpty()) {
            list.add((Component)CommonComponents.space().append(ComponentUtils.formatList(hpRpIncrease, (Component)CommonComponents.space())));
        }
        list.addAll(attributes);
        return list;
    }

    private String format(double n) {
        return n >= 0.0 ? "+" + (int)n : "" + (int)n;
    }

    public String toString() {
        return "[Duration:" + this.duration + "]{effects:[" + String.valueOf(this.effects) + "], potions:[" + String.valueOf(this.potionRemove) + "]";
    }

    public static class Builder {
        private final Map<Holder<Attribute>, Double> effects = new HashMap<Holder<Attribute>, Double>();
        private final Map<Holder<Attribute>, Double> effectsPercentage = new HashMap<Holder<Attribute>, Double>();
        private final Map<Holder<Attribute>, Double> cookingBonus = new HashMap<Holder<Attribute>, Double>();
        private final Map<Holder<Attribute>, Double> cookingBonusPercent = new HashMap<Holder<Attribute>, Double>();
        private final List<SimpleEffect> potionApply = new ArrayList<SimpleEffect>();
        private final List<Holder<MobEffect>> potionRemove = new ArrayList<Holder<MobEffect>>();
        private final int duration;

        public Builder(int duration) {
            this.duration = duration;
        }

        public Builder setHPRegen(int hpRegen, int hpRegenPercent) {
            if (hpRegen != 0) {
                this.effects.put((Holder<Attribute>)RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), Double.valueOf(hpRegen));
            }
            if (hpRegenPercent != 0) {
                this.effectsPercentage.put((Holder<Attribute>)RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), Double.valueOf(hpRegenPercent));
            }
            return this;
        }

        public Builder setRPRegen(int rpRegen, int rpRegenPercent) {
            if (rpRegen != 0) {
                this.effects.put((Holder<Attribute>)RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), Double.valueOf(rpRegen));
            }
            if (rpRegenPercent != 0) {
                this.effectsPercentage.put((Holder<Attribute>)RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), Double.valueOf(rpRegenPercent));
            }
            return this;
        }

        public Builder setRPIncrease(int increase, int percentIncrease) {
            if (increase != 0) {
                this.effects.put((Holder<Attribute>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), Double.valueOf(increase));
            }
            if (percentIncrease != 0) {
                this.effectsPercentage.put((Holder<Attribute>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), Double.valueOf(percentIncrease));
            }
            return this;
        }

        public Builder addEffect(Holder<Attribute> att, double value) {
            this.effects.put(att, value);
            return this;
        }

        public Builder addEffectPercentage(Holder<Attribute> att, double value) {
            this.effectsPercentage.put(att, value);
            return this;
        }

        public Builder addCookingBonus(Holder<Attribute> att, double value) {
            this.cookingBonus.put(att, value);
            return this;
        }

        public Builder addCookingBonusPercent(Holder<Attribute> att, double value) {
            this.cookingBonusPercent.put(att, value);
            return this;
        }

        public Builder addPotion(Holder<MobEffect> effect, int duration, int amplifier) {
            this.potionApply.add(new SimpleEffect(effect, duration, amplifier));
            return this;
        }

        public Builder curePotion(Holder<MobEffect> effect) {
            this.potionRemove.add(effect);
            return this;
        }

        public FoodProperties build() {
            return new FoodProperties(this.duration, this.effects, this.effectsPercentage, this.cookingBonus, this.cookingBonusPercent, this.potionApply, this.potionRemove);
        }
    }
}

