/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;

public record GateSpawnData(ResourceLocation entity, int minDistanceFromSpawn, int minGateLevel, boolean canSpawnInWater, Map<TagKey<Biome>, Integer> biomes, Map<ResourceLocation, Integer> structures, Optional<EntityPredicate> gatePredicate, Optional<EntityPredicate> playerPredicate) {
    public static final Codec<GateSpawnData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("entity").forGetter(GateSpawnData::entity), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("min_distance_from_spawn").orElse((Object)0).forGetter(GateSpawnData::minDistanceFromSpawn), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("min_gate_level").orElse((Object)0).forGetter(GateSpawnData::minGateLevel), (App)Codec.BOOL.fieldOf("allow_underwater").forGetter(GateSpawnData::canSpawnInWater), (App)Codec.unboundedMap((Codec)TagKey.codec((ResourceKey)Registries.BIOME), (Codec)ExtraCodecs.POSITIVE_INT).fieldOf("biomes").forGetter(GateSpawnData::biomes), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)ExtraCodecs.POSITIVE_INT).fieldOf("structures").forGetter(GateSpawnData::structures), (App)EntityPredicate.CODEC.optionalFieldOf("gate_predicate").forGetter(d -> d.gatePredicate), (App)EntityPredicate.CODEC.optionalFieldOf("player_predicate").forGetter(d -> d.playerPredicate)).apply((Applicative)instance, GateSpawnData::new));

    public static class Builder {
        private final Map<TagKey<Biome>, Integer> biomes = new LinkedHashMap<TagKey<Biome>, Integer>();
        private final Map<ResourceLocation, Integer> structures = new LinkedHashMap<ResourceLocation, Integer>();
        private final int minDistanceFromSpawn;
        private final int minGateLevel;
        private boolean allowUnderwater;
        private EntityPredicate gatePredicate;
        private EntityPredicate playerPredicate;

        public Builder(int minDistanceFromSpawn, int minGateLevel) {
            this.minDistanceFromSpawn = minDistanceFromSpawn;
            this.minGateLevel = minGateLevel;
        }

        @SafeVarargs
        public final Builder addToBiomeTag(int weight, TagKey<Biome> ... biomes) {
            for (TagKey<Biome> tag : biomes) {
                this.biomes.put(tag, weight);
            }
            return this;
        }

        public Builder addToStructures(int weight, ResourceLocation ... structures) {
            for (ResourceLocation s : structures) {
                this.structures.put(s, weight);
            }
            return this;
        }

        public Builder canSpawnUnderwater() {
            this.allowUnderwater = true;
            return this;
        }

        public Builder withGatePredicate(EntityPredicate.Builder builder) {
            this.gatePredicate = builder.build();
            return this;
        }

        public Builder withPlayerPredicate(EntityPredicate.Builder builder) {
            this.playerPredicate = builder.build();
            return this;
        }

        public GateSpawnData build(ResourceLocation name) {
            return new GateSpawnData(name, this.minDistanceFromSpawn, this.minGateLevel, this.allowUnderwater, this.biomes, this.structures, Optional.ofNullable(this.gatePredicate), Optional.ofNullable(this.playerPredicate));
        }
    }
}

