/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.datapack.manager.CropManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public abstract class CropProvider
implements DataProvider {
    private final Map<ResourceLocation, CropProperties.Builder> data = new HashMap<ResourceLocation, CropProperties.Builder>();
    private final PackOutput packOutput;
    private final String modid;
    protected final CompletableFuture<HolderLookup.Provider> provider;

    public CropProvider(PackOutput packOutput, String modid, CompletableFuture<HolderLookup.Provider> provider) {
        this.packOutput = packOutput;
        this.modid = modid;
        this.provider = provider;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            ImmutableList.Builder futures = new ImmutableList.Builder();
            this.data.forEach((arg_0, arg_1) -> this.lambda$run$1((DynamicOps)ops, futures, cache, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futures.build().toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "CropProps for " + this.modid;
    }

    public void addStat(CropProperties.Builder builder) {
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)builder.tryGetId().getPath());
        this.addStat(res, builder);
    }

    public void addStat(ResourceLocation id, CropProperties.Builder builder) {
        if (this.data.put(id, builder) != null) {
            throw new IllegalStateException("Duplicate id " + String.valueOf(id));
        }
    }

    private /* synthetic */ void lambda$run$1(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, CropProperties.Builder builder) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + CropManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)CropProperties.CODEC.encodeStart(ops, (Object)builder.build()).getOrThrow();
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }
}

