/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.datapack.provider.AdditionalLanguages;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.GiftManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCActionManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCConversationManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCDataManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCLookManager;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackActions;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public abstract class NPCDataProvider
implements DataProvider,
AdditionalLanguages {
    private final Map<ResourceLocation, NPCLook> looks = new HashMap<ResourceLocation, NPCLook>();
    private final Map<ResourceLocation, ConversationSet> conversations = new HashMap<ResourceLocation, ConversationSet>();
    private final Map<ResourceLocation, GiftData> giftData = new LinkedHashMap<ResourceLocation, GiftData>();
    private final Map<ResourceLocation, NPCAttackActions> actions = new HashMap<ResourceLocation, NPCAttackActions>();
    private final Map<ResourceLocation, NPCData> data = new HashMap<ResourceLocation, NPCData>();
    public final Map<String, Map<String, String>> dialogueTranslations = new LinkedHashMap<String, Map<String, String>>();
    private final Map<String, String> translations = new LinkedHashMap<String, String>();
    private final PackOutput packOutput;
    private final FileVerifier verifier;
    protected final String modid;
    protected final CompletableFuture<HolderLookup.Provider> provider;

    public NPCDataProvider(PackOutput packOutput, FileVerifier verifier, String modid, CompletableFuture<HolderLookup.Provider> provider) {
        this.packOutput = packOutput;
        this.verifier = verifier;
        this.modid = modid;
        this.provider = provider;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            ImmutableList.Builder futures = new ImmutableList.Builder();
            this.data.forEach((arg_0, arg_1) -> this.lambda$run$1((DynamicOps)ops, futures, cache, arg_0, arg_1));
            this.looks.forEach((arg_0, arg_1) -> this.lambda$run$2((DynamicOps)ops, cache, futures, arg_0, arg_1));
            this.conversations.forEach((arg_0, arg_1) -> this.lambda$run$3((DynamicOps)ops, futures, cache, arg_0, arg_1));
            this.giftData.forEach((arg_0, arg_1) -> this.lambda$run$4((DynamicOps)ops, cache, futures, arg_0, arg_1));
            this.actions.forEach((arg_0, arg_1) -> this.lambda$run$5((DynamicOps)ops, futures, cache, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futures.build().toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "NPCData for " + this.modid;
    }

    public void addNPCData(String id, NPCData.Builder data, Map<ConversationContext, ConversationSet.Builder> conversations, Map<ResourceLocation, QuestResponseBuilder> questConversations) {
        conversations.forEach((key, value) -> {
            ResourceLocation conversationId = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)(id + "/" + key.key().getPath()));
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.getTranslations());
            this.conversations.put(conversationId, value.build());
            data.addInteractionIfAbsent((ConversationContext)key, conversationId);
        });
        questConversations.forEach((key, value) -> {
            ResourceLocation startId = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)(id + "/quest_start_" + key.getPath()));
            for (int i = 0; i < value.start.size(); ++i) {
                Object path = startId.getPath();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                ResourceLocation runIdI = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.start.get(i).getTranslations());
                this.conversations.put(runIdI, value.start.get(i).build());
            }
            ResourceLocation runId = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)(id + "/quest_active_" + key.getPath()));
            for (int i = 0; i < value.active.size(); ++i) {
                Object path = runId.getPath();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                ResourceLocation runIdI = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.active.get(i).getTranslations());
                this.conversations.put(runIdI, value.active.get(i).build());
            }
            ResourceLocation endId = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)(id + "/quest_end_" + key.getPath()));
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.end.getTranslations());
            this.conversations.put(endId, value.end.build());
            data.addQuestResponse((ResourceLocation)key, startId, runId, endId);
        });
        this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(data.getTranslations());
        this.data.put(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)id), data.build());
    }

    public ResourceLocation addLook(ResourceLocation id, NPCLook look) {
        if (this.looks.put(id, look) != null) {
            throw new IllegalStateException("Look already registered");
        }
        this.verifier.track(id, PackType.SERVER_DATA, NPCLookManager.DIRECTORY);
        return id;
    }

    public ResourceLocation addGiftData(ResourceLocation id, GiftData.Builder giftData) {
        if (this.giftData.put(id, giftData.build()) != null) {
            throw new IllegalStateException("GiftData already registered");
        }
        this.translations.putAll(giftData.translations);
        this.verifier.track(id, PackType.SERVER_DATA, GiftManager.DIRECTORY);
        return id;
    }

    public ResourceLocation addAttackActions(ResourceLocation id, NPCAttackActions.Builder actions) {
        if (this.actions.put(id, actions.build()) != null) {
            throw new IllegalStateException("Attack action already registered");
        }
        this.verifier.track(id, PackType.SERVER_DATA, NPCActionManager.DIRECTORY);
        return id;
    }

    private void verifyData(NPCData data) {
        if (data.look() != null) {
            for (NPCData.NPCLookId look : data.look()) {
                if (this.verifier.exists(look.id(), PackType.SERVER_DATA, NPCLookManager.DIRECTORY)) continue;
                throw new IllegalStateException("No look registered for " + String.valueOf(look.id()));
            }
        }
        if (data.combatActions() != null) {
            for (ResourceLocation action : data.combatActions()) {
                if (this.verifier.exists(action, PackType.SERVER_DATA, NPCActionManager.DIRECTORY)) continue;
                throw new IllegalStateException("No npc action registered for " + String.valueOf(action));
            }
        }
        data.giftItems().forEach((s, g) -> {
            if (g.giftID() != null && !this.verifier.exists(g.giftID(), PackType.SERVER_DATA, GiftManager.DIRECTORY)) {
                throw new IllegalStateException("No gift registered for " + String.valueOf(g.giftID()));
            }
        });
    }

    @Override
    public Map<String, String> translations() {
        return this.translations;
    }

    private /* synthetic */ void lambda$run$5(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, NPCAttackActions val) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + NPCActionManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)NPCAttackActions.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$4(DynamicOps ops, CachedOutput cache, ImmutableList.Builder futures, ResourceLocation res, GiftData val) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + GiftManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)GiftData.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path);
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$3(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, ConversationSet val) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + NPCConversationManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)ConversationSet.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$2(DynamicOps ops, CachedOutput cache, ImmutableList.Builder futures, ResourceLocation res, NPCLook val) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + NPCLookManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)NPCLook.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path);
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$1(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, NPCData val) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + NPCDataManager.DIRECTORY + "/" + res.getPath() + ".json");
        this.verifyData(val);
        JsonElement obj = (JsonElement)NPCData.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }

    public record QuestResponseBuilder(List<ConversationSet.Builder> start, List<ConversationSet.Builder> active, ConversationSet.Builder end) {
        public QuestResponseBuilder(ConversationSet.Builder start, ConversationSet.Builder active, ConversationSet.Builder end) {
            this(List.of(start), List.of(active), end);
        }
    }
}

