/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.common.datapack.manager.StructureBossManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public abstract class StructureBossProvider
implements DataProvider {
    private final Map<ResourceLocation, StructureBossManager.BossSpawnList> data = new HashMap<ResourceLocation, StructureBossManager.BossSpawnList>();
    private final PackOutput packOutput;
    private final String modid;
    private final FileVerifier verifier;
    protected final CompletableFuture<HolderLookup.Provider> provider;

    public StructureBossProvider(PackOutput packOutput, String modid, FileVerifier verifier, CompletableFuture<HolderLookup.Provider> provider) {
        this.packOutput = packOutput;
        this.modid = modid;
        this.verifier = verifier;
        this.provider = provider;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            ImmutableList.Builder futures = new ImmutableList.Builder();
            this.data.forEach((arg_0, arg_1) -> this.lambda$run$1((DynamicOps)ops, futures, cache, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futures.build().toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "StructureBosses for " + this.modid;
    }

    public void addGateSpawn(ResourceLocation key, StructureBossManager.BossSpawnList spawnData) {
        this.data.put(key, spawnData);
        this.verifier.track(key, PackType.SERVER_DATA, StructureBossManager.DIRECTORY);
    }

    private /* synthetic */ void lambda$run$1(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, StructureBossManager.BossSpawnList spawnData) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + StructureBossManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)StructureBossManager.BossSpawnList.CODEC.encodeStart(ops, (Object)spawnData).getOrThrow();
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }
}

