/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.SpellProperties;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class Spell {
    public static boolean tryUseWithCost(LivingEntity entity, ItemStack stack, Spell spell) {
        return Spell.tryUseWithCost(entity, stack, spell, 1.0f);
    }

    public static boolean tryUseWithCost(LivingEntity entity, ItemStack stack, Spell spell, float costMultiplier) {
        return Spell.tryUseWithCost(entity, stack, spell, costMultiplier, stack.getItem() instanceof ItemStaffBase);
    }

    public static boolean tryUseWithCost(LivingEntity entity, ItemStack stack, Spell spell, float costMultiplier, boolean hurt) {
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        if (!LevelCalc.useRP(data, (float)spell.properties().rpCost() * costMultiplier, hurt, spell.properties().percentageCost(), true, spell.costReductionSkills())) {
            if (!hurt) {
                EntityUtils.playSoundForPlayer(player, (SoundEvent)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
            }
            return false;
        }
        return true;
    }

    public static void playSound(LivingEntity entity, SoundEvent sound, float volume, float pitch) {
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), sound, entity.getSoundSource(), volume, pitch);
    }

    public void levelSkill(ServerPlayer player) {
        Map<Skills, Float> skillXp = this.properties().skillXP();
        if (!skillXp.isEmpty()) {
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            skillXp.forEach((skill, xp) -> LevelCalc.levelSkill(data, Skills.DARK, xp.floatValue()));
        }
    }

    public Skills[] costReductionSkills() {
        return (Skills[])DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor(this).skills().toArray(Skills[]::new);
    }

    public SpellProperties properties() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor(this);
    }

    public boolean use(LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.use(serverLevel, entity, ItemStack.EMPTY);
        }
        return false;
    }

    public boolean use(LivingEntity entity, boolean ignoreSeal) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.use(serverLevel, entity, ItemStack.EMPTY, ignoreSeal);
        }
        return false;
    }

    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack) {
        return this.use(level, entity, stack, false);
    }

    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, boolean ignoreSeal) {
        if (!ignoreSeal && EntityUtils.sealed(entity)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                EntityUtils.playSoundForPlayer(player, (SoundEvent)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
            }
            return false;
        }
        return this.use(level, entity, stack, 1.0f, 1, CombatUtils.getSpellLevelFromStack(stack));
    }

    public abstract boolean use(ServerLevel var1, LivingEntity var2, ItemStack var3, float var4, int var5, int var6);

    public AttackAction useAction() {
        return (AttackAction)RuneCraftoryAttackActions.STAFF_USE.get();
    }

    public boolean canUse(ServerLevel serverLevel, LivingEntity entity, ItemStack stack) {
        return entity.getVehicle() == null || this.usableOnMounts();
    }

    public boolean delayedUse() {
        return true;
    }

    public boolean usableOnMounts() {
        return this.useAction().usableOnMounts(0);
    }

    public String toString() {
        return RuneCraftorySpells.SPELLS.registry().getKey((Object)this).toString();
    }
}

