/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry.action;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.ToolUseData;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.Suppliers;

public record DataKey<T>(ResourceLocation id, Supplier<T> defaultValue, BiConsumer<LivingEntity, T> onClear) {
    public static final DataKey<Set<LivingEntity>> HIT_ENTITIES = new DataKey<Set>("runecraftory", "hit_entities", HashSet::new);
    public static final DataKey<ItemStack> USED_WEAPON = new DataKey<ItemStack>("runecraftory", "used_weapon", () -> ItemStack.EMPTY);
    public static final DataKey<ToolUseData> TOOL_DATA = new DataKey("runecraftory", "tool_data");
    public static final DataKey<Boolean> FIXED_LOOK = new DataKey<Boolean>("runecraftory", "fixed_look", () -> false);
    public static final DataKey<Spell> USED_SPELL = new DataKey("runecraftory", "used_spell");
    public static final DataKey<Float> SPIN_ROTATION = new DataKey<Float>("runecraftory", "spin_rotation", () -> Float.valueOf(0.0f));
    public static final DataKey<Vec3> MOVE_DIRECTION = new DataKey("runecraftory", "move_direction");
    public static final DataKey<LivingEntity> TARGET = new DataKey("runecraftory", "target");
    public static final DataKey<Boolean> GRAVITY = new DataKey<Boolean>("runecraftory", "gravity", () -> false, Entity::setNoGravity);

    public DataKey(String namespace, String path) {
        this(namespace, path, Suppliers.nul());
    }

    public DataKey(String namespace, String path, Supplier<T> defaultValue) {
        this(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), defaultValue, null);
    }

    public DataKey(String namespace, String path, Supplier<T> defaultValue, BiConsumer<LivingEntity, T> onClear) {
        this(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), defaultValue, onClear);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataKey)) {
            return false;
        }
        DataKey dataKey = (DataKey)o;
        return Objects.equals(this.id, dataKey.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

