/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry.action;

import com.google.common.collect.ImmutableList;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class PlayerModelAnimations {
    public static final ResourceLocation ID = RuneCraftory.modRes("player_animation_definitions");
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final List<String> SHORT_SWORD = PlayerModelAnimations.addTo(6, "short_sword", count -> switch (count) {
        case 2 -> AnimationsBuilder.definition((double)0.52).marker("attack", new double[]{0.32}).marker("step", new double[]{0.24}).marker("done", new double[]{0.4});
        case 3 -> AnimationsBuilder.definition((double)0.52).marker("attack", new double[]{0.4}).marker("step", new double[]{0.24}).marker("done", new double[]{0.4});
        case 4 -> AnimationsBuilder.definition((double)0.48).marker("attack", new double[]{0.28}).marker("step", new double[]{0.28}).marker("done", new double[]{0.36});
        case 5 -> AnimationsBuilder.definition((double)0.48).marker("attack", new double[]{0.36}).marker("step", new double[]{0.16}).marker("done", new double[]{0.36});
        case 6 -> AnimationsBuilder.definition((double)1.68).marker("spin_start", new double[]{0.28}).marker("spin_end", new double[]{1.04}).marker("reset", new double[]{0.48, 0.72});
        default -> AnimationsBuilder.definition((double)0.52).marker("attack", new double[]{0.36}).marker("step", new double[]{0.28}).marker("done", new double[]{0.4});
    });
    public static final String SHORT_SWORD_USE = BUILDER.add("short_sword_use", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.4}));
    public static final List<String> LONG_SWORD = PlayerModelAnimations.addTo(4, "long_sword", count -> switch (count) {
        case 2 -> AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.56}).marker("step", new double[]{0.44}).marker("done", new double[]{0.64});
        case 3 -> AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.64}).marker("step", new double[]{0.36}).marker("done", new double[]{0.64});
        case 4 -> AnimationsBuilder.definition((double)1.64).marker("spin_start", new double[]{0.2}).marker("spin_end", new double[]{1.56}).marker("reset", new double[]{0.72});
        default -> AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.52}).marker("done", new double[]{0.64});
    });
    public static final String LONG_SWORD_USE = BUILDER.add("long_sword_use", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.44}));
    public static final List<String> SPEAR = PlayerModelAnimations.addTo(5, "spear", count -> switch (count) {
        case 2 -> AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.36}).marker("step", new double[]{0.36}).marker("done", new double[]{0.48});
        case 5 -> AnimationsBuilder.definition((double)2.24).marker("spin_start", new double[]{0.2}).marker("spin_end", new double[]{1.32}).marker("reset", new double[]{0.56, 0.92}).marker("leap", new double[]{1.48}).marker("leap_end", new double[]{1.84}).marker("slam", new double[]{1.96});
        default -> AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}).marker("step", new double[]{0.48}).marker("done", new double[]{0.48});
    });
    public static final String SPEAR_USE = BUILDER.add("spear_use", AnimationsBuilder.definition((double)1.28).marker("attack", new double[]{0.36}).marker("end_continue", new double[]{0.52}).marker("final", new double[]{1.04}).marker("chain_offset", new double[]{0.25}));
    public static final List<String> HAMMER_AXE = PlayerModelAnimations.addTo(3, "hammer_axe", count -> count == 3 ? AnimationsBuilder.definition((double)1.64).marker("spin_start", new double[]{0.44}).marker("spin_middle", new double[]{0.96}).marker("spin_end", new double[]{1.52}).marker("reset", new double[]{0.96}).marker("leap", new double[]{0.32}) : AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.8}).marker("done", new double[]{0.8}));
    public static final String HAMME_AXE_USE = BUILDER.add("hammer_axe_use", AnimationsBuilder.definition((double)1.12).marker("attack", new double[]{0.76}).marker("jump", new double[]{0.36}));
    public static final List<String> DUAL_BLADES = PlayerModelAnimations.addTo(8, "dual_blades", count -> switch (count) {
        case 2, 3, 4 -> AnimationsBuilder.definition((double)0.44).marker("attack", new double[]{0.32}).marker("step", new double[]{0.28}).marker("done", new double[]{0.32});
        case 5 -> AnimationsBuilder.definition((double)0.44).marker("spin_start", new double[]{0.08}).marker("spin_end", new double[]{0.32}).marker("step", new double[]{0.24}).marker("done", new double[]{0.32});
        case 6 -> AnimationsBuilder.definition((double)0.44).marker("spin_start", new double[]{0.05}).marker("spin_end", new double[]{0.32}).marker("reset", new double[]{0.16}).marker("step", new double[]{0.24}).marker("done", new double[]{0.32});
        case 7 -> AnimationsBuilder.definition((double)0.52).marker("leap", new double[]{0.12}).marker("down", new double[]{0.24}).marker("attack", new double[]{0.28}).marker("done", new double[]{0.4});
        case 8 -> AnimationsBuilder.definition((double)1.72).marker("spin_start", new double[]{0.28}).marker("spin_end", new double[]{1.28}).marker("reset", new double[]{0.6, 0.84, 1.08}).marker("last", new double[]{1.08});
        default -> AnimationsBuilder.definition((double)0.44).marker("attack", new double[]{0.32}).marker("step", new double[]{0.24}).marker("done", new double[]{0.32});
    });
    public static final String DUAL_BLADES_USE = BUILDER.add("dual_blades_use", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.36}));
    public static final List<String> GLOVES = PlayerModelAnimations.addTo(5, "glove", count -> switch (count) {
        case 4 -> AnimationsBuilder.definition((double)0.76).marker("jump", new double[]{0.24}).marker("down", new double[]{0.4}).marker("attack", new double[]{0.56});
        case 5 -> AnimationsBuilder.definition((double)1.32).marker("leap", new double[]{0.16}).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{0.88});
        default -> AnimationsBuilder.definition((double)0.48).marker("attack", new double[]{0.36}).marker("step", new double[]{0.28}).marker("done", new double[]{0.36});
    });
    public static final String GLOVES_USE = BUILDER.add("glove_use", AnimationsBuilder.definition((double)1.68).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{1.4}).marker("reset", new double[]{0.44, 0.6, 0.76, 0.92, 1.08, 1.24, 1.32}));
    public static final List<String> STAFF = PlayerModelAnimations.addTo(2, "staff", count -> count == 2 ? AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.52}) : AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.72}).marker("done", new double[]{0.72}));
    public static final String STAFF_USE = BUILDER.add("staff_use", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.52}));
    public static final String WATER_LASER_ONE = BUILDER.add("water_laser_one", AnimationsBuilder.definition((double)2.92).marker("attack", new double[]{0.52}).marker("continue", new double[]{0.67}));
    public static final String WATER_LASER_TWO = BUILDER.add("water_laser_two", AnimationsBuilder.definition((double)1.72).marker("attack", new double[]{0.52}).marker("continue", new double[]{0.67}));
    public static final String WATER_LASER_THREE = BUILDER.add("water_laser_three", AnimationsBuilder.definition((double)1.12).marker("attack", new double[]{0.52}).marker("continue", new double[]{0.67}));
    public static final String WATER_LASER_END = BUILDER.add("water_laser_end", AnimationsBuilder.definition((double)0.28));
    public static final String POWER_WAVE = BUILDER.add("power_wave", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.32}).marker("step", new double[]{0.32}));
    public static final List<String> DASH_SLASH = PlayerModelAnimations.addTo(2, "dash_slash", count -> count == 2 ? AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.44}) : AnimationsBuilder.definition((double)0.96).marker("move_start", new double[]{0.28}).marker("sound", new double[]{0.44}).marker("attack_start", new double[]{0.32}).marker("attack_end", new double[]{0.8}));
    public static final List<String> RUSH_ATTACK = PlayerModelAnimations.addTo(2, "rush_attack", count -> count == 2 ? AnimationsBuilder.definition((double)0.72).marker("attack_start", new double[]{0.2}).marker("attack_end", new double[]{0.52}).marker("leap", new double[]{0.16}) : AnimationsBuilder.definition((double)1.96).marker("attack", new double[]{0.4, 0.56, 1.08}).marker("chain_1_start", new double[]{0.4}).marker("chain_1_end", new double[]{0.84}).marker("chain_2_start", new double[]{1.32}).marker("chain_2_end", new double[]{1.6}).marker("step", new double[]{0.36, 0.56}).marker("jump", new double[]{0.96}));
    public static final String ROUND_BREAK = BUILDER.add("round_break", AnimationsBuilder.definition((double)1.12).marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{0.88}));
    public static final String MIND_THRUST = BUILDER.add("mind_thrust", AnimationsBuilder.definition((double)1.08).marker("attack", new double[]{0.84}).marker("step", new double[]{0.72}));
    public static final String BUFF = BUILDER.add("self_buff", AnimationsBuilder.definition((double)1.08).marker("attack", new double[]{0.64}));
    public static final String TWIN_ATTACK = BUILDER.add("twin_attack", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.4}));
    public static final List<String> STORM = PlayerModelAnimations.addTo(5, "storm", count -> switch (count) {
        case 2 -> AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.44}).marker("move", new double[]{0.32}).marker("done", new double[]{0.44});
        case 3 -> AnimationsBuilder.definition((double)0.52).marker("attack", new double[]{0.24}).marker("move", new double[]{0.24}).marker("done", new double[]{0.32});
        case 4 -> AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.44}).marker("up", new double[]{0.08}).marker("down", new double[]{0.24}).marker("done", new double[]{0.44});
        case 5 -> AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.44}).marker("up", new double[]{0.08}).marker("down", new double[]{0.36});
        default -> AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.44}).marker("move", new double[]{0.12}).marker("done", new double[]{0.44});
    });
    public static final String GUST = BUILDER.add("gust", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.6}).marker("jump", new double[]{0.12}));
    public static final String RAIL_STRIKE = BUILDER.add("rail_strike", AnimationsBuilder.definition((double)1.56).marker("attack_start", new double[]{0.4}).marker("attack_end", new double[]{1.12}).marker("move_1", new double[]{0.2}).marker("move_2", new double[]{0.72}).marker("move_end", new double[]{1.24}).marker("reset", new double[]{0.56, 0.84, 1.0}));
    public static final List<String> WIND_SLASH = PlayerModelAnimations.addTo(2, "wind_slash", count -> count == 2 ? AnimationsBuilder.definition((double)1.44).marker("spin_start", new double[]{0.0}).marker("spin_end", new double[]{1.08}).marker("reset", new double[]{0.56}) : AnimationsBuilder.definition((double)1.76).marker("spin_start", new double[]{0.36}).marker("spin_end", new double[]{1.4}).marker("reset", new double[]{0.88}).marker("chain_start", new double[]{1.08}).marker("leap", new double[]{0.28}));
    public static final String FLASH_STRIKE = BUILDER.add("flash_strike", AnimationsBuilder.definition((double)1.6).marker("attack_start", new double[]{0.32}).marker("attack_end", new double[]{1.04}).marker("reset", new double[]{0.56, 0.8}).marker("move_1", new double[]{0.36}).marker("move_2", new double[]{0.48}).marker("move_end", new double[]{1.08}));
    public static final String DELTA_STRIKE = BUILDER.add("delta_strike", AnimationsBuilder.definition((double)1.32).marker("attack", new double[]{0.36, 0.6, 1.12}).marker("step", new double[]{0.28, 1.04}));
    public static final String NAIVE_BLADE = BUILDER.add("naive_blade", AnimationsBuilder.definition((double)0.84).marker("prepared", new double[]{0.12}));
    public static final String NAIVE_BLADE_SUCCESS = BUILDER.add("naive_blade_success", AnimationsBuilder.definition((double)1.36).marker("attack_1", new double[]{0.2}).marker("attack_2", new double[]{1.04}).marker("jump", new double[]{0.64}));
    public static final String HURRICANE = BUILDER.add("hurricane", AnimationsBuilder.definition((double)2.08).marker("attack", new double[]{0.32}).marker("attack_start", new double[]{0.52}).marker("attack_end", new double[]{1.64}).marker("reset", new double[]{0.88, 1.24}));
    public static final String REAPER_SLASH = BUILDER.add("reaper_slash", AnimationsBuilder.definition((double)0.92).marker("attack_start", new double[]{0.28}).marker("attack_middle", new double[]{0.48}).marker("attack_end", new double[]{0.68}));
    public static final String MILLION_STRIKE = BUILDER.add("million_strike", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.48, 0.58, 0.68, 0.78}).marker("attack_crit", new double[]{0.78}));
    public static final String AXEL_DISASTER = BUILDER.add("axel_disaster", AnimationsBuilder.definition((double)1.44).marker("move_1", new double[]{0.28}).marker("move_2", new double[]{0.44}).marker("move_3", new double[]{1.04}).marker("move_done", new double[]{1.24}).marker("attack_start", new double[]{0.44}).marker("attack_end", new double[]{1.12}).marker("move_start", new double[]{0.32}).marker("move_end", new double[]{1.2}));
    public static final String STARDUST_UPPER = BUILDER.add("stardust_upper", AnimationsBuilder.definition((double)1.76).marker("attack_start_1", new double[]{0.16}).marker("attack_end_1", new double[]{0.84}).marker("attack_start_2", new double[]{0.84}).marker("attack_end_2", new double[]{1.52}));
    public static final String GRAND_IMPACT = BUILDER.add("grand_impact", AnimationsBuilder.definition((double)3.32).marker("attack_1", new double[]{0.76}).marker("attack_2", new double[]{1.52}).marker("combo_end", new double[]{1.0}));
    public static final String TORNADO_SWING = BUILDER.add("tornado_swing", AnimationsBuilder.definition((double)1.6).marker("attack_start_1", new double[]{0.2}).marker("attack_end_1", new double[]{1.04}).marker("attack_start_2", new double[]{1.04}).marker("attack_end_2", new double[]{1.4}).marker("chain_offset", new double[]{0.28}));
    public static final String GIGA_SWING = BUILDER.add("giga_swing", AnimationsBuilder.definition((double)1.08).marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{0.52}));
    public static final String UPPER_CUT = BUILDER.add("upper_cut", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.36}));
    public static final String DOUBLE_KICK = BUILDER.add("double_kick", AnimationsBuilder.definition((double)1.04).marker("attack_start", new double[]{0.2}).marker("attack_end", new double[]{0.76}).marker("reset", new double[]{0.52}).marker("step", new double[]{0.44}));
    public static final String STRAIGHT_PUNCH = BUILDER.add("straight_punch", AnimationsBuilder.definition((double)1.16).marker("attack", new double[]{0.92}));
    public static final String NEKO_DAMASHI = BUILDER.add("neko_damashi", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.52}));
    public static final String RUSH_PUNCH = BUILDER.add("rush_punch", AnimationsBuilder.definition((double)1.16).marker("attack", new double[]{0.52, 0.68, 0.84, 1.0}).marker("attack_crit", new double[]{1.16}));
    public static final String CYCLONE = BUILDER.add("cyclone", AnimationsBuilder.definition((double)1.44).marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.24}).marker("reset", new double[]{0.44, 0.64, 0.88, 1.08}));
    public static final String RAPID_MOVE = BUILDER.add("rapid_move", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.72}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();

    private static List<String> addTo(int amount, String baseName, DependendAnimationBuilder values) {
        ImmutableList.Builder list = new ImmutableList.Builder();
        for (int i = 1; i <= amount; ++i) {
            list.add((Object)BUILDER.add(baseName + "_" + i, values.apply(i)));
        }
        return list.build();
    }

    static interface DependendAnimationBuilder {
        public AnimationsBuilder.DefinitionBuilder apply(int var1);
    }
}

