/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.client.AttackAABBRender;
import io.github.flemmli97.runecraftory.client.BossBarTracker;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.ShakeHandler;
import io.github.flemmli97.runecraftory.client.gui.widgets.InfoButton;
import io.github.flemmli97.runecraftory.client.tooltips.UpgradeTooltipComponent;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.items.MultiBlockItem;
import io.github.flemmli97.runecraftory.common.items.tools.ItemFertilizer;
import io.github.flemmli97.runecraftory.common.network.C2SOpenInfo;
import io.github.flemmli97.runecraftory.common.network.C2SRideJump;
import io.github.flemmli97.runecraftory.common.network.C2SSpellKey;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.mixin.ContainerScreenAccessor;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClientCalls {
    public static final Set<EntityType<?>> SLEEP_ROTATED_TYPES = new HashSet();

    public static void clientTick() {
        BossBarTracker.tickSounds();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().isItemSwapBlocked()) {
            Options options = Minecraft.getInstance().options;
            for (int i = 0; i < 9; ++i) {
                while (options.keyHotbarSlots[i].consumeClick()) {
                }
            }
            while (options.keySwapOffhand.consumeClick()) {
            }
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        switch (ClientHandlers.SPELL_1.onPress()) {
            case PRESSING: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(0, false));
                break;
            }
            case RELEASE: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(0, true));
            }
        }
        switch (ClientHandlers.SPELL_2.onPress()) {
            case PRESSING: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(1, false));
                break;
            }
            case RELEASE: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(1, true));
            }
        }
        switch (ClientHandlers.SPELL_3.onPress()) {
            case PRESSING: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(2, false));
                break;
            }
            case RELEASE: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(2, true));
            }
        }
        switch (ClientHandlers.SPELL_4.onPress()) {
            case PRESSING: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(3, false));
                break;
            }
            case RELEASE: {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpellKey(3, true));
            }
        }
    }

    public static void initSkillTab(Screen screen, Consumer<AbstractWidget> cons) {
        if (ClientConfig.inventoryButton && (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen)) {
            int x = ((ContainerScreenAccessor)screen).getLeft();
            int y = ((ContainerScreenAccessor)screen).getTop();
            if (screen instanceof InventoryScreen) {
                x += ClientConfig.inventoryOffsetX;
                y += ClientConfig.inventoryOffsetY;
            } else {
                x += ClientConfig.creativeInventoryOffsetX;
                y += ClientConfig.creativeInventoryOffsetY;
            }
            cons.accept((AbstractWidget)new InfoButton(x, y, screen, b -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SOpenInfo(C2SOpenInfo.Action.MAIN))));
        }
    }

    public static void handleInputUpdate(Player player, Input input) {
        float reduction;
        if (EntityUtils.isDisabled((LivingEntity)player)) {
            input.leftImpulse = 0.0f;
            input.forwardImpulse = 0.0f;
            input.up = false;
            input.down = false;
            input.left = false;
            input.right = false;
            input.jumping = false;
            input.shiftKeyDown = false;
        }
        if ((reduction = ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().movementReduction()) != 1.0f) {
            input.leftImpulse *= reduction;
            input.forwardImpulse *= reduction;
            input.jumping = false;
            if (reduction == 0.0f) {
                input.up = false;
                input.down = false;
                input.left = false;
                input.right = false;
                input.shiftKeyDown = false;
            }
        }
    }

    public static void renderScreenOverlays(GuiGraphics graphics, DeltaTracker tracker) {
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        if (ClientHandlers.OVERLAY != null) {
            ClientHandlers.OVERLAY.renderBar(graphics);
        }
        if (ClientHandlers.SPELL_DISPLAY != null && ClientConfig.inventoryButton) {
            ClientHandlers.SPELL_DISPLAY.render(graphics, tracker);
        }
        if (ClientHandlers.FARM_DISPLAY != null) {
            ClientHandlers.FARM_DISPLAY.render(graphics);
        }
    }

    public static void tooltipEvent(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.isEmpty()) {
            Component component;
            if (stack.has((DataComponentType)RuneCraftoryDataComponentTypes.CRAFTING_BONUS.get()) && (component = tooltip.getFirst()) instanceof MutableComponent) {
                MutableComponent mut = (MutableComponent)component;
                mut.withStyle(ChatFormatting.AQUA);
            }
            Pair<List<Component>, List<Component>> p = ClientCalls.injectAdditionalTooltip(stack, flag);
            tooltip.addAll(1, (Collection)p.getFirst());
            tooltip.addAll((Collection)p.getSecond());
        }
    }

    private static Pair<List<Component>, List<Component>> injectAdditionalTooltip(ItemStack stack, TooltipFlag flag) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        boolean shift = Screen.hasShiftDown();
        ArrayList<MutableComponent> debug = new ArrayList<MutableComponent>();
        DataPackHandler.INSTANCE.itemStatManager().getWithId(stack.getItem()).ifPresent(stat -> {
            tooltip.addAll(((ItemStat)stat.value()).texts(stack, shift));
            if (flag.isAdvanced()) {
                debug.add(Component.translatable((String)"runecraftory.tooltip.debug.stat", (Object[])new Object[]{stat.id().toString()}).withStyle(ChatFormatting.GRAY));
            }
        });
        ReloadableHolder<CropProperties> props = DataPackHandler.INSTANCE.cropManager().getSeedWithId(stack.getItem());
        if (props != null) {
            tooltip.addAll(props.value().texts());
            if (flag.isAdvanced()) {
                debug.add(Component.translatable((String)"runecraftory.tooltip.debug.crop", (Object[])new Object[]{props.id().toString()}).withStyle(ChatFormatting.GRAY));
            }
        }
        if (shift) {
            ReloadableHolder<FoodProperties> food = DataPackHandler.INSTANCE.foodManager().getWithId(stack.getItem());
            if (food != null) {
                tooltip.addAll(food.value().texts(stack));
                if (flag.isAdvanced()) {
                    debug.add(Component.translatable((String)"runecraftory.tooltip.debug.food", (Object[])new Object[]{food.id().toString()}).withStyle(ChatFormatting.GRAY));
                }
            } else if (stack.has(DataComponents.FOOD)) {
                tooltip.add(Component.translatable((String)"runecraftory.tooltip.item.eaten").withStyle(ChatFormatting.GRAY));
                MutableComponent comp = CommonComponents.space().append((Component)Component.translatable((String)"runecraftory.tooltip.item.attribute", (Object[])new Object[]{Component.translatable((String)((RuneCraftoryAttributes.OrderedAttribute)((Object)RuneCraftoryAttributes.RUNE_POINTS_GAIN.get())).getDescriptionId()), EntityUtils.getRPFromVanillaFood(stack)}));
                tooltip.add(comp.withStyle(ChatFormatting.AQUA));
            }
        }
        return Pair.of(tooltip, debug);
    }

    public static void tooltipComponentEvent(ItemStack stack, Consumer<TooltipComponent> elements) {
        if (UpgradeTooltipComponent.shouldAdd(stack)) {
            elements.accept(new UpgradeTooltipComponent.UpgradeComponent(stack));
        }
    }

    public static void worldRender(PoseStack stack) {
        BlockHitResult result;
        BlockHitResult hitResult;
        MultiBlockItem multiBlockItem;
        if (GeneralConfig.debugAttack) {
            AttackAABBRender.INST.render(stack, Minecraft.getInstance().renderBuffers().crumblingBufferSource());
        }
        Minecraft minecraft = Minecraft.getInstance();
        MultiBlockItem item = null;
        ItemStack main = minecraft.player.getMainHandItem();
        ItemStack off = minecraft.player.getMainHandItem();
        ItemStack toUse = main;
        InteractionHand hand = InteractionHand.MAIN_HAND;
        Item item2 = off.getItem();
        if (item2 instanceof MultiBlockItem) {
            multiBlockItem = (MultiBlockItem)item2;
            if (!(main.getItem() instanceof BlockItem)) {
                item = multiBlockItem;
                toUse = off;
                hand = InteractionHand.OFF_HAND;
            }
        }
        if ((item2 = main.getItem()) instanceof MultiBlockItem) {
            item = multiBlockItem = (MultiBlockItem)item2;
            toUse = main;
            hand = InteractionHand.OFF_HAND;
        }
        if (item == null) {
            return;
        }
        HitResult hitResult2 = minecraft.hitResult;
        BlockHitResult blockHitResult = hitResult = hitResult2 instanceof BlockHitResult && (result = (BlockHitResult)hitResult2).getType() != HitResult.Type.MISS ? result : null;
        if (hitResult != null) {
            BlockPlaceContext ctx = new BlockPlaceContext((Player)minecraft.player, hand, toUse, hitResult);
            BlockPos pos = ctx.getClickedPos();
            Vec3 camPos = minecraft.gameRenderer.getMainCamera().getPosition();
            double x = camPos.x();
            double y = camPos.y();
            double z = camPos.z();
            MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
            VertexConsumer consumer = buffer.getBuffer(RenderType.lines());
            boolean invalid = false;
            ArrayList<Pair> list = new ArrayList<Pair>();
            Rotation rot = EntityUtils.fromDirection(minecraft.player.getDirection());
            for (Pair<BlockPos, BlockState> p : item.getBlocks()) {
                BlockPos offset = ((BlockPos)p.getFirst()).rotate(rot).offset((Vec3i)pos);
                BlockState current = minecraft.level.getBlockState(offset);
                if (!current.canBeReplaced(ctx)) {
                    invalid = true;
                    list.add(Pair.of((Object)offset, (Object)Shapes.empty()));
                    continue;
                }
                list.add(Pair.of((Object)offset, (Object)((BlockState)p.getSecond()).rotate(rot).getShape((BlockGetter)minecraft.level, offset).move((double)offset.getX(), (double)offset.getY(), (double)offset.getZ())));
            }
            float gb = invalid ? 0.3f : 1.0f;
            for (Pair p : list) {
                if (p.getSecond() == Shapes.empty()) continue;
                ClientCalls.renderBlockAt(stack, consumer, (VoxelShape)p.getSecond(), x, y, z, 1.0f, gb, gb, 1.0f, invalid);
            }
            buffer.endBatch(RenderType.lines());
        }
    }

    private static void renderBlockAt(PoseStack stack, VertexConsumer consumer, VoxelShape shape, double camX, double camY, double camZ, float r, float g, float b, float alpha, boolean invalid) {
        PoseStack.Pose pose = stack.last();
        shape.forAllEdges((k, l, m, n, o, p) -> {
            float dX = (float)(n - k);
            float dY = (float)(o - l);
            float dZ = (float)(p - m);
            float len = Mth.sqrt((float)(dX * dX + dY * dY + dZ * dZ));
            consumer.addVertex(pose, (float)(k - camX), (float)(l - camY), (float)(m - camZ)).setColor(r, g, b, alpha).setNormal(pose, dX /= len, dY /= len, dZ /= len);
            consumer.addVertex(pose, (float)(n - camX), (float)(o - camY), (float)(p - camZ)).setColor(r, g, b, alpha).setNormal(pose, dX, dY, dZ);
        });
    }

    public static void tick(LivingEntity entity) {
        int mod = entity.tickCount % 20;
        if (mod == 0 && entity.hasEffect(RuneCraftoryEffects.SLEEP.asHolder())) {
            double y = entity.getY();
            y = SLEEP_ROTATED_TYPES.contains(entity.getType()) ? (y += (double)entity.getBbHeight() * 0.6) : (y += (double)entity.getBbHeight() + 0.5);
            entity.level().addParticle((ParticleOptions)RuneCraftoryParticles.SLEEP.get(), entity.getX(), y, entity.getZ(), 0.0, 0.0, 0.0);
        }
        if (mod == 5 && entity.hasEffect(RuneCraftoryEffects.POISON.asHolder())) {
            entity.level().addParticle((ParticleOptions)RuneCraftoryParticles.POISON.get(), entity.getX(), entity.getY() + (double)entity.getBbHeight() + 0.1, entity.getZ(), 0.0, 0.0, 0.0);
        }
        if (entity == Minecraft.getInstance().player) {
            --ShakeHandler.shakeTick;
            Entity entity2 = entity.getVehicle();
            if (entity2 instanceof BaseMonster) {
                BaseMonster monster = (BaseMonster)entity2;
                if (Minecraft.getInstance().player.input.jumping) {
                    LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)C2SRideJump.INSTANCE);
                    monster.setDoJumping(true);
                }
            }
        }
        if (entity == Minecraft.getInstance().cameraEntity && ClientCalendarHolder.CLIENT_CALENDAR.currentWeather() == Weather.RUNEY) {
            int tries = Minecraft.getInstance().options.particles().get() != ParticleStatus.ALL ? 1 : 2;
            for (int i = 0; i < tries; ++i) {
                entity.level().addParticle((ParticleOptions)RuneCraftoryParticles.RUNEY.get(), entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 24.0, entity.getY() + (entity.getRandom().nextDouble() - 0.5) * 12.0, entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 24.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean invis(LivingEntity entity) {
        return ((EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get((Object)entity)).isInvisible();
    }

    public static void renderShaking(Camera camera, float yaw, float pitch, float roll, float partialTicks, Consumer<Float> setYaw, Consumer<Float> setPitch, Consumer<Float> setRoll) {
        int t;
        boolean stunned = Minecraft.getInstance().player.hasEffect(RuneCraftoryEffects.STUNNED.asHolder());
        if (stunned) {
            float pT = ((float)Minecraft.getInstance().player.tickCount - partialTicks) * 24.0f % 1000.0f;
            setYaw.accept(Float.valueOf(yaw + Mth.sin((float)pT) * 0.5f));
            setPitch.accept(Float.valueOf(pitch + Mth.sin((float)(pT * 2.0f)) * 1.0f));
        }
        if ((t = ShakeHandler.shakeTick) <= 0) {
            return;
        }
        float strengthPitch = ShakeHandler.shakeStrength * ClientConfig.screenShakeIntensity;
        float strengthRoll = ShakeHandler.shakeStrength * ClientConfig.screenShakeIntensity;
        float pT = ((float)t - partialTicks) * 24.0f;
        setPitch.accept(Float.valueOf(pitch + Mth.sin((float)(pT * 2.0f)) * strengthPitch));
        setRoll.accept(Float.valueOf(roll + Mth.sin((float)pT) * strengthRoll));
    }

    public static void renderEntityShake(LivingEntity entity, PoseStack stack, float partialTicks) {
        boolean stunned = entity.hasEffect(RuneCraftoryEffects.STUNNED.asHolder());
        if (!stunned) {
            return;
        }
        float yRot = Mth.lerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        Vec3 dir = Vec3.directionFromRotation((float)0.0f, (float)(yRot + 90.0f)).scale(0.1);
        float pT = Mth.sin((float)(((float)entity.tickCount - partialTicks) * 10.0f % 1000.0f));
        stack.translate((double)pT * dir.x(), 0.0, (double)pT * dir.z());
    }

    public static void onBlockHighlightRender(Level level, PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getMainHandItem().getItem() instanceof ItemFertilizer) {
            boolean targetingCrop = level.getBlockState(pos).getBlock() instanceof BushBlock;
            ItemFertilizer.getOtherForTargeted(entity.getDirection(), pos).forEach(p -> {
                BlockState state1 = level.getBlockState(p);
                if (targetingCrop && state1.isAir()) {
                    p = p.below();
                    state1 = level.getBlockState(p);
                }
                if (!state1.isAir() && level.getWorldBorder().isWithinBounds(p)) {
                    ClientCalls.renderShape(poseStack, consumer, state1.getShape((BlockGetter)level, p, CollisionContext.of((Entity)entity)), (double)p.getX() - camX, (double)p.getY() - camY, (double)p.getZ() - camZ, 0.0f, 0.0f, 0.0f, 0.4f);
                }
            });
        }
    }

    private static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = poseStack.last();
        shape.forAllEdges((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.sqrt((float)(q * q + r * r + s * s));
            consumer.addVertex(pose, (float)(k + x), (float)(l + y), (float)(m + z)).setColor(red, green, blue, alpha).setNormal(pose, q /= t, r /= t, s /= t);
            consumer.addVertex(pose, (float)(n + x), (float)(o + y), (float)(p + z)).setColor(red, green, blue, alpha).setNormal(pose, q, r, s);
        });
    }
}

