/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.client.TriggerKeyBind;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.client.gui.FarmlandInfo;
import io.github.flemmli97.runecraftory.client.gui.MonsterCompanionGui;
import io.github.flemmli97.runecraftory.client.gui.NPCCompanionGui;
import io.github.flemmli97.runecraftory.client.gui.NPCDialogueGui;
import io.github.flemmli97.runecraftory.client.gui.NPCGui;
import io.github.flemmli97.runecraftory.client.gui.NPCShopGui;
import io.github.flemmli97.runecraftory.client.gui.OverlayGui;
import io.github.flemmli97.runecraftory.client.gui.QuestGui;
import io.github.flemmli97.runecraftory.client.gui.SpawnEggScreen;
import io.github.flemmli97.runecraftory.client.gui.SpellInvOverlayGui;
import io.github.flemmli97.runecraftory.client.gui.widgets.QuestToast;
import io.github.flemmli97.runecraftory.client.model.AnimatedPlayerModel;
import io.github.flemmli97.runecraftory.client.model.armor.ArmorModels;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.quests.ClientSideQuestDisplay;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.common.world.data.family.SyncedFamilyData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.phys.Vec3;

public class ClientHandlers {
    public static OverlayGui OVERLAY;
    public static SpellInvOverlayGui SPELL_DISPLAY;
    public static FarmlandInfo FARM_DISPLAY;
    public static TriggerKeyBind SPELL_1;
    public static TriggerKeyBind SPELL_2;
    public static TriggerKeyBind SPELL_3;
    public static TriggerKeyBind SPELL_4;
    private static final AnimatedPlayerModel<?> ANIMATED_PLAYER_MODEL;
    private static CameraType pastType;

    public static Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    public static float getPartialTicks() {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
    }

    public static void updateClientCalendar(Calendar.Date date, Weather weather) {
        Season prev = ClientCalendarHolder.CLIENT_CALENDAR.currentSeason();
        ClientCalendarHolder.CLIENT_CALENDAR.updateDirect(date, weather);
        if (ClientCalendarHolder.CLIENT_CALENDAR.currentSeason() != prev) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (mc.level != null) {
                int renderDist = mc.options.getEffectiveRenderDistance();
                for (int x = -renderDist; x <= renderDist; ++x) {
                    for (int y = level.getMinSection(); y < level.getSectionsCount(); ++y) {
                        for (int z = -renderDist; z <= renderDist; ++z) {
                            mc.levelRenderer.setSectionDirty(x, y, z);
                        }
                    }
                }
            }
        }
    }

    public static boolean disableMouseMove() {
        Minecraft mc = Minecraft.getInstance();
        return !(mc.player == null || !EntityUtils.isDisabled((LivingEntity)mc.player) && ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)mc.player)).getWeaponHandler().get(DataKey.FIXED_LOOK) == false || mc.screen != null && !(mc.screen instanceof AbstractContainerScreen));
    }

    public static boolean disableMouseClick() {
        Minecraft mc = Minecraft.getInstance();
        return mc.player != null && EntityUtils.isDisabled((LivingEntity)mc.player) && (mc.screen == null || mc.screen instanceof AbstractContainerScreen);
    }

    public static boolean disableScrollMouse() {
        Minecraft mc = Minecraft.getInstance();
        return !(mc.player == null || !EntityUtils.isDisabled((LivingEntity)mc.player) && !((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)mc.player)).getWeaponHandler().isItemSwapBlocked() || mc.screen != null && !(mc.screen instanceof AbstractContainerScreen));
    }

    public static boolean disableKeys(int key, int scanCode) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen instanceof ChatScreen || !EntityUtils.isDisabled((LivingEntity)mc.player)) {
            return false;
        }
        return key != 256 && !mc.options.keyUp.matches(key, scanCode) && !mc.options.keyDown.matches(key, scanCode) && !mc.options.keyLeft.matches(key, scanCode) && !mc.options.keyRight.matches(key, scanCode) && !mc.options.keyShift.matches(key, scanCode) && !mc.options.keySprint.matches(key, scanCode) && !mc.options.keyInventory.matches(key, scanCode) && !mc.options.keyChat.matches(key, scanCode) && !mc.options.keyCommand.matches(key, scanCode);
    }

    public static void recipeToast(Collection<ResourceLocation> recipes) {
        recipes.forEach(res -> Minecraft.getInstance().level.getRecipeManager().byKey(res).ifPresent(rec -> RecipeToast.addOrUpdate((ToastComponent)Minecraft.getInstance().getToasts(), (RecipeHolder)rec)));
    }

    public static void simpleToast(Component title, Component subtitle) {
        Minecraft.getInstance().getToasts().addToast((Toast)new QuestToast(title, subtitle));
    }

    public static void setToThirdPerson(boolean reset) {
        if (reset == (pastType == null)) {
            return;
        }
        if (reset) {
            Minecraft.getInstance().options.setCameraType(pastType);
            pastType = null;
        } else {
            pastType = Minecraft.getInstance().options.getCameraType();
            Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
        }
    }

    public static void trySetPerspective(LivingEntity entity, boolean flag) {
        if (entity == Minecraft.getInstance().getCameraEntity()) {
            ClientHandlers.setToThirdPerson(!flag);
        }
    }

    public static void openCompanionGui(int id, boolean fullParty, boolean hasHome) {
        Entity entity = Minecraft.getInstance().level.getEntity(id);
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (!Minecraft.getInstance().player.getUUID().equals(monster.getOwnerUUID())) {
                return;
            }
            Minecraft.getInstance().setScreen((Screen)new MonsterCompanionGui(monster, fullParty, hasHome));
        }
    }

    public static void openNPCChat(int id, ShopState isShopOpen, SyncedFamilyData family, int followState, Map<String, List<Component>> actions, ResourceLocation quest) {
        Entity entity = Minecraft.getInstance().level.getEntity(id);
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            if (followState == 1) {
                Minecraft.getInstance().setScreen((Screen)new NPCCompanionGui(npc, isShopOpen == ShopState.OPEN, quest));
            } else {
                Minecraft.getInstance().setScreen(new NPCGui<NPCEntity>(npc, isShopOpen, followState == 0, family, actions, quest));
            }
        }
    }

    public static void handleShopRespone(Component txt) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof NPCShopGui) {
            NPCShopGui shop = (NPCShopGui)screen;
            if (txt != null) {
                shop.drawBubble(txt);
            } else {
                shop.updateButtons();
            }
        }
    }

    public static AnimatedPlayerModel<?> getAnimatedPlayerModel() {
        return ANIMATED_PLAYER_MODEL;
    }

    public static void initNonRendererModels(EntityRendererProvider.Context ctx) {
        ArmorModels.initArmorModels(ctx);
    }

    public static void updateCurrentRecipeIndex(int index) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CraftingGui) {
            CraftingGui gui = (CraftingGui)screen;
            gui.setSelectedRecipe(index);
        }
    }

    public static void handleTriggers(S2CTriggers.TriggerType type, BlockPos pos) {
        switch (type) {
            case FERTILIZER: {
                ClientLevel level = Minecraft.getInstance().level;
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 1.25;
                double z = (double)pos.getZ() + 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x, y, z, 0.0, 0.0, 0.0);
                RandomSource random = level.getRandom();
                for (int i = 0; i < 15; ++i) {
                    double nZ;
                    double nY;
                    double nX = x - 0.5 + random.nextDouble();
                    if (level.getBlockState(BlockPos.containing((double)nX, (double)(nY = y - 0.35 + random.nextDouble() * 0.5), (double)(nZ = z - 0.5 + random.nextDouble())).below()).isAir()) continue;
                    level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, nX, nY, nZ, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02);
                }
                break;
            }
        }
    }

    public static void updateNPCDialogue(NPCEntity npc, ConversationContext convCtx, String conversationID, Component component, Map<String, Component> data, List<Component> actions) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof NPCDialogueGui) {
            NPCDialogueGui gui = (NPCDialogueGui)screen;
            gui.updateConversation(Minecraft.getInstance(), convCtx, conversationID, component, data, actions);
        } else {
            NPCDialogueGui<NPCEntity> gui = new NPCDialogueGui<NPCEntity>(npc);
            gui.updateConversation(Minecraft.getInstance(), convCtx, conversationID, component, data, actions);
            Minecraft.getInstance().setScreen(gui);
        }
    }

    public static void openQuestGui(boolean hasActive, List<ClientSideQuestDisplay> quests) {
        Minecraft.getInstance().setScreen((Screen)new QuestGui(hasActive, quests));
    }

    public static void openSpawneggGui(InteractionHand hand) {
        Minecraft.getInstance().setScreen((Screen)new SpawnEggScreen(hand));
    }

    public static void translateRider(PoseStack poseStack, LivingEntity entity, Entity rider) {
        Vec3 attach = rider.getVehicleAttachmentPoint((Entity)entity);
        float scale = entity.getScale();
        poseStack.scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
        poseStack.translate(attach.x(), attach.y(), attach.z());
    }

    static {
        ANIMATED_PLAYER_MODEL = new AnimatedPlayerModel();
        pastType = null;
    }
}

