/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import net.minecraft.client.model.geom.PartPose;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class TransformationHelper {
    public static PartPose withParent(PoseExtended parent, PartPose child) {
        boolean parentRotated;
        Matrix4f matrix = new Matrix4f();
        matrix.translate(parent.x, parent.y, parent.z);
        boolean bl = parentRotated = parent.xRot != 0.0f || parent.yRot != 0.0f || parent.zRot != 0.0f;
        if (parentRotated) {
            matrix.rotate((Quaternionfc)new Quaternionf().rotationZYX(parent.zRot, parent.yRot, parent.xRot));
        }
        if (parent.xScale != 1.0f || parent.yScale != 1.0f || parent.zScale != 1.0f) {
            matrix.scale(parent.xScale, parent.yScale, parent.zScale);
        }
        Vector3f pos = new Vector3f();
        matrix.transformPosition(child.x, child.y, child.z, pos);
        Vector3f rot = new Vector3f(child.xRot, child.yRot, child.zRot);
        if (parentRotated) {
            matrix.rotateZYX(rot);
            rot = matrix.getEulerAnglesZYX(new Vector3f());
        }
        return PartPose.offsetAndRotation((float)pos.x(), (float)pos.y(), (float)pos.z(), (float)rot.x(), (float)rot.y(), (float)rot.z());
    }

    public static PartPose withoutParent(PartPose parent, PartPose child) {
        boolean parentRotated;
        Matrix4f matrix = new Matrix4f();
        boolean bl = parentRotated = parent.xRot != 0.0f || parent.yRot != 0.0f || parent.zRot != 0.0f;
        if (parentRotated) {
            matrix.rotate((Quaternionfc)new Quaternionf().rotateXYZ(parent.zRot, parent.yRot, parent.xRot));
        }
        matrix.translate(-parent.x, -parent.y, -parent.z);
        Vector3f pos = new Vector3f();
        matrix.transformPosition(child.x, child.y, child.z, pos);
        Vector3f rot = new Vector3f(child.xRot, child.yRot, child.zRot);
        if (parentRotated) {
            matrix.rotateZYX(rot);
            rot = matrix.getEulerAnglesZYX(new Vector3f());
        }
        return PartPose.offsetAndRotation((float)pos.x(), (float)pos.y(), (float)pos.z(), (float)rot.x(), (float)rot.y(), (float)rot.z());
    }
}

