/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.ClientFarmlandHandler;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandDataContainer;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FarmlandInfo {
    private static final ResourceLocation TEXTURE = RuneCraftory.modRes("hud/farmland_view");
    private final Minecraft mc;

    public FarmlandInfo(Minecraft mc) {
        this.mc = mc;
    }

    public static boolean shouldShowFarmlandView(LivingEntity entity) {
        ItemStack main = entity.getMainHandItem();
        ItemStack off = entity.getOffhandItem();
        return main.has((DataComponentType)RuneCraftoryDataComponentTypes.MAGNIFYING_GLASS.get()) || off.has((DataComponentType)RuneCraftoryDataComponentTypes.MAGNIFYING_GLASS.get());
    }

    public void render(GuiGraphics graphics) {
        MutableComponent growth;
        if (!FarmlandInfo.shouldShowFarmlandView((LivingEntity)this.mc.player)) {
            return;
        }
        HitResult res = this.mc.hitResult;
        if (res == null || res.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)res;
        BlockPos pos = blockHitResult.getBlockPos();
        BlockState blockState = this.mc.level.getBlockState(pos);
        boolean cropBlock = false;
        FarmlandDataContainer data = null;
        Block block = blockState.getBlock();
        if (block instanceof Growable) {
            Growable growable = (Growable)block;
            pos = growable.getFarmlandPosition((Level)this.mc.level, pos, blockState);
            cropBlock = true;
            blockState = this.mc.level.getBlockState(pos);
        } else if (blockState.getBlock() instanceof BushBlock) {
            pos = pos.below();
            cropBlock = blockState.getBlock() instanceof Growable;
            blockState = this.mc.level.getBlockState(pos);
        }
        if (FarmlandHandler.isFarmBlock(blockState)) {
            data = ClientFarmlandHandler.INSTANCE.getData(pos);
        }
        if (data == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int sY = 61 + (cropBlock ? 40 : 0);
        int xPos = ClientConfig.farmlandPosition.positionX(this.mc.getWindow().getGuiScaledWidth(), 100, ClientConfig.farmlandX);
        int yPos = ClientConfig.farmlandPosition.positionY(this.mc.getWindow().getGuiScaledHeight(), sY, ClientConfig.farmlandY);
        graphics.blitSprite(TEXTURE, xPos, yPos, 100, sY);
        RenderSystem.defaultBlendFunc();
        yPos += 5;
        xPos += 5;
        if (cropBlock) {
            growth = Component.literal((String)(data.ageProgress() + "%"));
            if (data.ageProgress() == 100) {
                growth.withStyle(ChatFormatting.GREEN);
            }
            graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.crop.growth", (Object[])new Object[]{growth}), xPos, yPos, 0, false);
            graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.crop.level", (Object[])new Object[]{Float.valueOf(data.cropLevel())}), xPos, yPos += 10, 0, false);
            yPos += 10;
            MutableComponent giant = Component.literal((String)(data.cropSizeProgress() + "%"));
            if (data.cropSizeProgress() == 100) {
                giant.withStyle(ChatFormatting.GREEN);
            }
            graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.crop.giant", (Object[])new Object[]{giant}), xPos, yPos, 0, false);
            yPos += 10;
        }
        growth = Component.literal((String)this.formattedValue(data.growth()));
        if ((double)data.growth() <= 0.5) {
            growth.withStyle(ChatFormatting.RED);
        }
        graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.speed", (Object[])new Object[]{growth}), xPos, yPos, 0, false);
        MutableComponent health = Component.literal((String)("" + data.health()));
        if (data.health() <= 10) {
            health.withStyle(ChatFormatting.RED);
        }
        graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.health", (Object[])new Object[]{health}), xPos, yPos + 10, 0, false);
        graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.level", (Object[])new Object[]{this.formattedValue(data.quality())}), xPos, yPos + 20, 0, false);
        graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.giant", (Object[])new Object[]{this.formattedValue(data.size())}), xPos, yPos + 30, 0, false);
        graphics.drawString(this.mc.font, (Component)Component.translatable((String)"runecraftory.magnifying_glass.view.defence", (Object[])new Object[]{this.formattedValue(data.defence())}), xPos, yPos + 40, 0, false);
    }

    private String formattedValue(float f) {
        return String.format("%.2f", Float.valueOf(f));
    }
}

