/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.client.gui.CompanionGui;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.network.C2SSetMonsterBehaviour;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class MonsterCompanionGui
extends CompanionGui<BaseMonster> {
    private BaseMonster.Behaviour updatedBehaviour;
    private final boolean fullParty;
    private final boolean hasHome;

    public MonsterCompanionGui(BaseMonster entity, boolean fullParty, boolean hasHome) {
        super(entity);
        this.fullParty = fullParty;
        this.updatedBehaviour = ((BaseMonster)this.entity).behaviourState();
        this.hasHome = hasHome;
    }

    @Override
    protected void buttons() {
        int x = 2;
        int xSize = 90;
        int y = 120;
        int buttonIndex = 0;
        ArrayList<C2SSetMonsterBehaviour.Action> buttonActions = new ArrayList<C2SSetMonsterBehaviour.Action>();
        switch (this.updatedBehaviour) {
            case WANDER_HOME: {
                if (!this.fullParty) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case FOLLOW: {
                buttonActions.add(C2SSetMonsterBehaviour.Action.RIDE);
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW_DISTANCE);
                buttonActions.add(C2SSetMonsterBehaviour.Action.STAY);
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case FOLLOW_DISTANCE: {
                buttonActions.add(C2SSetMonsterBehaviour.Action.RIDE);
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                buttonActions.add(C2SSetMonsterBehaviour.Action.STAY);
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case STAY: {
                buttonActions.add(C2SSetMonsterBehaviour.Action.RIDE);
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW_DISTANCE);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case WANDER: {
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                if (!this.fullParty) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case FARM: {
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                if (!this.fullParty) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
            }
        }
        ArrayList<BiFunction<Integer, Integer, Button>> buttons = new ArrayList<BiFunction<Integer, Integer, Button>>();
        for (C2SSetMonsterBehaviour.Action action : buttonActions) {
            buttons.add((xOff, yOff) -> Button.builder((Component)Component.translatable((String)type.translation), b -> this.handlePress(type)).bounds(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).build());
        }
        if (this.minecraft.player.getMainHandItem().getItem() == RuneCraftoryItems.MOB_STAFF.get()) {
            if (this.updatedBehaviour == BaseMonster.Behaviour.WANDER) {
                buttons.add((xOff, yOff) -> Button.builder((Component)Component.translatable((String)C2SSetMonsterBehaviour.Action.CENTER.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.CENTER)).bounds(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).build());
            }
            if (this.updatedBehaviour == BaseMonster.Behaviour.FARM) {
                buttons.add((xOff, yOff) -> Button.builder((Component)Component.translatable((String)C2SSetMonsterBehaviour.Action.CENTER_FARM.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.CENTER_FARM)).bounds(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).build());
                buttons.add((xOff, yOff) -> Button.builder((Component)Component.translatable((String)C2SSetMonsterBehaviour.Action.HARVESTINV.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.HARVESTINV)).bounds(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).build());
                buttons.add((xOff, yOff) -> Button.builder((Component)Component.translatable((String)C2SSetMonsterBehaviour.Action.SEEDINV.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.SEEDINV)).bounds(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).build());
            }
        }
        for (BiFunction biFunction : buttons) {
            if (buttonIndex + 1 == buttons.size() && buttons.size() % 2 == 1) {
                this.addRenderableWidget((GuiEventListener)((Button)biFunction.apply((int)((double)(xSize + 5) * 0.5), buttonIndex / 2 * 23)));
            } else {
                this.addRenderableWidget((GuiEventListener)((Button)biFunction.apply(buttonIndex % 2 == 0 ? 0 : xSize + 6, buttonIndex / 2 * 23)));
            }
            ++buttonIndex;
        }
    }

    private void handlePress(C2SSetMonsterBehaviour.Action action) {
        LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSetMonsterBehaviour(((BaseMonster)this.entity).getId(), action));
        this.updatedBehaviour = action.behaviour;
        this.minecraft.setScreen(null);
        this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.getX(), this.minecraft.player.getY(), this.minecraft.player.getZ(), (Holder)SoundEvents.NOTE_BLOCK_PLING, SoundSource.PLAYERS, 1.0f, 1.2f);
    }
}

